/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;

public final class CMessagePlayerCapSyncPerks {
    private final Map<Perk, Integer> perks;

    public CMessagePlayerCapSyncPerks(Map<Perk, Integer> perks) {
        this.perks = perks;
    }

    static CMessagePlayerCapSyncPerks fromBytes(FriendlyByteBuf buf) {
        return new CMessagePlayerCapSyncPerks(CMessagePlayerCapSyncPerks.readPerks(buf.m_130260_()));
    }

    private static Map<Perk, Integer> readPerks(CompoundTag tag) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        if (tag != null) {
            NBTStackHelper.readPerks(perks, tag);
        }
        return perks;
    }

    static void toBytes(CMessagePlayerCapSyncPerks msg, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        NBTStackHelper.writePerks(msg.perks, tag);
        buf.m_130079_(tag);
    }

    public static class Handler {
        static void handle(final CMessagePlayerCapSyncPerks message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.setPerks(message2.perks));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

