/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.perk.PerkRegistry;

public final class CMessagePlayerCapSetPerk {
    private final Perk perk;
    private final int level;

    public CMessagePlayerCapSetPerk(Perk perk, int level) {
        this.perk = perk;
        this.level = level;
    }

    static CMessagePlayerCapSetPerk fromBytes(FriendlyByteBuf buf) {
        return new CMessagePlayerCapSetPerk(PerkRegistry.getValue(buf.m_130277_()), buf.readByte() & 0xFF);
    }

    static void toBytes(CMessagePlayerCapSetPerk msg, FriendlyByteBuf buf) {
        buf.m_130070_(PerkRegistry.getStringKey(msg.perk));
        buf.writeByte(msg.level);
    }

    public static class Handler {
        static void handle(final CMessagePlayerCapSetPerk message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                                cap.setPerk(message2.perk, message2.level);
                                Minecraft mc = Minecraft.m_91087_();
                                Screen patt1976$temp = mc.f_91080_;
                                if (patt1976$temp instanceof ScreenKnowledge) {
                                    ScreenKnowledge screen = (ScreenKnowledge)patt1976$temp;
                                    screen.updatePerkIcons();
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

