/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.ParticleMarker;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class MarkerHandler {
    public static final MarkerHandler instance = new MarkerHandler();
    private Consumer<PoseStack> renderBox;

    private MarkerHandler() {
    }

    public void update(Minecraft mc) {
        if (mc.f_91074_ == null | mc.f_91073_ == null) {
            return;
        }
        this.renderBox = null;
        if (((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            Location loc;
            ItemStack stack = mc.f_91074_.m_21205_();
            if ((ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX || TimeHelper.atInterval(TimeHelper.worldTicks(mc.f_91074_.m_9236_()), 5)) && !(loc = stack.m_150930_((Item)ModItems.grave_key) ? ModItems.grave_key.getTombPos(stack) : (stack.m_150930_((Item)ModItems.tablet_of_recall) ? ModItems.tablet_of_recall.getTombPos(stack) : (ModItems.lost_tablet.isWakeUp(stack) ? ModItems.lost_tablet.getLocation(stack) : (stack.m_150930_((Item)ModItems.villager_gift) && (!ModItems.villager_gift.isInVillageRange((Player)mc.f_91074_, stack) || ModItems.villager_gift.isTargetFound(stack)) ? ModItems.villager_gift.getCurrentTarget(stack) : (stack.m_150930_((Item)ModItems.seeker_rod) && (!ModItems.seeker_rod.isInVillageRange((Player)mc.f_91074_, stack) || ModItems.seeker_rod.isTargetFound(stack)) ? ModItems.seeker_rod.getCurrentTarget(stack) : Location.ORIGIN))))).isOrigin() && loc.isSameDimension(mc.f_91074_.m_9236_())) {
                BlockPos pos = loc.getPos();
                if (ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX) {
                    this.renderBox = poseStack -> MarkerHandler.createBox(mc, poseStack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f));
                } else {
                    boolean isFarAway;
                    float[] colors = Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f);
                    Vec3 vec = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5);
                    Vec3 vecCameraToLocation = vec.m_82546_(mc.f_91063_.m_109153_().m_90583_());
                    boolean bl = isFarAway = vecCameraToLocation.m_82553_() > 10.0;
                    if (isFarAway) {
                        vec = mc.f_91063_.m_109153_().m_90583_().m_82549_(vecCameraToLocation.m_82541_().m_82490_(10.0));
                    }
                    MarkerHandler.spawnParticle(mc, vec, isFarAway ? 1.0f : 0.5f, colors);
                }
            }
        }
    }

    public void renderBox(PoseStack poseStack) {
        if (this.renderBox != null) {
            this.renderBox.accept(poseStack);
        }
    }

    private static void spawnParticle(Minecraft mc, Vec3 vec3, float scale, float[] colors) {
        double horizontalOffset = 0.25;
        assert (mc.f_91073_ != null);
        double yOffset = (Helper.RANDOM.nextDouble() - 0.5) * 2.0;
        ParticleMarker particle = new ParticleMarker(mc.f_91073_, vec3.f_82479_ + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, vec3.f_82480_ + yOffset * 0.5, vec3.f_82481_ + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, 0.0, (double)(yOffset < 0.5 ? -1 : 1) * Helper.RANDOM.nextDouble() * 0.01, 0.0, scale, colors);
        mc.f_91061_.m_107344_((Particle)particle);
    }

    private static void createBox(Minecraft mc, PoseStack poseStack, double x, double y, double z, float[] colors) {
        Vec3 vec = new Vec3(x, y, z).m_82546_(mc.f_91063_.m_109153_().m_90583_());
        if (vec.m_82553_() > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
        }
        Vec3 vec1 = new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        Vec3 vec2 = new Vec3(vec.f_82479_ + 1.0, vec.f_82480_ + 1.0, vec.f_82481_ + 1.0);
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        GlStateManager._disableBlend();
        poseStack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172757_);
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        MarkerHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._enableDepthTest();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, PoseStack.Pose pose, double x, double y, double z, float[] colors) {
        bufferbuilder.m_252986_(pose.m_252922_(), (float)x, (float)y, (float)z).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_252939_(pose.m_252943_(), 1.0f, 1.0f, 1.0f).m_5752_();
    }
}

