/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.capability.EnhancedFamiliarImpl;
import ovh.corail.tombstone.capability.EnhancedFamiliarProvider;
import ovh.corail.tombstone.capability.FriendlyAnimalImpl;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.IEnhancedFamiliar;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ProtectedGraveGuardianImpl;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.SoulConsumerBundle;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.SpellCasterImpl;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlacedBlocksTracker;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.CMessageFamiliar;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(ServerStartingEvent event) {
        TimeHelper.init();
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            CompatibilityCosmeticArmor.instance.handle();
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            CompatibilityFirstAid.instance.handle();
        }
        BackupService.get();
        UpdaterHandler.instance.checkVersion();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        WorldHelper.clear();
        BackupService.stop();
        TamableType.clear();
        DeathHandler.INSTANCE.clear(event.getServer());
        LootHelper.clear();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).filter(cap -> cap.hasWatcherKnowledge(4)).ifPresent(cap -> {
                cap.unlockWatcherKnowledge(3);
                cap.getWatcherKnowledge().set(4, false);
            });
            ModTriggers.CHRISTMAS.trigger(player);
            ModTriggers.HALLOWEEN.trigger(player);
            ModTriggers.SPRING_BLOOM.trigger(player);
            PacketHandler.sendToPlayer(new CMessageLogin(TimeHelper.getSpecialEvent()), player);
            EntityHelper.syncPlayerCapability(player, true);
            EntityHelper.syncProtectedPlayerCapability(player);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
            if (!EntityHelper.checkInvalidPlayerForLoot((ServerPlayer)new FakePlayer(player.m_284548_(), new GameProfile(UUID.randomUUID(), "FakeTest")))) {
                player.f_8906_.m_9942_((Component)Component.m_237113_((String)"RealPlayer is not compatible with Corail Tombstone"));
            }
            try {
                Class.forName("xyz.bluspring.kilt.KiltMixinPlugin");
                player.f_8906_.m_9942_((Component)Component.m_237113_((String)"Corail Tombstone is a Forge mod"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("io.github.fabricators_of_create.porting_lib.core.PortingLib");
                player.f_8906_.m_9942_((Component)Component.m_237113_((String)"Corail Tombstone is a Forge mod"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (SupportMods.NO_HOLIDAYS.isLoaded()) {
                player.f_8906_.m_9942_((Component)Component.m_237113_((String)"No Holidays is not compatible with Corail Tombstone"));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            DeathHandler.INSTANCE.storeGroundLocation((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUseCommand(CommandEvent event) {
        if (event.isCanceled() && TombstoneCommand.is((ParseResults<CommandSourceStack>)event.getParseResults())) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server != null && event.phase == TickEvent.Phase.END) {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
                LAST_BACKUP = systemTime;
                if (!server.m_6846_().m_11314_().isEmpty()) {
                    CommandTBRecovery.saveAllPlayers(server, success -> {
                        if (((Boolean)ConfigTombstone.recovery.logAutoBackup.get()).booleanValue()) {
                            ModTombstone.LOGGER.debug((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog());
                        }
                    });
                }
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
            DeathHandler.INSTANCE.setGroundLocations(event.getServer());
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && EffectHelper.isPotionActive((LivingEntity)event.getEntity(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.m_44934_((LivingEntity)event.getEntity()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            BlockState state = event.getLevel().m_8055_(blockPos);
            return ModBlocks.isAnyGrave(state.m_60734_()) || state.m_204336_(ModTags.Blocks.grave_marbles) || state.m_60713_(ModBlocks.abandoned_grave);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getPlayer()) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            ServerLevel world = (ServerLevel)event.getLevel();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (CustomSpawner spawner : world.f_8558_) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.f_8558_ = builder.build();
            }
        }
        TamableType.init((Level)event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        Entity entity;
        ServerPlayer serverPlayer;
        MobEffectInstance boneShieldEffect;
        ServerPlayer player;
        if (event.getEntity() == null || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEntity().m_6084_() && (player = (ServerPlayer)event.getEntity()).m_6117_() && player.m_21211_().m_41720_() instanceof ItemCastableMagic && Helper.RANDOM.nextInt(10) >= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.resiliomancer) * 3) {
            EntityHelper.setGlobalItemCooldown((Player)player, player.m_21211_(), 40);
            player.m_5810_();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((Player)player, new Object[0]);
        }
        if ((boneShieldEffect = event.getEntity().m_21124_(ModEffects.bone_shield)) != null && !event.getSource().m_269533_(DamageTypeTags.f_268415_) && !event.getSource().m_276093_(DamageTypes.f_268440_) && event.getSource().m_7639_() != null) {
            LivingEntity target = event.getEntity();
            float reflectedDamages = event.getAmount() * Math.min(0.05f * (float)(boneShieldEffect.m_19564_() + 1), 1.0f);
            event.setAmount(event.getAmount() - reflectedDamages);
            target.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12511_, SoundSource.NEUTRAL, 0.5f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            Entity entity2 = event.getSource().m_7640_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker2 = (LivingEntity)entity2;
                if (reflectedDamages >= 1.0f) {
                    CallbackHandler.addFastCallback(() -> {
                        if (attacker2 != null && attacker2.m_6084_() && target != null && target.m_6084_()) {
                            Helper.hurtWithoutCooldown(attacker2, target.m_269291_().m_269374_((Entity)target), reflectedDamages);
                        }
                    });
                }
            }
        }
        if (EffectHelper.isUnstableIntangibilityActive(event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268725_) && EffectHelper.isPotionActive(event.getEntity(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268419_) && EffectHelper.isPotionActive(event.getEntity(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (event.getSource() != null && EntityHelper.isValidServerPlayer(event.getSource().m_7639_())) {
            int gladiatorLevel;
            boolean isDarknessDamage;
            serverPlayer = (ServerPlayer)event.getSource().m_7639_();
            boolean isLightDamage = event.getSource().m_276093_(ModDamages.HOLY);
            boolean bl = isDarknessDamage = !isLightDamage && (event.getSource().m_276093_(DamageTypes.f_268493_) || event.getSource().m_276093_(DamageTypes.f_268641_) || event.getSource().m_276093_(DamageTypes.f_268482_) || event.getSource().m_276093_(ModDamages.UNHOLY));
            if (isLightDamage || isDarknessDamage) {
                int alignmentLevel = serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (isLightDamage ? alignmentLevel > 0 : alignmentLevel < 0) {
                    event.setAmount(event.getAmount() * 0.5f);
                }
            }
            if ((gladiatorLevel = EntityHelper.getPerkLevelWithBonus((Player)serverPlayer, ModPerks.gladiator)) > 0) {
                event.setAmount(event.getAmount() * (1.0f + (float)gladiatorLevel * 0.05f));
            }
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            Entity entity3;
            int alignmentLevel;
            serverPlayer = (ServerPlayer)event.getEntity();
            int guardianLevel = EntityHelper.getPerkLevelWithBonus((Player)serverPlayer, ModPerks.guardian);
            if (guardianLevel > 0) {
                event.setAmount(event.getAmount() * (1.0f - (float)guardianLevel * 0.05f));
            }
            if ((alignmentLevel = serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0).intValue()) != 0 && (entity3 = event.getSource().m_7639_()) instanceof LivingEntity) {
                boolean valid;
                LivingEntity livingEntity = (LivingEntity)entity3;
                boolean bl = EntityHelper.isUndead(livingEntity) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                if (valid) {
                    float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                    if (amount < 0.5f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(amount);
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape) && WorldHelper.isValidPos(event.getEntity().m_9236_(), event.getEntity().m_20183_())) {
                event.setCanceled(true);
                return;
            }
        }
        if ((entity = event.getSource().m_7639_()) instanceof LivingEntity && !(attacker = (LivingEntity)entity).equals((Object)event.getEntity())) {
            if (EffectHelper.isPotionActive(attacker, ModEffects.diversion)) {
                EffectHelper.clearEffect(attacker, ModEffects.diversion);
            }
            if (event.getEntity().m_6336_() == MobType.f_21641_ && EffectHelper.isPotionActive(attacker, ModEffects.beyond_the_grave_bond)) {
                EffectHelper.clearEffect(attacker, ModEffects.beyond_the_grave_bond);
            }
            if (EffectHelper.isPotionActive(attacker, ModEffects.ghostly_shape)) {
                EffectHelper.clearEffect(attacker, ModEffects.ghostly_shape);
                if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)attacker);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPreventDoubleDeath(LivingDamageEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntity()) && event.getEntity().m_21224_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntity() == null || !event.getEntity().m_6084_() || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape) && WorldHelper.isValidPos(event.getEntity().m_9236_(), event.getEntity().m_20183_())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource().m_7639_() != null && event.getSource().m_7639_().getCapability(EnhancedFamiliarProvider.FAMILIAR_CAPABILITY).map(IEnhancedFamiliar::isActive).orElse(false).booleanValue()) {
            event.setAmount(event.getAmount() * 2.0f);
        }
        if (event.getEntity().m_21223_() <= event.getAmount()) {
            Location location = event.getEntity().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntity(), false);
                    return new Location(cap.getSafeLocation(event.getEntity()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                ServerLevel level;
                event.getEntity().m_21153_(event.getEntity().m_21233_());
                event.getEntity().m_183634_();
                EffectHelper.clearBadEffects(event.getEntity());
                EffectHelper.addEffect(event.getEntity(), MobEffects.f_19605_, 600);
                EffectHelper.addEffect(event.getEntity(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntity().m_20194_();
                ServerLevel serverLevel = level = server != null ? server.m_129880_(location.dim) : null;
                if (level != null && !(spawn = new SpawnHelper(level, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleport(event.getEntity(), spawn, level);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
                event.setCanceled(true);
                return;
            }
            if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
                if (EventHandler.handlePlayerDamage((ServerPlayer)event.getEntity(), event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (ModItems.receptacle_of_familiar.captureSoul(event.getEntity())) {
                event.setCanceled(true);
                event.getEntity().m_146870_();
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayer player, DamageSource source) {
        boolean requirePrevention;
        ServerLevel targetWorld = player.m_284548_();
        BlockPos playerPos = player.m_20183_();
        boolean bl = requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && WorldHelper.isOutsideWorldBorders((Level)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && WorldHelper.isOutsideBuildHeight((Level)targetWorld, playerPos);
        if (requirePrevention) {
            LangKey.MESSAGE_CONFIG_PREVENT_DEATH.sendMessage((Player)player, new Object[0]);
        } else if (ModItems.voodoo_poppet.preventDeath(player)) {
            requirePrevention = true;
        } else {
            ItemStack receptacle_of_soul = InventoryHelper.findFirstInInventory((Player)player, p -> p.m_150930_((Item)ModItems.receptacle_of_soul));
            if (!receptacle_of_soul.m_41619_()) {
                requirePrevention = true;
                receptacle_of_soul.m_41774_(1);
                LangKey.MESSAGE_SOUL_PREVENT_DEATH.sendMessage((Player)player, new Object[0]);
            }
        }
        if (requirePrevention) {
            EffectHelper.clearBadEffects((LivingEntity)player);
            player.m_21153_(player.m_21233_());
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, 10);
            player.m_183634_();
            PlayerPreference playerPreference = PlayerPreference.get(player);
            Location spawnPos = new SpawnHelper(targetWorld, WorldHelper.getCloserValidPos((Level)targetWorld, playerPos)).withPlayerPreference(playerPreference).findSpawnPlace();
            if (spawnPos.isOrigin()) {
                Location lastGroundLocation = DeathHandler.INSTANCE.getGroundLocation(player);
                if (!lastGroundLocation.isOrigin() && (targetWorld = targetWorld.m_7654_().m_129880_(lastGroundLocation.dim)) != null) {
                    spawnPos = new SpawnHelper(targetWorld, lastGroundLocation.getPos()).withPlayerPreference(playerPreference).findGravePlace();
                }
                if (spawnPos.isOrigin()) {
                    assert (player.m_20194_() != null);
                    Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.m_20194_(), player);
                    targetWorld = (ServerLevel)respawnPoint.getLeft();
                    spawnPos = new SpawnHelper(targetWorld, (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findSpawnPlace();
                }
            }
            if (!spawnPos.isOrigin()) {
                Helper.teleport(player, spawnPos, targetWorld);
            }
            return true;
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.m_5833_()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.m_7755_()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && Optional.ofNullable(event.getSource()).map(DamageSource::m_7640_).map(e -> e.m_6095_() == EntityType.f_20477_ && e.getPersistentData().m_128441_("slowing_bone")).orElse(false).booleanValue()) {
            EffectHelper.addEffect(event.getEntity(), MobEffects.f_19597_, 200);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        double modifierLowPriority = 1.0;
        if (EffectHelper.isPotionActive(event.getEntity(), ModEffects.diversion) || EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else if (EffectHelper.isPotionActive(event.getEntity(), ModEffects.beyond_the_grave_bond) && (entity = event.getLookingEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == MobType.f_21641_) {
            modifierLowPriority = 0.0;
        } else {
            MobEffectInstance bait = event.getEntity().m_21124_(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.m_19564_() + 1.0, 2.0);
            }
        }
        event.modifyVisibility(modifierLowPriority);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        int lvl;
        double modifierDiscretion = Optional.ofNullable(event.getEntity().m_21124_(ModEffects.discretion)).map(effect -> Mth.m_14008_((double)((double)(effect.m_19564_() + 1) * 0.1), (double)0.01, (double)1.0)).orElse(0.0);
        double modifierHighPriority = 1.0 - modifierDiscretion;
        if (EntityHelper.isValidPlayer((Entity)event.getEntity()) && (lvl = EntityHelper.getPerkLevelWithBonus((Player)event.getEntity(), ModPerks.shadowalker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        event.modifyVisibility(modifierHighPriority);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && !event.getEntity().m_5833_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            EntityHelper.syncPlayerCapability(player);
            EntityHelper.syncProtectedPlayerCapability(player);
            DeathHandler.INSTANCE.handleRespawn(player);
            NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((Player)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true).forEach(arg_0 -> ((ServerPlayer)player).m_7292_(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Collection originalEffects;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getOriginal()) || !EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerPlayer original = (ServerPlayer)event.getOriginal();
        original.reviveCaps();
        original.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(originalCap -> {
            CompoundTag nbt = (CompoundTag)originalCap.serializeNBT();
            if (nbt != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.deserializeNBT((Tag)nbt));
            }
        });
        original.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(originalCap -> {
            CompoundTag nbt = (CompoundTag)originalCap.serializeNBT();
            if (nbt != null) {
                player.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(cap -> cap.deserializeNBT((Tag)nbt));
            }
        });
        original.invalidateCaps();
        if (Helper.isModLoad("gravestone")) {
            original.m_150109_().f_35974_.stream().filter(stack -> "gravestone:obituary".equals(RegistryHelper.getRegistryString(stack.m_41720_()))).forEach(stack -> stack.m_41774_(stack.m_41613_()));
        }
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.m_9236_().m_46472_() == Level.f_46430_ && player.m_21220_().isEmpty() && !(originalEffects = original.m_21220_()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getEntity()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            if (!event.isCanceled() && event.getEntity() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The death event of the player " + player.m_7755_().getString() + " was canceled by another mod");
        } else {
            DeathHandler.INSTANCE.onPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHandleSoulbound(LivingDropsEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && !Helper.isRuleKeepInventory((Entity)event.getEntity())) {
            DeathHandler.INSTANCE.handleSoulbound((ServerPlayer)event.getEntity(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity()) || Helper.isRuleKeepInventory((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.m_36316_().getName() + " was canceled by another mod");
            return;
        }
        DeathHandler.INSTANCE.handleLoot(player, event.getDrops(), event.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().m_41619_() || event.getRight().m_41619_()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).map(String::trim).orElse("");
        boolean bl = valid = event.getLeft().m_150930_((Item)ModItems.grave_plate) && event.getRight().m_204117_(Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().m_150930_((Item)ModItems.grave_dust);
        if (valid) {
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().m_41777_(), newName));
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getLeft().m_150930_((Item)ModItems.grave_plate) && event.getRight().m_204117_(Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getOutput())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result;
        BlockEntity tile;
        boolean requireNerfGhostlyShape;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND && (requireNerfGhostlyShape = EffectHelper.isPotionActive((LivingEntity)event.getEntity(), ModEffects.ghostly_shape)) && (tile = event.getLevel().m_7702_(event.getPos())) != null && tile.getCapability(ForgeCapabilities.ITEM_HANDLER, null).isPresent()) {
            EffectHelper.clearEffect((LivingEntity)event.getEntity(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getEntity());
        }
        BlockState blockState = event.getLevel().m_8055_(event.getPos());
        Block block = blockState.m_60734_();
        if (!event.isCanceled() && EntityHelper.isValidPlayer(event.getEntity()) && ModBlocks.isDecorativeGrave(block) && event.getEntity().m_21206_().m_204117_(ModTags.Items.magic_books) && (result = blockState.m_60664_(event.getLevel(), event.getEntity(), event.getHand(), event.getHitVec())).m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            if (!event.getLevel().m_5776_()) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)event.getEntity(), event.getPos(), event.getEntity().m_21206_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null && event.getEntity().m_9236_().m_5776_() && TimeHelper.atInterval(event.getEntity().m_9236_(), 20)) {
            if (((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && event.getEntity().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntity());
            }
            if (event.getEntity().m_21023_(ModEffects.bone_shield)) {
                ModTombstone.PROXY.produceBoneShield(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        LivingEntity target;
        Entity entity;
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && (entity = event.getTarget()) instanceof LivingEntity && (target = (LivingEntity)entity).m_6084_()) {
            CompoundTag tag;
            TamableType tamableType;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(cap -> PacketHandler.sendToPlayer(new CMessageProtection(target.m_19879_(), cap.isActive()), player));
            target.getCapability(EnhancedFamiliarProvider.FAMILIAR_CAPABILITY).filter(IEnhancedFamiliar::isActive).ifPresent(cap -> PacketHandler.sendToPlayer(new CMessageFamiliar(target.m_19879_()), player));
            if (target instanceof Fox) {
                EntityHelper.getFriendlyOwnerId((Entity)target).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(target.m_19879_(), (UUID)uuid, false), player));
            }
            if ((tamableType = TamableType.getType((Entity)target)) == TamableType.UNDEAD) {
                EntityHelper.getServantOwnerId((Entity)target).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(target.m_19879_(), (UUID)uuid, true), player));
            }
            target.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).filter(ISpellCaster::isCasting).ifPresent(cap -> PacketHandler.sendToPlayer(new CMessageSpellCasting(target.m_19879_(), cap.getCastingColor()), player));
            for (MobEffectInstance effectInstance : target.m_21221_().values()) {
                TombstoneEffect tombstoneEffect;
                MobEffect mobEffect = effectInstance.m_19544_();
                if (!(mobEffect instanceof TombstoneEffect) || !(tombstoneEffect = (TombstoneEffect)mobEffect).isRequiringSync()) continue;
                PacketHandler.sendToPlayer(new CMessageEffectStarted(target.m_19879_(), effectInstance), player);
            }
            MobEffectInstance effectPrayer = target.m_21124_(ModEffects.prayer);
            if (effectPrayer != null && (tag = target.getPersistentData()).m_128403_("prayer") && tag.m_128425_("pray_type", 2)) {
                PacketHandler.sendToPlayer(new CMessagePrayer(target.m_19879_(), tag.m_128342_("prayer"), tag.m_128448_("pray_type"), effectPrayer.m_19557_()), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() != null) {
            MobEffect effect = event.getEffectInstance().m_19544_();
            if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight || effect == ModEffects.beyond_the_grave_bond) {
                if (!EntityHelper.isValidPlayer((Entity)event.getEntity())) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.frostbite) {
                if (!event.getEntity().m_142079_()) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.decrepitude && event.getEntity().m_6336_() == MobType.f_21641_) {
                event.setResult(Event.Result.DENY);
            }
            if (event.getEntity().m_21023_(ModEffects.purification) && EffectHelper.isBadEffect(effect)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEffectAdded(MobEffectEvent.Added event) {
        MobEffect mobEffect;
        if (!event.getEntity().m_9236_().f_46443_ && !EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEffectInstance() != null && (mobEffect = event.getEffectInstance().m_19544_()) instanceof TombstoneEffect) {
            TombstoneEffect tombstoneEffect = (TombstoneEffect)mobEffect;
            tombstoneEffect.onEffectStarted(event.getEntity(), event.getEffectInstance().m_19564_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffect mobEffect;
        if (!event.getEntity().m_9236_().f_46443_ && !EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEffectInstance() != null && (mobEffect = event.getEffectInstance().m_19544_()) instanceof TombstoneEffect) {
            TombstoneEffect tombstoneEffect = (TombstoneEffect)mobEffect;
            tombstoneEffect.onEffectFinished(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffect mobEffect;
        if (!event.getEntity().m_9236_().f_46443_ && !EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEffectInstance() != null && (mobEffect = event.getEffectInstance().m_19544_()) instanceof TombstoneEffect) {
            TombstoneEffect tombstoneEffect = (TombstoneEffect)mobEffect;
            tombstoneEffect.onEffectFinished(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        LivingEntity livingEntity;
        if (EntityHelper.isValidPlayer((Entity)event.getObject())) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider((NonNullSupplier<ITBCapability>)((NonNullSupplier)TBCapabilityDefault::new)));
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedEntityImpl::new)));
        } else if (((Entity)event.getObject()).m_6095_() == EntityType.f_20492_ || ((Entity)event.getObject()).m_6095_() == EntityType.f_20494_ || event.getObject() instanceof AbstractGolem) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(EntityHelper::getHomeLocation))));
        } else if (((Entity)event.getObject()).m_6095_() == ModEntities.grave_guardian) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedGraveGuardianImpl::new)));
            event.addCapability(SpellCasterProvider.RL, (ICapabilityProvider)new SpellCasterProvider((NonNullSupplier<ISpellCaster>)((NonNullSupplier)SpellCasterImpl::new)));
        } else if (((Entity)event.getObject()).m_6095_() == EntityType.f_20452_) {
            event.addCapability(FriendlyAnimalProvider.RL, (ICapabilityProvider)new FriendlyAnimalProvider((NonNullSupplier<IFriendlyAnimal>)((NonNullSupplier)FriendlyAnimalImpl::new)));
        } else if (TamableType.UNDEAD.is((Entity)event.getObject())) {
            event.addCapability(ServantEntityProvider.RL, (ICapabilityProvider)new ServantEntityProvider((NonNullSupplier<IServantEntity>)((NonNullSupplier)ServantEntityImpl::new)));
            event.addCapability(SpellCasterProvider.RL, (ICapabilityProvider)new SpellCasterProvider((NonNullSupplier<ISpellCaster>)((NonNullSupplier)SpellCasterImpl::new)));
        }
        Object object = event.getObject();
        if (object instanceof LivingEntity && TamableType.getType((Entity)(livingEntity = (LivingEntity)object)) != null) {
            event.addCapability(EnhancedFamiliarProvider.RL, (ICapabilityProvider)new EnhancedFamiliarProvider((NonNullSupplier<IEnhancedFamiliar>)((NonNullSupplier)EnhancedFamiliarImpl::new)));
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_150930_(Items.f_151058_)) {
            event.addCapability(SoulConsumerProvider.RL, (ICapabilityProvider)new SoulConsumerProvider(new SoulConsumerBundle()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = event.getEntity().m_20194_();
            if (server == null) {
                return;
            }
            EntityHelper.syncPlayerCapability(player);
            EntityHelper.syncProtectedPlayerCapability(player);
            Optional.ofNullable(server.m_129880_(event.getFrom())).ifPresent(fromDim -> Optional.ofNullable(server.m_129880_(event.getTo())).ifPresent(toDim -> {
                long dif = TimeHelper.worldTicks((Level)toDim) - TimeHelper.worldTicks((Level)fromDim);
                if (dif != 0L) {
                    CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                    IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.m_150930_((Item)ModItems.lost_tablet)).forEach(stack -> ModItems.lost_tablet.setCooldown((Level)toDim, (ItemStack)stack, ModItems.lost_tablet.getCooldown((Level)fromDim, (ItemStack)stack)));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack = event.getEntity().m_21120_(event.getHand());
        if (heldStack.m_150930_((Item)ModItems.gift) || heldStack.m_150930_((Item)ModItems.smoke_ball) || heldStack.m_150930_((Item)ModItems.dust_of_vanishing) || heldStack.m_150930_((Item)ModItems.dust_of_frost)) {
            event.setCancellationResult(heldStack.m_41682_(event.getLevel(), event.getEntity(), event.getHand()).m_19089_());
            event.setCanceled(true);
            return;
        }
        if (event.getTarget() instanceof LivingEntity && (heldStack.m_41720_() instanceof ItemCastableMagic || event.getHand() == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)ModItems.bone_needle))) {
            event.setCancellationResult(heldStack.m_41647_(event.getEntity(), (LivingEntity)event.getTarget(), event.getHand()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldStack = event.getEntity().m_21205_();
        if (heldStack.m_150930_((Item)ModItems.ankh_of_prayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)cap.getTotalPerkPoints() * 0.1f))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Cloud cloud;
        ItemStack stack;
        if (event.getProjectile() != null && EntityType.f_20477_ == event.getProjectile().m_6095_() && event.getProjectile() instanceof Snowball && (stack = ((Snowball)event.getProjectile()).m_7846_()).m_150930_((Item)ModItems.smoke_ball) && (cloud = (Cloud)ModEntities.cloud.m_20615_(event.getProjectile().m_9236_())) != null) {
            event.getProjectile().m_146870_();
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.STOP_AT_CURRENT_NO_DAMAGE);
            cloud.setColor(ModItems.smoke_ball.getColor(stack, 0));
            cloud.m_146884_(event.getProjectile().m_20182_());
            event.getProjectile().m_9236_().m_7967_((Entity)cloud);
            stack.m_41774_(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            if (pathfinderMob instanceof Fox) {
                pathfinderMob.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).filter(IFriendlyAnimal::isActive).ifPresent(cap -> cap.setAI(pathfinderMob));
            } else if (PrayerHelper.isValidUndead((Entity)pathfinderMob)) {
                pathfinderMob.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).filter(IServantEntity::isActive).ifPresent(cap -> cap.setAI(pathfinderMob));
            } else if (pathfinderMob instanceof AbstractGolem) {
                AbstractGolem abstractGolem = (AbstractGolem)pathfinderMob;
                abstractGolem.f_21346_.m_148105_().stream().map(WrappedGoal::m_26015_).filter(NearestAttackableTargetGoal.class::isInstance).map(NearestAttackableTargetGoal.class::cast).filter(g -> Mob.class.equals((Object)g.f_26048_)).forEach(g -> {
                    Predicate<LivingEntity> predic = e -> !EntityHelper.isServant((Entity)e);
                    g.f_26051_.f_26879_ = g.f_26051_.f_26879_ == null ? predic : g.f_26051_.f_26879_.and(predic);
                });
            }
            pathfinderMob.getCapability(EnhancedFamiliarProvider.FAMILIAR_CAPABILITY).filter(IEnhancedFamiliar::isActive).ifPresent(cap -> cap.applyAttributes((LivingEntity)pathfinderMob));
        }
    }

    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.ITEMS, "tombstone")) {
            String path = mapping.getKey().m_135815_();
            if (path.equals("ankh_of_pray")) {
                mapping.remap((Object)ModItems.ankh_of_prayer);
                continue;
            }
            if (path.equals("familiar_stone")) {
                mapping.remap((Object)ModItems.gemstone_of_familiar);
                continue;
            }
            if (path.equals("guardian_stone")) {
                mapping.remap((Object)ModItems.gemstone_of_guardian);
                continue;
            }
            if (path.equals("merchant_stone")) {
                mapping.remap((Object)ModItems.gemstone_of_merchant);
                continue;
            }
            if (path.equals("prayer_stone")) {
                mapping.remap((Object)ModItems.gemstone_of_prayer);
                continue;
            }
            if (path.equals("soul_receptacle")) {
                mapping.remap((Object)ModItems.receptacle_of_soul);
                continue;
            }
            if (!path.equals("familiar_receptacle")) continue;
            mapping.remap((Object)ModItems.receptacle_of_familiar);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityHeal(LivingHealEvent event) {
        MobEffectInstance effectInstance = event.getEntity().m_21124_(ModEffects.incurable);
        if (effectInstance != null) {
            if (effectInstance.m_19564_() >= 9) {
                event.setCanceled(true);
            } else {
                event.setAmount(event.getAmount() * (1.0f - Math.min(0.1f * (float)(effectInstance.m_19564_() + 1), 1.0f)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onStartingLivingConversion(LivingConversionEvent.Pre event) {
        if (EntityHelper.isServant((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCriticalHit(CriticalHitEvent event) {
        int amplifier;
        ItemStack mainHandStack = event.getEntity().m_21205_();
        if (!mainHandStack.m_41619_() && (amplifier = event.getEntity().m_21205_().getEnchantmentLevel(ModEnchantments.ruthless_strike)) > 0) {
            event.setDamageModifier(event.getDamageModifier() * (1.0f + (float)amplifier * 0.15f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerLevelTick(TickEvent.LevelTickEvent event) {
        if (!TimeHelper.isDateAroundSpringBloom() || event.phase != TickEvent.Phase.END || event.level == null || event.level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.level;
        ServerLevel overworld = serverLevel.m_7654_().m_129783_();
        if (overworld.m_46461_() || (double)overworld.m_46942_(0.0f) != 0.5) {
            return;
        }
        EventHandler.generateThornVeil(serverLevel, false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (TimeHelper.isDateAroundSpringBloom() && EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            MinecraftServer server = serverPlayer.m_20194_();
            assert (server != null);
            if (serverPlayer.equals(server.m_6846_().m_11314_().get(0))) {
                server.m_129785_().forEach(serverLevel -> EventHandler.generateThornVeil(serverLevel, true));
            }
        }
    }

    private static void generateThornVeil(ServerLevel serverLevel, boolean wasSleeping) {
        new CopyOnWriteArrayList(serverLevel.f_151512_).stream().filter(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).f_156444_).f_156428_;
                return ModBlocks.isDecorativeGrave(blockEntity.m_58900_().m_60734_());
            }
            catch (Throwable throwable) {
                return false;
            }
        }).map(TickingBlockEntity::m_142689_).forEach(pos -> {
            if (!serverLevel.m_46749_(pos)) {
                return;
            }
            int rolls = Helper.RANDOM.nextInt(3);
            for (int i = 0; i < rolls; ++i) {
                if (Helper.RANDOM.nextBoolean()) continue;
                BlockPos expectedPos = pos.m_7918_(Helper.RANDOM.nextInt(5) - 2, 0, Helper.RANDOM.nextInt(5) - 2);
                BlockState flower = ModBlocks.thornveil.m_49966_();
                BlockPos spawnPos = null;
                for (int y = 1; y > -2; --y) {
                    BlockState currentState;
                    BlockPos currentPos = expectedPos.m_7918_(0, y, 0);
                    if (!serverLevel.m_46749_(currentPos) || !(currentState = serverLevel.m_8055_(currentPos)).m_60795_() && !currentState.m_247087_() || !flower.m_60710_((LevelReader)serverLevel, currentPos)) continue;
                    spawnPos = currentPos;
                    break;
                }
                if (spawnPos == null) continue;
                serverLevel.m_46597_(spawnPos, flower);
                if (wasSleeping) continue;
                for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                    if (!(serverPlayer.m_20238_(spawnPos.m_252807_()) < 5.0)) continue;
                    ModTriggers.THORNVEIL_SPAWN.trigger(serverPlayer);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity())) {
            Item item;
            ItemStack mainHandStack;
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            if (TimeHelper.isDateAroundSpringBloom() && (mainHandStack = serverPlayer.m_21205_()).m_204117_(ModTags.Items.seeds) && (item = mainHandStack.m_41720_()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (event.getPlacedBlock().m_60713_(blockItem.m_40614_())) {
                    ModTriggers.SPRING_BLOOM_PLANTED_SEED.trigger(serverPlayer);
                }
            }
            if (event.getPlacedBlock().m_204336_(ModTags.Blocks.living_corals)) {
                int count = EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT);
                if (count < 2) {
                    return;
                }
                int radius = 3;
                PlacedBlocksTracker tracker = PlacedBlocksTracker.get(serverPlayer.m_284548_());
                boolean valid = BlockPos.m_121990_((BlockPos)serverPlayer.m_20183_().m_7918_(-radius, -1, -radius), (BlockPos)serverPlayer.m_20183_().m_7918_(radius, 1, radius)).anyMatch(pos -> {
                    if (pos.equals((Object)serverPlayer.m_20183_())) {
                        return false;
                    }
                    BlockState state = serverPlayer.m_284548_().m_8055_(pos);
                    return state.m_204336_(ModTags.Blocks.living_corals) && !tracker.contains((BlockPos)pos);
                });
                if (valid) {
                    int plantedCorals;
                    tracker.isValidCoral = true;
                    int healedCorals = EntityHelper.getCustomStat(serverPlayer, ModStats.HEALED_CORAL);
                    if (healedCorals > (plantedCorals = EntityHelper.getCustomStat(serverPlayer, ModStats.PLANTED_CORAL))) {
                        EntityHelper.setCustomStat(serverPlayer, ModStats.PLANTED_CORAL, ++plantedCorals);
                        serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.rewardKnowledge(serverPlayer, 1));
                        if (plantedCorals == 1) {
                            LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 3);
                        } else if (plantedCorals == 30) {
                            LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 4);
                        }
                    }
                }
            }
        }
    }
}

