/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.network.CMessageConfig;

public final class SharedConfigTombstone {
    public static final PlayerDeath player_death;
    public static final Enchantments enchantments;
    public static final Potions potions;
    public static final MagicItem magic_item;
    public static final DecorativeGrave decorative_grave;
    public static final AllowedMagicItems allowed_magic_items;
    public static final Compatibility compatibility;
    public static final ForgeConfigSpec CONFIG_SPEC;
    private static final ImmutableList<ForgeConfigSpec.ConfigValue<Boolean>> BOOL_CONFIGS;
    private static final ImmutableList<ForgeConfigSpec.ConfigValue<Integer>> INT_CONFIGS;

    private static String getTranslation(String name) {
        return "tombstone.config." + name;
    }

    private static String getItemTranslation(String name) {
        return "tombstone.item." + name;
    }

    private static String getEffectTranslation(String name) {
        return "effect.tombstone." + name;
    }

    public static CMessageConfig getUpdatePacket() {
        BitSet boolConfigs = new BitSet(BOOL_CONFIGS.size());
        for (int i = 0; i < BOOL_CONFIGS.size(); ++i) {
            boolConfigs.set(i, (Boolean)((ForgeConfigSpec.ConfigValue)BOOL_CONFIGS.get(i)).get());
        }
        int[] intConfigs = new int[INT_CONFIGS.size()];
        for (int i = 0; i < INT_CONFIGS.size(); ++i) {
            intConfigs[i] = (Integer)((ForgeConfigSpec.ConfigValue)INT_CONFIGS.get(i)).get();
        }
        return new CMessageConfig(boolConfigs, intConfigs);
    }

    public static void updateConfig(BitSet boolConfigs, int[] intConfigs) {
        int i;
        for (i = 0; i < BOOL_CONFIGS.size(); ++i) {
            ((ForgeConfigSpec.ConfigValue)BOOL_CONFIGS.get(i)).set((Object)boolConfigs.get(i));
        }
        for (i = 0; i < INT_CONFIGS.size(); ++i) {
            ((ForgeConfigSpec.ConfigValue)INT_CONFIGS.get(i)).set((Object)intConfigs[i]);
        }
    }

    static {
        BuilderHandler builder = new BuilderHandler();
        player_death = new PlayerDeath(builder);
        enchantments = new Enchantments(builder);
        potions = new Potions(builder);
        magic_item = new MagicItem(builder);
        decorative_grave = new DecorativeGrave(builder);
        allowed_magic_items = new AllowedMagicItems(builder);
        compatibility = new Compatibility(builder);
        CONFIG_SPEC = builder.build();
        BOOL_CONFIGS = builder.getBoolBuilder().build();
        INT_CONFIGS = builder.getIntBuilder().build();
    }

    public static class BuilderHandler
    extends ForgeConfigSpec.Builder {
        private final ImmutableList.Builder<ForgeConfigSpec.ConfigValue<Boolean>> boolBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<ForgeConfigSpec.ConfigValue<Integer>> intBuilder = new ImmutableList.Builder();

        private ImmutableList.Builder<ForgeConfigSpec.ConfigValue<Boolean>> getBoolBuilder() {
            return this.boolBuilder;
        }

        private ImmutableList.Builder<ForgeConfigSpec.ConfigValue<Integer>> getIntBuilder() {
            return this.intBuilder;
        }

        private ForgeConfigSpec.ConfigValue<Boolean> add(String name, String comment, boolean defaultVal) {
            return this.add(name, comment, SharedConfigTombstone.getTranslation(name), defaultVal);
        }

        private ForgeConfigSpec.ConfigValue<Boolean> add(String name, String comment, String translation, boolean defaultVal) {
            ForgeConfigSpec.BooleanValue config = this.comment(comment).translation(translation).define(name.replace(".", "_"), defaultVal);
            this.getBoolBuilder().add((Object)config);
            return config;
        }

        private ForgeConfigSpec.ConfigValue<Integer> add(String name, String comment, int defaultVal, int minVal, int maxVal) {
            ForgeConfigSpec.IntValue config = this.comment(comment).translation(SharedConfigTombstone.getTranslation(name)).defineInRange(name.replace(".", "_"), defaultVal, minVal, maxVal);
            this.getIntBuilder().add((Object)config);
            return config;
        }
    }

    public static class PlayerDeath {
        public final ForgeConfigSpec.ConfigValue<Integer> decayTime;
        public final ForgeConfigSpec.ConfigValue<Integer> xpLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> ghostlyShapeDuration;

        PlayerDeath(BuilderHandler builder) {
            builder.comment("Options related to player's death").push("player_death");
            this.decayTime = builder.add("decay_time", "The time in minutes before a grave is unlocked to anyone [-1..MAX|default:-1|disabled:-1]", -1, -1, Integer.MAX_VALUE);
            this.xpLossOnDeath = builder.add("xp_loss_on_death", "Experience lost on death [0..100|default:95]", 95, 0, 100);
            this.ghostlyShapeDuration = builder.add("ghostly_shape_duration", "The duration of the Ghostly Shape effect in seconds [0..MAX|default:120]", 120, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Enchantments {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSpectralBite;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSoulbound;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentMagicSiphon;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentPlagueBringer;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentCurseOfBones;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentBlessing;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentFrostbite;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSpectralConjurer;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentIncurableWounds;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentDecrepitude;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSanctified;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentRuthlessStrike;
        public final ForgeConfigSpec.ConfigValue<Boolean> soulboundEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> spectralBiteEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> magicSiphonEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> plagueBringerEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> curseOfBonesEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> blessingEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> frostbiteEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> spectralConjurerEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> incurableWoundsEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> decrepitudeEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> sanctifiedEnchantingTable;
        public final ForgeConfigSpec.ConfigValue<Boolean> ruthlessStrikeEnchantingTable;

        Enchantments(BuilderHandler builder) {
            builder.comment("Allows to customize or disable the enchantments").push("enchantments");
            this.enableEnchantmentSpectralBite = builder.add("enable_enchantment_spectral_bite", "Enables the enchantment Spectral Bite [false/true|default:true]", true);
            this.enableEnchantmentSoulbound = builder.add("enable_enchantment_soulbound", "Enables the enchantment Soulbound [false/true|default:true]", true);
            this.enableEnchantmentMagicSiphon = builder.add("enable_enchantment_magic_siphon", "Enables the enchantment Magic Siphon [false/true|default:true]", true);
            this.enableEnchantmentPlagueBringer = builder.add("enable_enchantment_plague_bringer", "Enables the enchantment Plague Bringer [false/true|default:true]", true);
            this.enableEnchantmentCurseOfBones = builder.add("enable_enchantment_curse_of_bones", "Enables the enchantment Curse of Bones [false/true|default:true]", true);
            this.enableEnchantmentBlessing = builder.add("enable_enchantment_blessing", "Enables the enchantment Blessing [false/true|default:true]", true);
            this.enableEnchantmentFrostbite = builder.add("enable_enchantment_frostbite", "Enables the enchantment Frostbite [false/true|default:true]", true);
            this.enableEnchantmentSpectralConjurer = builder.add("enable_enchantment_spectral_conjurer", "Enables the enchantment Spectral Conjurer [false/true|default:true]", true);
            this.enableEnchantmentIncurableWounds = builder.add("enable_enchantment_incurable_wounds", "Enables the enchantment Incurable Wounds [false/true|default:true]", true);
            this.enableEnchantmentDecrepitude = builder.add("enable_enchantment_decrepitude", "Enables the enchantment Decrepitude [false/true|default:true]", true);
            this.enableEnchantmentSanctified = builder.add("enable_enchantment_sanctified", "Enables the enchantment Sanctified [false/true|default:true]", true);
            this.enableEnchantmentRuthlessStrike = builder.add("enable_enchantment_ruthless_strike", "Enables the enchantment Ruthless Strike [false/true|default:true]", true);
            this.soulboundEnchantingTable = builder.add("soulbound_enchanting_table", "Allows Soulbound at enchanting table [false/true|default:false]", true);
            this.spectralBiteEnchantingTable = builder.add("spectral_bite_enchanting_table", "Allows Spectral Bite at enchanting table [false/true|default:false]", true);
            this.magicSiphonEnchantingTable = builder.add("magic_siphon_enchanting_table", "Allows Magic Siphon at enchanting table [false/true|default:false]", true);
            this.plagueBringerEnchantingTable = builder.add("plague_bringer_enchanting_table", "Allows Plague Bringer at enchanting table [false/true|default:false]", true);
            this.curseOfBonesEnchantingTable = builder.add("curse_of_bones_enchanting_table", "Allows Curse of Bones at enchanting table [false/true|default:false]", true);
            this.blessingEnchantingTable = builder.add("blessing_enchanting_table", "Allows Blessing at enchanting table [false/true|default:false]", true);
            this.frostbiteEnchantingTable = builder.add("frostbite_enchanting_table", "Allows Frostbite at enchanting table [false/true|default:false]", true);
            this.spectralConjurerEnchantingTable = builder.add("spectral_conjurer_enchanting_table", "Allows Spectral Conjurer at enchanting table [false/true|default:false]", true);
            this.incurableWoundsEnchantingTable = builder.add("incurable_wounds_enchanting_table", "Allows Incurable Wounds at enchanting table [false/true|default:false]", true);
            this.decrepitudeEnchantingTable = builder.add("decrepitude_enchanting_table", "Allows Decrepitude at enchanting table [false/true|default:false]", true);
            this.sanctifiedEnchantingTable = builder.add("sanctified_enchanting_table", "Allows Sanctified at enchanting table [false/true|default:false]", true);
            this.ruthlessStrikeEnchantingTable = builder.add("ruthless_strike_enchanting_table", "Allows Ruthless Strike at enchanting table [false/true|default:false]", true);
            builder.pop();
        }
    }

    public static class Potions {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowEarthlyGarden;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBait;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowFrostbite;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowDarkness;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowDiscretion;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowRestoration;

        Potions(BuilderHandler builder) {
            builder.comment("Allows to customize or disable the potions").push("potions");
            this.allowEarthlyGarden = builder.add("allow_earthly_garden", "Allows Earthly Garden [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("earthly_garden"), true);
            this.allowBait = builder.add("allow_bait", "Allows Bait [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("bait"), true);
            this.allowFrostbite = builder.add("allow_frostbite", "Allows Frostbite [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("frostbite"), true);
            this.allowDarkness = builder.add("allow_darkness", "Allows Darkness [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("darkness"), true);
            this.allowDiscretion = builder.add("allow_discretion", "Allows Discretion [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("discretion"), true);
            this.allowRestoration = builder.add("allow_restoration", "Allows Restoration [false/true|default:true]", SharedConfigTombstone.getEffectTranslation("restoration"), true);
            builder.pop();
        }
    }

    public static class MagicItem {
        public final ForgeConfigSpec.ConfigValue<Boolean> alwaysEnchantGraveKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableEnchantedGraveKeyRecipe;
        public final ForgeConfigSpec.ConfigValue<Integer> scrollDuration;
        public final ForgeConfigSpec.ConfigValue<Integer> scrollOfKnowledgeLoss;
        public final ForgeConfigSpec.ConfigValue<Integer> tabletCooldown;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownResetPerk;

        MagicItem(BuilderHandler builder) {
            builder.comment("For settings related to magic items").push("magic_item");
            this.alwaysEnchantGraveKey = builder.add("always_enchant_grave_key", "Always enchant Grave's Key [false/true|default:false]", false);
            this.disableEnchantedGraveKeyRecipe = builder.add("disable_enchanted_grave_key_recipe", "Prevents to craft Enchanted Grave Key [false/true|default:false]", "", false);
            this.scrollDuration = builder.add("scroll_duration", "Scroll duration [1200..120000|default:12000]", 12000, 1200, 120000);
            this.scrollOfKnowledgeLoss = builder.add("scroll_of_knowledge_loss", "Defines experience lost when storing experience in a Scroll of Knowledge", 0, 0, 90);
            this.tabletCooldown = builder.add("tablet_cooldown", "Cooldown in second after using a tablet [60..1200|default:300]", 300, 60, 1200);
            this.cooldownResetPerk = builder.add("cooldown_reset_perk", "The cooldown in minutes to reset the perks with the Book of Oblivion [20..1440|default:120]", 120, 20, 1440);
            builder.pop();
        }
    }

    public static class DecorativeGrave {
        public final ForgeConfigSpec.ConfigValue<Integer> prayerCooldown;

        DecorativeGrave(BuilderHandler builder) {
            builder.comment("For settings related to decorative tombs and magic items").push("decorative_grave");
            this.prayerCooldown = builder.add("prayer_cooldown", "The cooldown in minutes to pray with the Ankh [1..60|default:60]", 60, 1, 60);
            builder.pop();
        }
    }

    public static class AllowedMagicItems {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowVoodooPoppet;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowReceptacleOfFamiliar;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfDisenchantment;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPreservation;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfKnowledge;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfRecall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfHome;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfAssistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfGuard;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfCupidity;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfUnstableIntangibility;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfFeatherFall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPurification;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfTrueSight;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowLostTablet;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfReach;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfLightningResistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfFrostResistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfAquaticLife;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfMercy;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowDustOfVanishing;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowDustOfFrost;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowEnchantedBundle;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfRecycling;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfRepairing;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfMagicImpregnation;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfScribe;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfSoulbound;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfOblivion;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowSmokeBall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowSeekerRod;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowChristmasHat;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBagOfSeeds;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowMagicScroll;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGemstoneOfFamiliar;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGemstoneOfMerchant;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGemstoneOfPrayer;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGemstoneOfGuardian;

        AllowedMagicItems(BuilderHandler builder) {
            builder.comment("Allows to disable some magic items").push("allowedMagicItems");
            this.allowVoodooPoppet = builder.add("allow_voodoo_poppet", "Voodoo Poppet [false/true|default:true]", SharedConfigTombstone.getItemTranslation("voodoo_poppet"), true);
            this.allowReceptacleOfFamiliar = builder.add("allow_receptacle_of_familiar", "Receptacle of Familiar [false/true|default:true]", SharedConfigTombstone.getItemTranslation("receptacle_of_familiar"), true);
            this.allowBookOfDisenchantment = builder.add("allow_book_of_disenchantment", "Book of Disenchantment [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_disenchantment"), true);
            this.allowScrollOfPreservation = builder.add("allow_scroll_of_preservation", "Scroll of Preservation [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_preservation"), true);
            this.allowGraveKey = builder.add("allow_grave_key", "Grave's Key [false/true|default:true]", SharedConfigTombstone.getItemTranslation("grave_key"), true);
            this.allowScrollOfKnowledge = builder.add("allow_scroll_of_knowledge", "Scroll of Knowledge [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_knowledge"), true);
            this.allowTabletOfRecall = builder.add("allow_tablet_of_recall", "Tablet of Recall [false/true|default:true]", SharedConfigTombstone.getItemTranslation("tablet_of_recall"), true);
            this.allowTabletOfHome = builder.add("allow_tablet_of_home", "Tablet of Home [false/true|default:true]", SharedConfigTombstone.getItemTranslation("tablet_of_home"), true);
            this.allowTabletOfAssistance = builder.add("allow_tablet_of_assistance", "Tablet of Assistance [false/true|default:true]", SharedConfigTombstone.getItemTranslation("tablet_of_assistance"), true);
            this.allowTabletOfGuard = builder.add("allow_tablet_of_guard", "Tablet of Guard [false/true|default:true]", SharedConfigTombstone.getItemTranslation("tablet_of_guard"), true);
            this.allowTabletOfCupidity = builder.add("allow_tablet_of_cupidity", "Tablet of Cupidity [false/true|default:true]", SharedConfigTombstone.getItemTranslation("tablet_of_cupidity"), true);
            this.allowScrollOfUnstableIntangibility = builder.add("allow_scroll_of_unstable_intangibility", "Scroll of Unstable Intangibility [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_unstable_intangibility"), true);
            this.allowScrollOfFeatherFall = builder.add("allow_scroll_of_feather_fall", "Scroll of Feather Fall [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_feather_fall"), true);
            this.allowScrollOfPurification = builder.add("allow_scroll_of_purification", "Scroll of Purification [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_purification"), true);
            this.allowScrollOfTrueSight = builder.add("allow_scroll_of_true_sight", "Scroll of True Sight [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_true_sight"), true);
            this.allowLostTablet = builder.add("allow_lost_tablet", "Lost Tablet [false/true|default:true]", SharedConfigTombstone.getItemTranslation("lost_tablet"), true);
            this.allowScrollOfReach = builder.add("allow_scroll_of_reach", "Scroll of Reach [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_reach"), true);
            this.allowScrollOfLightningResistance = builder.add("allow_scroll_of_lightning_resistance", "Scroll of Lightning Resistance [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_lightning_resistance"), true);
            this.allowScrollOfFrostResistance = builder.add("allow_scroll_of_frost_resistance", "Scroll of Frost Resistance [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_frost_resistance"), true);
            this.allowScrollOfAquaticLife = builder.add("allow_scroll_of_aquatic_life", "Scroll of Aquatic Life [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_aquatic_life"), true);
            this.allowScrollOfMercy = builder.add("allow_scroll_of_mercy", "Scroll of Mercy [false/true|default:true]", SharedConfigTombstone.getItemTranslation("scroll_of_mercy"), true);
            this.allowDustOfVanishing = builder.add("allow_dust_of_vanishing", "Dust of Vanishing [false/true|default:true]", SharedConfigTombstone.getItemTranslation("dust_of_vanishing"), true);
            this.allowDustOfFrost = builder.add("allow_dust_of_frost", "Dust of Frost [false/true|default:true]", SharedConfigTombstone.getItemTranslation("dust_of_frost"), true);
            this.allowEnchantedBundle = builder.add("allow_enchanted_bundle", "Enchanted Bundle [false/true|default:true]", SharedConfigTombstone.getItemTranslation("enchanted_bundle"), true);
            this.allowBookOfRecycling = builder.add("allow_book_of_recycling", "Book of Recycling [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_recycling"), true);
            this.allowBookOfRepairing = builder.add("allow_book_of_repairing", "Book of Repairing [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_repairing"), true);
            this.allowBookOfMagicImpregnation = builder.add("allow_book_of_magic_impregnation", "Book of Magic Impregnation [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_magic_impregnation"), true);
            this.allowBookOfScribe = builder.add("allow_book_of_scribe", "Book of Scribe [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_scribe"), true);
            this.allowBookOfSoulbound = builder.add("allow_book_of_soulbound", "Book of Soulbound [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_soulbound"), true);
            this.allowBookOfOblivion = builder.add("allow_book_of_oblivion", "Book of Oblivion [false/true|default:true]", SharedConfigTombstone.getItemTranslation("book_of_oblivion"), true);
            this.allowSmokeBall = builder.add("allow_smoke_ball", "Smoke Ball [false/true|default:true]", SharedConfigTombstone.getItemTranslation("smoke_ball"), true);
            this.allowSeekerRod = builder.add("allow_seeker_rod", "Seeker Rod [false/true|default:true]", SharedConfigTombstone.getItemTranslation("seeker_rod"), true);
            this.allowChristmasHat = builder.add("allow_christmas_hat", "Christmas Hat [false/true|default:true]", SharedConfigTombstone.getItemTranslation("christmas_hat"), true);
            this.allowBagOfSeeds = builder.add("allow_bag_of_seeds", "Bag of Seeds [false/true|default:true]", SharedConfigTombstone.getItemTranslation("bag_of_seeds"), true);
            this.allowMagicScroll = builder.add("allow_magic_scroll", "Magic Scroll [false/true|default:true]", SharedConfigTombstone.getItemTranslation("magic_scroll"), true);
            this.allowGemstoneOfFamiliar = builder.add("allow_gemstone_of_familiar", "Gemstone of Familiar [false/true|default:true]", SharedConfigTombstone.getItemTranslation("gemstone_of_familiar"), true);
            this.allowGemstoneOfMerchant = builder.add("allow_gemstone_of_merchant", "Gemstone of Merchant [false/true|default:true]", SharedConfigTombstone.getItemTranslation("gemstone_of_merchant"), true);
            this.allowGemstoneOfPrayer = builder.add("allow_gemstone_of_prayer", "Gemstone of Prayer [false/true|default:true]", SharedConfigTombstone.getItemTranslation("gemstone_of_prayer"), true);
            this.allowGemstoneOfGuardian = builder.add("allow_gemstone_of_guardian", "Gemstone of Guardian [false/true|default:true]", SharedConfigTombstone.getItemTranslation("gemstone_of_guardian"), true);
            builder.pop();
        }
    }

    public static class Compatibility {
        public final ForgeConfigSpec.ConfigValue<Boolean> fixRepairCostZero;

        Compatibility(BuilderHandler builder) {
            builder.comment("Allows to enable some features related to others mods").push("compatibility");
            this.fixRepairCostZero = builder.add("fix_repair_cost_zero", "fix the RepairCost:0 added by the anvil & grindstone in nbt preventing theses items to stack [false/true|default:true]", true);
            builder.pop();
        }
    }
}

