/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.PerkBranch;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModTriggers;

public final class TBCapabilityDefault
implements ITBCapability {
    private int knowledge = 0;
    private int alignment = 0;
    private int alignmentLevel = 0;
    private final Map<Perk, Integer> perks = new ConcurrentHashMap<Perk, Integer>();
    private BitSet watcherKnowledge = new BitSet();
    private static final String KNOWLEDGE_NBT_INT = "knowledge";
    private static final String ALIGNMENT_NBT_SHORT = "alignment";
    private static final String WATCHER_KNOWLEDGE_NBT_INT_ARRAY = "watcher_knowledge";

    @Override
    public int getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(int points) {
        this.knowledge = Math.max(0, points);
    }

    @Override
    public void rewardKnowledge(ServerPlayer player, int knowledge) {
        if (EntityHelper.isValidServerPlayer(player) && knowledge > 0) {
            int newPerkPoints;
            int earnedPerkPoints;
            int oldPerkPoints = this.getTotalPerkPoints();
            this.knowledge += knowledge;
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_INCREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
            }
            if ((earnedPerkPoints = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                PacketHandler.sendToPlayer(new CMessageLevelUp(earnedPerkPoints), player);
                if (oldPerkPoints == 0) {
                    ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.MASTERY_1.trigger(player);
                }
                if (oldPerkPoints < 20 && newPerkPoints >= 20) {
                    ModTriggers.MASTERY_2.trigger(player);
                }
            }
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(this.knowledge), player);
        }
    }

    @Override
    public void rewardAlignment(ServerPlayer player, int alignment) {
        if (EntityHelper.isValidServerPlayer(player) && alignment != 0) {
            if (PlayerPreference.get(player).displayAlignmentMessage()) {
                (alignment > 0 ? LangKey.MESSAGE_INCREASE_OF : LangKey.MESSAGE_DECREASE_OF).sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_ALIGNMENT.getText(new Object[0]), Math.abs(alignment)});
            }
            if (alignment > 0 && this.alignmentLevel < 0 || alignment < 0 && this.alignmentLevel > 0) {
                alignment *= 2;
            }
            this.setAlignment(this.alignment + alignment);
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncAlignment(this.alignment), player);
        }
    }

    @Override
    public void loseKnowledge(ServerPlayer player, int points) {
        if (!EntityHelper.isValidServerPlayer(player) || points <= 0) {
            return;
        }
        int oldPerkPoints = this.getTotalPerkPoints();
        this.setKnowledge(this.knowledge - points);
        int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
        if (lostPerkPoints <= 0) {
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(this.knowledge), player);
            return;
        }
        List<Perk> orderedPerks = this.perks.keySet().stream().sorted(Comparator.comparingInt(Perk::getBranchTier).reversed()).toList();
        for (Perk perk : orderedPerks) {
            if (perk.isDisabled((Player)player)) {
                this.perks.remove(perk);
                continue;
            }
            int perkLevel = this.getPerkLevel((Player)player, perk);
            while (perkLevel > 0 && lostPerkPoints > 0) {
                int cost = perk.getCost(perkLevel);
                lostPerkPoints -= cost;
                if (--perkLevel == 0) {
                    this.perks.remove(perk);
                    continue;
                }
                this.perks.put(perk, perkLevel);
            }
            if (lostPerkPoints > 0) continue;
            break;
        }
        EntityHelper.syncPlayerCapability(player);
        if (PlayerPreference.get(player).displayKnowledgeMessage()) {
            LangKey.MESSAGE_DECREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
        }
    }

    @Override
    public int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    @Override
    public void setAlignment(int value) {
        this.alignment = Mth.m_14045_((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -5000;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 5000;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= this.getAlignmentMinValue()) {
            return -4;
        }
        if (this.alignment <= -3000) {
            return -3;
        }
        if (this.alignment <= -1500) {
            return -2;
        }
        if (this.alignment <= -500) {
            return -1;
        }
        if (this.alignment < 500) {
            return 0;
        }
        if (this.alignment < 1500) {
            return 1;
        }
        if (this.alignment < 3000) {
            return 2;
        }
        if (this.alignment < this.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    @Override
    public Map<PerkBranch, ITBCapability.BranchUsage> getUsedPointsByBranch(Player player) {
        Map usedPointsByBranch = Arrays.stream(PerkBranch.values()).collect(Collectors.toMap(Function.identity(), b -> new ITBCapability.BranchUsage(0, 0), (a, b) -> a, () -> new EnumMap(PerkBranch.class)));
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            int usedPoints = 0;
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                usedPoints += entry.getKey().getCost(i);
            }
            usedPointsByBranch.put(entry.getKey().getBranch(), ((ITBCapability.BranchUsage)usedPointsByBranch.get((Object)entry.getKey().getBranch())).add(usedPoints, entry.getValue()));
        }
        return usedPointsByBranch;
    }

    @Override
    public int getTotalUsedPerkPoints(Player player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)Mth.m_14116_((float)(this.knowledge - 1));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public void setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
    }

    @Override
    public void removePerk(Perk perk) {
        this.perks.remove(perk);
    }

    @Override
    public int getPerkLevel(Player player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(Player player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public boolean canUpgradePerk(Player player, Perk perk) {
        if (perk.isDisabled(player)) {
            return false;
        }
        if (perk.getParent() != null && this.getPerkLevel(player, perk.getParent()) == 0) {
            return false;
        }
        int perkLevel = this.getPerkLevel(player, perk);
        if (perkLevel >= perk.getLevelMax()) {
            return false;
        }
        Map<PerkBranch, ITBCapability.BranchUsage> usedPerkPointsByBranch = this.getUsedPointsByBranch(player);
        if (!EntityHelper.hasPerkBranchTierRequirement(perk, usedPerkPointsByBranch.get((Object)((Object)perk.getBranch())).perkPoints)) {
            return false;
        }
        int usedPerkPoints = usedPerkPointsByBranch.values().stream().mapToInt(u -> u.usedPoints).sum();
        return this.getTotalPerkPoints() - usedPerkPoints >= perk.getCost(perkLevel + 1);
    }

    @Override
    public boolean canDowngradePerk(Player player, Perk perk) {
        return player.m_7500_() && !perk.isDisabled(player) && this.perks.keySet().stream().noneMatch(currentPerk -> currentPerk.getParent() == perk) && this.getPerkLevel(player, perk) > 0;
    }

    @Override
    public void resetPerks(ServerPlayer player) {
        this.setPerks(new ConcurrentHashMap<Perk, Integer>());
        EntityHelper.syncPlayerCapability(player);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KNOWLEDGE_NBT_INT, this.knowledge);
        nbt.m_128376_(ALIGNMENT_NBT_SHORT, (short)this.alignment);
        nbt.m_128382_(WATCHER_KNOWLEDGE_NBT_INT_ARRAY, this.watcherKnowledge.toByteArray());
        NBTStackHelper.writePerks(this.perks, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_(KNOWLEDGE_NBT_INT, 3)) {
            this.knowledge = nbt.m_128451_(KNOWLEDGE_NBT_INT);
        }
        if (nbt.m_128425_(ALIGNMENT_NBT_SHORT, 2)) {
            this.setAlignment(nbt.m_128448_(ALIGNMENT_NBT_SHORT));
        }
        if (nbt.m_128441_(WATCHER_KNOWLEDGE_NBT_INT_ARRAY)) {
            this.watcherKnowledge = BitSet.valueOf(nbt.m_128463_(WATCHER_KNOWLEDGE_NBT_INT_ARRAY));
        }
        NBTStackHelper.readPerks(this.perks, nbt);
    }

    @Override
    public boolean hasWatcherKnowledge(int id) {
        return this.watcherKnowledge.get(id);
    }

    @Override
    public BitSet getWatcherKnowledge() {
        return this.watcherKnowledge;
    }

    @Override
    public void unlockWatcherKnowledge(int id) {
        this.watcherKnowledge.set(id, true);
    }

    @Override
    public void updateWatcherKnowledge(BitSet values) {
        this.watcherKnowledge = values;
    }
}

