/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.PerkBranch;

public abstract class Perk
implements Comparable<Perk>,
StringRepresentable {
    protected final String name;
    protected final ResourceLocation icon;
    protected final PerkBranch branch;
    protected final int branchTier;
    protected Component translation;
    protected Component description;

    public Perk(String name, PerkBranch branch, int branchTier, ResourceLocation icon) {
        this.name = name;
        this.branch = branch;
        this.branchTier = branchTier;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public PerkBranch getBranch() {
        return this.branch;
    }

    public int getBranchTier() {
        return this.branchTier;
    }

    @Nullable
    public Perk getParent() {
        return null;
    }

    public boolean isDisabled(@Nullable Player player) {
        return !this.isEnabledInConfig() || !this.hasRequiredAlignment(player);
    }

    protected boolean isEnabledInConfig() {
        return true;
    }

    protected boolean hasRequiredAlignment(@Nullable Player player) {
        return true;
    }

    public Component getDisabledInfo(@Nullable Player player) {
        return Component.m_237115_((String)(this.getTranslationKey() + ".disabled"));
    }

    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    public int getLevelBonus(Player player) {
        return 0;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public final String getTranslationKey() {
        return "tombstone.perk." + this.name;
    }

    public Component getTranslation() {
        if (this.translation == null) {
            this.translation = Component.m_237115_((String)this.getTranslationKey());
        }
        return this.translation;
    }

    public Component getDescription() {
        if (this.description == null) {
            this.description = Component.m_237115_((String)(this.getTranslationKey() + ".desc"));
        }
        return this.description;
    }

    public Component getCurrentBonusInfo(int level) {
        return Component.m_237119_();
    }

    public Component getNextBonusInfo(int nextLevel) {
        return this.getCurrentBonusInfo(nextLevel);
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public int compareTo(Perk perk) {
        return this.name.compareTo(perk.name);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.name.equals(((Perk)o).name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

