/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class TreePoolGenerator {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> generate(Structure.GenerationContext context, Holder<StructureTemplatePool> structurePool, Optional<ResourceLocation> id, int size, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        BlockPos blockPos;
        RegistryAccess dynamicRegistryManager = context.f_226621_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        StructureTemplateManager structureTemplateManager = context.f_226625_();
        LevelHeightAccessor heightLimitView = context.f_226629_();
        WorldgenRandom chunkRandom = context.f_226626_();
        Registry registry = dynamicRegistryManager.m_175515_(Registries.f_256948_);
        Rotation blockRotation = Rotation.NONE;
        StructureTemplatePool structurePool2 = (StructureTemplatePool)structurePool.m_203334_();
        StructurePoolElement structurePoolElement = structurePool2.m_227355_((RandomSource)chunkRandom);
        if (structurePoolElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            ResourceLocation identifier = id.get();
            Optional<BlockPos> optional = TreePoolGenerator.findStartingJigsawPos(structurePoolElement, identifier, pos, blockRotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.m_203543_().map(key -> key.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        BlockPos vec3i = blockPos.m_121996_((Vec3i)pos);
        BlockPos blockPos2 = pos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.m_210540_(), blockRotation, structurePoolElement.m_214015_(structureTemplateManager, blockPos2, blockRotation));
        BoundingBox blockBox = poolStructurePiece.m_73547_();
        int i = (blockBox.m_162399_() + blockBox.m_162395_()) / 2;
        int j = (blockBox.m_162401_() + blockBox.m_162398_()) / 2;
        int k = projectStartToHeightmap.isPresent() ? pos.m_123342_() + chunkGenerator.m_223221_(i, j, projectStartToHeightmap.get(), heightLimitView, context.f_226624_()) : blockPos2.m_123342_();
        int bX = Math.abs(blockBox.m_71056_() / 2);
        int bZ = Math.abs(blockBox.m_71058_() / 2);
        int l = blockBox.m_162396_() + poolStructurePiece.m_72647_();
        poolStructurePiece.m_6324_(-bX, k - l, -bZ);
        int m = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                AABB box = new AABB((double)(i - maxDistanceFromCenter), (double)(m - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(m + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelShape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)box), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox)), (BooleanOp)BooleanOp.f_82685_);
                TreePoolGenerator.generate(context.f_226624_(), size, useExpansionHack, chunkGenerator, structureTemplateManager, heightLimitView, (RandomSource)chunkRandom, (Registry<StructureTemplatePool>)registry, poolStructurePiece, list, voxelShape);
                Objects.requireNonNull(collector);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)collector).m_142679_(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> findStartingJigsawPos(StructurePoolElement pool, ResourceLocation id, BlockPos pos, Rotation rotation, StructureTemplateManager structureManager, WorldgenRandom random) {
        List list = pool.m_213638_(structureManager, pos, rotation, (RandomSource)random);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
            ResourceLocation identifier = ResourceLocation.m_135820_((String)structureBlockInfo.f_74677_().m_128461_("name"));
            if (!id.equals((Object)identifier)) continue;
            optional = Optional.of(structureBlockInfo.f_74675_());
            break;
        }
        return optional;
    }

    private static void generate(RandomState noiseConfig, int maxSize, boolean modifyBoundingBox, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, Registry<StructureTemplatePool> structurePoolRegistry, PoolElementStructurePiece firstPiece, List<PoolElementStructurePiece> pieces, VoxelShape pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<VoxelShape>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, modifyBoundingBox, heightLimitView, noiseConfig);
        }
    }

    public static boolean generate(ServerLevel world, Holder<StructureTemplatePool> structurePool, ResourceLocation id, int size, BlockPos pos, boolean keepJigsaws) {
        ChunkGenerator chunkGenerator = world.m_7726_().m_8481_();
        StructureTemplateManager structureTemplateManager = world.m_215082_();
        StructureManager structureAccessor = world.m_215010_();
        RandomSource random = world.m_213780_();
        Structure.GenerationContext context = new Structure.GenerationContext(world.m_9598_(), chunkGenerator, chunkGenerator.m_62218_(), world.m_7726_().m_214994_(), structureTemplateManager, world.m_7328_(), new ChunkPos(pos), (LevelHeightAccessor)world, biome -> true);
        Optional<Structure.GenerationStub> optional = TreePoolGenerator.generate(context, structurePool, Optional.of(id), size, pos, false, Optional.empty(), 128);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurePiecesCollector = optional.get().m_226677_();
            for (StructurePiece structurePiece : structurePiecesCollector.m_192780_().f_192741_()) {
                if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolStructurePiece = (PoolElementStructurePiece)structurePiece;
                poolStructurePiece.m_226509_((WorldGenLevel)world, structureAccessor, chunkGenerator, random, BoundingBox.m_71044_(), pos, keepJigsaws);
            }
            return true;
        }
        return false;
    }

    static final class StructurePoolGenerator {
        private final Registry<StructureTemplatePool> registry;
        private final int maxSize;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> children;
        private final RandomSource random;
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(Registry<StructureTemplatePool> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> children, RandomSource random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.children = children;
            this.random = random;
        }

        void generatePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int minY, boolean modifyBoundingBox, LevelHeightAccessor world, RandomState noiseConfig) {
            StructurePoolElement structurePoolElement = piece.m_209918_();
            BlockPos blockPos = piece.m_72646_();
            Rotation blockRotation = piece.m_6830_();
            StructureTemplatePool.Projection projection = structurePoolElement.m_210539_();
            boolean bl = projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableObject = new MutableObject<VoxelShape>();
            BoundingBox blockBox = piece.m_73547_();
            int i = blockBox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structureBlockInfo : structurePoolElement.m_213638_(this.structureTemplateManager, blockPos, blockRotation, this.random)) {
                StructurePoolElement structurePoolElement2;
                MutableObject<VoxelShape> mutableObject2;
                Direction direction = JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_());
                BlockPos blockPos2 = structureBlockInfo.f_74675_();
                BlockPos blockPos3 = blockPos2.m_121945_(direction);
                int j = blockPos2.m_123342_() - i;
                int k = -1;
                ResourceKey<StructureTemplatePool> registryKey = StructurePoolGenerator.getPoolKey(structureBlockInfo);
                Optional optional = this.registry.m_203636_(registryKey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.m_135782_());
                    continue;
                }
                Holder registryEntry = (Holder)optional.get();
                if (((StructureTemplatePool)registryEntry.m_203334_()).m_210590_() == 0 && !registryEntry.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.m_135782_());
                    continue;
                }
                Holder registryEntry2 = ((StructureTemplatePool)registryEntry.m_203334_()).m_254935_();
                if (((StructureTemplatePool)registryEntry2.m_203334_()).m_210590_() == 0 && !registryEntry2.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)registryEntry2.m_203543_().map(key -> key.m_135782_().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = blockBox.m_71051_((Vec3i)blockPos3);
                if (bl2) {
                    mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox)));
                    }
                } else {
                    mutableObject2 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.maxSize) {
                    list.addAll(((StructureTemplatePool)registryEntry.m_203334_()).m_227362_(this.random));
                }
                list.addAll(((StructureTemplatePool)registryEntry2.m_203334_()).m_227362_(this.random));
                Iterator var29 = list.iterator();
                while (var29.hasNext() && (structurePoolElement2 = (StructurePoolElement)var29.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation blockRotation2 : Rotation.m_221992_((RandomSource)this.random)) {
                        List list2 = structurePoolElement2.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, blockRotation2, this.random);
                        BoundingBox blockBox2 = structurePoolElement2.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, blockRotation2);
                        int l = modifyBoundingBox && blockBox2.m_71057_() <= 16 ? list2.stream().mapToInt(blockInfo -> {
                            if (!blockBox2.m_71051_((Vec3i)blockInfo.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)blockInfo.f_74676_())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> registryKey2 = StructurePoolGenerator.getPoolKey(blockInfo);
                            Optional optional3 = this.registry.m_203636_(registryKey2);
                            Optional<Holder> optional2 = optional3.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_254935_());
                            int o = optional3.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            int p = optional2.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            return Math.max(o, p);
                        }).max().orElse(0) : 0;
                        for (StructureTemplate.StructureBlockInfo structureBlockInfo2 : list2) {
                            int t;
                            int r;
                            int p;
                            if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structureBlockInfo, (StructureTemplate.StructureBlockInfo)structureBlockInfo2)) continue;
                            BlockPos blockPos4 = structureBlockInfo2.f_74675_();
                            BlockPos blockPos5 = blockPos3.m_121996_((Vec3i)blockPos4);
                            BoundingBox blockBox3 = structurePoolElement2.m_214015_(this.structureTemplateManager, blockPos5, blockRotation2);
                            int m = blockBox3.m_162396_();
                            StructureTemplatePool.Projection projection2 = structurePoolElement2.m_210539_();
                            boolean bl3 = projection2 == StructureTemplatePool.Projection.RIGID;
                            int n = blockPos4.m_123342_();
                            int o = j - n + JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_()).m_122430_();
                            if (bl && bl3) {
                                p = i + o;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockPos2.m_123341_(), blockPos2.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                                }
                                p = k - n;
                            }
                            int q = p - m;
                            BoundingBox blockBox4 = blockBox3.m_71045_(0, q, 0);
                            BlockPos blockPos6 = blockPos5.m_7918_(0, q, 0);
                            if (l > 0) {
                                r = Math.max(l + 1, blockBox4.m_162400_() - blockBox4.m_162396_());
                                blockBox4.m_162371_(new BlockPos(blockBox4.m_162395_(), blockBox4.m_162396_() + r, blockBox4.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox4).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                            mutableObject2.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox4)), (BooleanOp)BooleanOp.f_82685_));
                            r = piece.m_72647_();
                            int s = bl3 ? r - o : structurePoolElement2.m_210540_();
                            PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(this.structureTemplateManager, structurePoolElement2, blockPos6, s, blockRotation2, blockBox4);
                            if (bl) {
                                t = i + j;
                            } else if (bl3) {
                                t = p + n;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockPos2.m_123341_(), blockPos2.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                                }
                                t = k + o / 2;
                            }
                            piece.m_209916_(new JigsawJunction(blockPos3.m_123341_(), t - j + r, blockPos3.m_123343_(), o, projection2));
                            poolStructurePiece.m_209916_(new JigsawJunction(blockPos2.m_123341_(), t - n + s, blockPos2.m_123343_(), -o, projection));
                            this.children.add((PoolElementStructurePiece)poolStructurePiece);
                            if (minY + 1 > this.maxSize) continue block0;
                            this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, minY + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> getPoolKey(StructureTemplate.StructureBlockInfo blockInfo) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation(blockInfo.f_74677_().m_128461_("pool")));
        }
    }

    private static final class ShapedPoolStructurePiece {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> pieceShape;
        final int currentSize;

        ShapedPoolStructurePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int currentSize) {
            this.piece = piece;
            this.pieceShape = pieceShape;
            this.currentSize = currentSize;
        }
    }
}

