/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.biome.surface;

import com.mojang.serialization.Codec;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BiomeRegistry;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.worldgen.feature.SurfaceConfig;
import elocindev.eldritch_end.worldgen.util.TendrilFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class PrimordialAbyssSurface
extends Feature<SurfaceConfig> {
    public PrimordialAbyssSurface(Codec<SurfaceConfig> configCodec) {
        super(configCodec);
    }

    public boolean canPlace(WorldGenLevel world, BlockPos position) {
        return world.m_8055_(position).m_60734_() == BlockRegistry.ABYSMAL_FRONDS;
    }

    public boolean m_142674_(FeaturePlaceContext<SurfaceConfig> context) {
        int radius;
        boolean generated = false;
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        int centerX = origin.m_123341_() + world.m_213780_().m_188503_(4);
        int centerZ = origin.m_123343_() + world.m_213780_().m_188503_(4);
        if (Configs.Biome.PRIMORDIAL_ABYSS.enable_tendril_patches && world.m_213780_().m_188503_(100) <= Configs.Biome.PRIMORDIAL_ABYSS.tendril_patch_chance) {
            BlockPos targetPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos(centerX, 0, centerZ)).m_7495_();
            TendrilFactory.genRandomShape(world, targetPos, BlockRegistry.ABYSMAL_TENDRILS.m_49966_(), BlockRegistry.SUSPICIOUS_FRONDS.m_49966_());
        }
        int radiusX = radius = world.m_213780_().m_188503_(11) + 6;
        int radiusZ = radius;
        if (world.m_213780_().m_188499_()) {
            radiusX += world.m_213780_().m_188503_(4);
        } else {
            radiusZ += world.m_213780_().m_188503_(4);
        }
        for (int x = centerX - radiusX; x <= centerX + radiusX; ++x) {
            for (int z = centerZ - radiusZ; z <= centerZ + radiusZ; ++z) {
                BlockPos topPos;
                BlockPos targetPos;
                double distanceSq = (x - centerX) * (x - centerX) + (z - centerZ) * (z - centerZ);
                if (!(distanceSq <= (double)(radiusX * radiusX)) || !(distanceSq <= (double)(radiusZ * radiusZ)) || world.m_204166_(targetPos = (topPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos(x, 0, z))).m_7495_()) == BiomeRegistry.HASTURIAN_WASTES || !this.canPlace(world, targetPos)) continue;
                if (Configs.Biome.PRIMORDIAL_ABYSS.enable_roots_generation && world.m_213780_().m_188503_(100) <= Configs.Biome.PRIMORDIAL_ABYSS.roots_generation_chance) {
                    world.m_7731_(targetPos.m_7494_(), BlockRegistry.ABYSMAL_ROOTS.m_49966_(), 3);
                }
                generated = true;
            }
        }
        return generated;
    }
}

