/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.biome.surface;

import com.mojang.serialization.Codec;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.worldgen.feature.SurfaceConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HasturianWastesSurface
extends Feature<SurfaceConfig> {
    public HasturianWastesSurface(Codec<SurfaceConfig> configCodec) {
        super(configCodec);
    }

    public boolean canPlace(WorldGenLevel world, BlockPos position) {
        return world.m_8055_(position).m_60734_() == BlockRegistry.HASTURIAN_MOSS;
    }

    public boolean m_142674_(FeaturePlaceContext<SurfaceConfig> context) {
        int radius;
        boolean generated = false;
        boolean isSand = false;
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        SurfaceConfig config = (SurfaceConfig)context.m_159778_();
        BlockState blockState = ((Block)BuiltInRegistries.f_256975_.m_7745_(config.blockID())).m_49966_();
        int centerX = origin.m_123341_() + random.m_188503_(4);
        int centerZ = origin.m_123343_() + random.m_188503_(4);
        int radiusX = radius = random.m_188503_(10) + 6;
        int radiusZ = radius;
        if (random.m_188499_()) {
            isSand = true;
        }
        if (random.m_188499_()) {
            radiusX += random.m_188503_(4);
        } else {
            radiusZ += random.m_188503_(4);
        }
        for (int x = centerX - radiusX; x <= centerX + radiusX; ++x) {
            for (int z = centerZ - radiusZ; z <= centerZ + radiusZ; ++z) {
                BlockPos topPos;
                BlockPos targetPos;
                double distanceSq = (x - centerX) * (x - centerX) + (z - centerZ) * (z - centerZ);
                if (!(distanceSq <= (double)(radiusX * radiusX)) || !(distanceSq <= (double)(radiusZ * radiusZ)) || !this.canPlace(world, targetPos = (topPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos(x, 0, z))).m_7495_())) continue;
                world.m_7731_(targetPos, blockState, 3);
                if (isSand) {
                    for (int i = 0; i < 4; ++i) {
                        if (!this.canPlace(world, targetPos.m_6625_(i)) || world.m_8055_(targetPos.m_6625_(i + 1)).m_60734_() == Blocks.f_50016_) continue;
                        world.m_7731_(targetPos.m_6625_(i), BlockRegistry.HASTURIAN_SAND.m_49966_(), 3);
                    }
                } else if (Configs.Biome.HASTURIAN_WASTES.enable_grass_generation && world.m_213780_().m_188503_(100) <= Configs.Biome.HASTURIAN_WASTES.grass_generation_chance && world.m_8055_(targetPos.m_7494_()).m_60734_() == Blocks.f_50016_) {
                    world.m_7731_(targetPos.m_7494_(), BlockRegistry.HASTURIAN_GRASS.m_49966_(), 3);
                }
                if (world.m_8055_(targetPos.m_7494_()).m_60734_() == BlockRegistry.ABYSMAL_ROOTS) {
                    world.m_7731_(targetPos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                }
                generated = true;
            }
        }
        return generated;
    }
}

