/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.registry;

import elocindev.eldritch_end.api.RitualAPI;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.corruption.CorruptionDisplayTooltip;
import elocindev.eldritch_end.item.Chorb;
import elocindev.eldritch_end.item.Necronomicon;
import elocindev.eldritch_end.item.SilverKey;
import elocindev.eldritch_end.item.infusion_materials.AberrationHeartItem;
import elocindev.eldritch_end.item.infusion_materials.AberrationLimbItem;
import elocindev.eldritch_end.item.infusion_materials.EtyrIngot;
import elocindev.eldritch_end.item.infusion_templates.CorruptionTemplate;
import elocindev.eldritch_end.item.infusion_templates.EtyrTemplate;
import elocindev.eldritch_end.item.relics.Xal;
import elocindev.eldritch_end.item.spawneggs.AberrationEgg;
import elocindev.eldritch_end.item.spawneggs.DendlerEgg;
import elocindev.eldritch_end.item.spawneggs.TentacleEgg;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.registry.EntityRegistry;
import elocindev.necronomicon.api.text.TextAPI;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"eldritch_end");
    public static final Item ABERRATION_SPAWN_EGG = ItemRegistry.reg((Item)new AberrationEgg(EntityRegistry.ABERRATION, 5523823, 13068288, (Item.Properties)new FabricItemSettings()), "aberration_spawn_egg");
    public static final Item TENTACLE_SPAWN_EGG = ItemRegistry.reg((Item)new TentacleEgg(EntityRegistry.TENTACLE, 5523823, 10127280, (Item.Properties)new FabricItemSettings()), "tentacle_spawn_egg");
    public static final Item UNDEAD_TENTACLE_SPAWN_EGG = ItemRegistry.reg((Item)new TentacleEgg(EntityRegistry.UNDEAD_TENTACLE, 2695709, 8479813, (Item.Properties)new FabricItemSettings()), "undead_tentacle_spawn_egg");
    public static final Item DENDLER_SPAWN_EGG = ItemRegistry.reg((Item)new DendlerEgg(EntityRegistry.DENDLER, 2695709, 13411918, (Item.Properties)new FabricItemSettings()), "dendler_spawn_egg");
    public static final Item NECRONOMICON = ItemRegistry.reg(new Necronomicon((Item.Properties)new FabricItemSettings()), "necronomicon");
    public static final Item SILVER_KEY = ItemRegistry.reg(new SilverKey((Item.Properties)new FabricItemSettings()), "silver_key");
    public static final Item ABERRATION_LIMB = ItemRegistry.reg(new AberrationLimbItem((Item.Properties)new FabricItemSettings()), "aberration_limb");
    public static final Item OMINOUS_EYE = ItemRegistry.reg(new Item((Item.Properties)new FabricItemSettings()), "ominous_eye");
    public static final Item XAL = ItemRegistry.reg(new Xal((Item.Properties)new FabricItemSettings().maxCount(1).fireproof()), "xal");
    public static final Item PRIMORDIAL_BOAT = ItemRegistry.reg((Item)new BoatItem(false, EntityRegistry.PRIMORDIAL, (Item.Properties)new FabricItemSettings()), "primordial_boat");
    public static final Item PRIMORDIAL_CHEST_BOAT = ItemRegistry.reg((Item)new BoatItem(true, EntityRegistry.PRIMORDIAL, (Item.Properties)new FabricItemSettings()), "primordial_chest_boat");
    public static final Item CHORB_SPAWN_EGG = ItemRegistry.reg((Item)new Chorb((EntityType<? extends Mob>)EntityType.f_20454_, 16562691, 16574211, (Item.Properties)new FabricItemSettings()), "chorb_spawn_egg");
    public static final Item CORRUPTION_MENU = ItemRegistry.reg(new CorruptionDisplayTooltip((Item.Properties)new FabricItemSettings()), "corruption");
    public static final Item RAW_ETYR = ItemRegistry.reg(new Item((Item.Properties)new FabricItemSettings()), "raw_etyr");
    public static final Item ETYR_INGOT = ItemRegistry.reg(new EtyrIngot((Item.Properties)new FabricItemSettings()), "etyr_ingot");
    public static final Item ABERRATION_HEART = ItemRegistry.reg(new AberrationHeartItem((Item.Properties)new FabricItemSettings(), RitualAPI.RitualStructure.BASIC, BlockRegistry.ELDRITCH_PEDESTAL, BlockRegistry.ABYSMAL_PEDESTAL.m_49966_(), EntityRegistry.THE_FACELESS, true, List.of(new ResourceLocation("eldritch_end:primordial_abyss"))), "aberration_heart");
    private static String etyr_appliesto;
    private static String corruption_appliesto;
    public static final Item ETYR_INFUSION_TEMPLATE;
    public static final Item CORRUPTION_INFUSION_TEMPLATE;

    public static Item reg(Item instance, String id) {
        return (Item)Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)new ResourceLocation("eldritch_end", id), (Object)instance);
    }

    public static void register() {
        LOGGER.info("Registered Eldritch End items");
    }

    static {
        String string = Configs.Mechanics.INFUSIONS.etyr_infusion.can_apply_to_armor && Configs.Mechanics.INFUSIONS.etyr_infusion.can_apply_to_weapons ? "all" : (Configs.Mechanics.INFUSIONS.etyr_infusion.can_apply_to_armor ? "armor" : (etyr_appliesto = Configs.Mechanics.INFUSIONS.etyr_infusion.can_apply_to_weapons ? "weapons" : "none"));
        corruption_appliesto = Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor && Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons ? "all" : (Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor ? "armor" : (Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons ? "weapons" : "none"));
        ETYR_INFUSION_TEMPLATE = ItemRegistry.reg((Item)new EtyrTemplate((Component)Component.m_237115_((String)("infusion.eldritch_end.applies_to_" + etyr_appliesto)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), (Component)Component.m_237115_((String)"item.eldritch_end.etyr_ingot").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)" (Tier I)").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY))), (Component)TextAPI.Styles.getStaticGradient((Component)Component.m_237113_((String)"Etyr Infusion"), (int)7503970, (int)8033899), (Component)Component.m_237119_(), (Component)Component.m_237119_(), List.of(new ResourceLocation("minecraft:item/empty_slot_smithing_template_netherite_upgrade")), List.of()), "etyr_upgrade_pattern");
        CORRUPTION_INFUSION_TEMPLATE = ItemRegistry.reg((Item)new CorruptionTemplate((Component)Component.m_237115_((String)("infusion.eldritch_end.applies_to_" + corruption_appliesto)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), (Component)Component.m_237115_((String)"item.eldritch_end.aberration_limb").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)" (Tier I)").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY))), (Component)TextAPI.Styles.getStaticGradient((Component)Component.m_237113_((String)"Corruption Infusion"), (int)6310840, (int)6635967), (Component)Component.m_237119_(), (Component)Component.m_237119_(), List.of(new ResourceLocation("minecraft:item/empty_slot_smithing_template_netherite_upgrade")), List.of()), "corruption_upgrade_pattern");
    }
}

