/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.registry;

import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.worldgen.biome.HasturianWastes;
import elocindev.eldritch_end.worldgen.biome.PrimordialAbyss;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class BiomeRegistry {
    public static final ResourceKey<Biome> PRIMORDIAL_ABYSS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("eldritch_end", "primordial_abyss"));
    public static final ResourceKey<Biome> HASTURIAN_WASTES = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("eldritch_end", "hasturian_wastes"));

    public static void bootstrap(BootstapContext<Biome> biomeRegisterable) {
        biomeRegisterable.m_255272_(HASTURIAN_WASTES, (Object)HasturianWastes.createHasturianWastes());
        biomeRegisterable.m_255272_(PRIMORDIAL_ABYSS, (Object)PrimordialAbyss.createPrimordialAbyss());
    }

    public static void register() {
        HasturianWastes.load();
        PrimordialAbyss.load();
        TheEndBiomes.addHighlandsBiome(HASTURIAN_WASTES, (double)Configs.Biome.HASTURIAN_WASTES.biome_weight);
        TheEndBiomes.addHighlandsBiome(PRIMORDIAL_ABYSS, (double)Configs.Biome.PRIMORDIAL_ABYSS.biome_weight);
        if (Configs.Biome.PRIMORDIAL_ABYSS.enable_midlands) {
            TheEndBiomes.addMidlandsBiome(PRIMORDIAL_ABYSS, PRIMORDIAL_ABYSS, (double)Configs.Biome.PRIMORDIAL_ABYSS.biome_weight);
        }
        PrimordialAbyss.registerModifications();
        HasturianWastes.registerModifications();
    }

    public class SurfaceRules {
        private static final SurfaceRules.RuleSource HASTURIAN_MOSS = net.minecraft.world.level.levelgen.SurfaceRules.m_189390_((BlockState)BlockRegistry.HASTURIAN_MOSS.m_49966_());
        private static final SurfaceRules.RuleSource ABYSMAL_FRONDS = net.minecraft.world.level.levelgen.SurfaceRules.m_189390_((BlockState)BlockRegistry.ABYSMAL_FRONDS.m_49966_());

        public static SurfaceRules.RuleSource createHasturianWastes() {
            return net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{HASTURIAN_WASTES}), (SurfaceRules.RuleSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.f_189375_, (SurfaceRules.RuleSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158930_((int)50), (int)0), (SurfaceRules.RuleSource)HASTURIAN_MOSS)));
        }

        public static SurfaceRules.RuleSource createPrimordialAbyss() {
            return net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{PRIMORDIAL_ABYSS}), (SurfaceRules.RuleSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.f_189375_, (SurfaceRules.RuleSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189394_((SurfaceRules.ConditionSource)net.minecraft.world.level.levelgen.SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158930_((int)50), (int)0), (SurfaceRules.RuleSource)ABYSMAL_FRONDS)));
        }
    }
}

