/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.mixin.smithing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elocindev.eldritch_end.api.infusion.InfusableItemMaterial;
import elocindev.eldritch_end.api.infusion.InfusionAttributeHolder;
import elocindev.eldritch_end.api.infusion.InfusionTemplate;
import elocindev.eldritch_end.mixin.item.ItemAttributeAccessor;
import elocindev.eldritch_end.mixin.smithing.ForgingScreenHandlerAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingMenu.class})
public class InfusionSmithingTableMixin {
    @Shadow
    private List<ItemStack> m_280632_() {
        return null;
    }

    @Inject(method={"canInsertIntoSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void eldritch_end$canInsertIntoSlot(ItemStack stack, Slot slot, CallbackInfoReturnable<Boolean> cir) {
        switch (slot.m_150661_()) {
            case 1: {
                InfusionTemplate template;
                Item item;
                if (!(this.getMaterial().m_41720_() instanceof InfusableItemMaterial) || !((item = this.getTemplate().m_41720_()) instanceof InfusionTemplate) || !(template = (InfusionTemplate)item).isEquipmentAllowed(stack)) break;
                cir.setReturnValue((Object)true);
                break;
            }
            case 2: {
                if (!(stack.m_41720_() instanceof InfusableItemMaterial)) break;
                cir.setReturnValue((Object)true);
                break;
            }
            default: {
                return;
            }
        }
    }

    @ModifyArg(method={"getForgingSlotsManager"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/slot/ForgingSlotsManager$Builder;input(IIILjava/util/function/Predicate;)Lnet/minecraft/screen/slot/ForgingSlotsManager$Builder;", ordinal=1), index=3)
    private Predicate<?> eldritch_end$modifyBaseSlotCondition(Predicate<?> original) {
        return original.or(stack -> {
            Item patt0$temp;
            if (!(this.getMaterial().m_41720_() instanceof InfusableItemMaterial) || !((patt0$temp = this.getTemplate().m_41720_()) instanceof InfusionTemplate)) {
                return false;
            }
            InfusionTemplate template = (InfusionTemplate)patt0$temp;
            return template.isEquipmentAllowed((ItemStack)stack);
        });
    }

    @ModifyArg(method={"getForgingSlotsManager"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/slot/ForgingSlotsManager$Builder;input(IIILjava/util/function/Predicate;)Lnet/minecraft/screen/slot/ForgingSlotsManager$Builder;", ordinal=2), index=3)
    private Predicate<?> eldritch_end$modifyAdditionSlotCondition(Predicate<?> original) {
        return original.or(stack -> ((ItemStack)stack).m_41720_() instanceof InfusableItemMaterial);
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void eldritch_end$updateResult(CallbackInfo ci) {
        SmithingMenu ths = (SmithingMenu)this;
        ItemStack base = this.getTemplate();
        ItemStack candidate = this.getEquipment();
        ItemStack addition = this.getMaterial();
        if (addition.m_41619_() || base.m_41619_() || candidate.m_41619_()) {
            return;
        }
        Item item = addition.m_41720_();
        if (item instanceof InfusableItemMaterial) {
            EquipmentSlot slot;
            InfusableItemMaterial material = (InfusableItemMaterial)item;
            if (material.getInfusionTemplate() != base.m_41720_()) {
                return;
            }
            if (candidate.m_41720_() instanceof ArmorItem && !material.applyToArmor() || (candidate.m_41720_() instanceof SwordItem || candidate.m_41720_() instanceof AxeItem || candidate.m_41720_() instanceof TieredItem) && !material.applyToWeapons() || !material.isInfusable()) {
                return;
            }
            boolean isAlreadyInfused = candidate.m_41777_().m_41698_("eldritch_infusions").m_128471_("isInfused");
            if (isAlreadyInfused && !this.isUpgradeable(material, candidate.m_41777_())) {
                return;
            }
            ItemStack potentialResult = candidate.m_41777_();
            CompoundTag nbt = potentialResult.m_41698_("eldritch_infusions");
            Item item2 = potentialResult.m_41720_();
            if (item2 instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item2;
                slot = armorItem.m_40402_();
            } else {
                slot = EquipmentSlot.MAINHAND;
            }
            nbt.m_128379_("isInfused", true);
            nbt.m_128359_("currentInfusion", BuiltInRegistries.f_257033_.m_7981_((Object)addition.m_41720_()).m_135815_());
            nbt.m_128359_("materialIdentifier", BuiltInRegistries.f_257033_.m_7981_((Object)addition.m_41720_()).toString());
            HashMultimap originalModifiers = HashMultimap.create();
            originalModifiers.putAll(potentialResult.m_41638_(slot));
            HashMultimap mergedModifiers = HashMultimap.create((Multimap)originalModifiers);
            for (InfusionAttributeHolder holder : material.getInfusionAttributes()) {
                AttributeModifier newModifier = new AttributeModifier(material.getInfusionUUID(addition, slot), "Infusion modifier", holder.amount, holder.operation);
                if (holder.attribute.equals(Attributes.f_22281_) || holder.attribute.equals(Attributes.f_22283_)) {
                    Collection existingModifiers = mergedModifiers.get((Object)holder.attribute);
                    AttributeModifier toReplace = null;
                    for (AttributeModifier existingModifier : existingModifiers) {
                        if (!existingModifier.m_22209_().equals(newModifier.m_22209_())) continue;
                        toReplace = existingModifier;
                        break;
                    }
                    if (toReplace != null) {
                        mergedModifiers.remove((Object)holder.attribute, toReplace);
                        mergedModifiers.put((Object)holder.attribute, (Object)new AttributeModifier(toReplace.m_22209_(), toReplace.m_22214_(), toReplace.m_22218_() + newModifier.m_22218_(), toReplace.m_22217_()));
                        continue;
                    }
                    mergedModifiers.put((Object)holder.attribute, (Object)newModifier);
                    continue;
                }
                mergedModifiers.put((Object)holder.attribute, (Object)newModifier);
            }
            boolean useWeaponModifiers = !(potentialResult.m_41720_() instanceof ArmorItem);
            for (Map.Entry entry : mergedModifiers.entries()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                if (attribute.equals(Attributes.f_22281_)) {
                    modifier = new AttributeModifier(useWeaponModifiers ? ItemAttributeAccessor.getAttackDamageModifierId() : modifier.m_22209_(), modifier.m_22214_(), modifier.m_22218_(), modifier.m_22217_());
                } else if (attribute.equals(Attributes.f_22283_)) {
                    modifier = new AttributeModifier(useWeaponModifiers ? ItemAttributeAccessor.getAttackSpeedModifierId() : modifier.m_22209_(), modifier.m_22214_(), modifier.m_22218_(), modifier.m_22217_());
                }
                potentialResult.m_41643_(attribute, modifier, slot);
            }
            ((ForgingScreenHandlerAccessor)ths).getOutput().m_6836_(3, potentialResult);
            ci.cancel();
        }
    }

    @Inject(method={"canTakeOutput"}, at={@At(value="HEAD")}, cancellable=true)
    private void canTakeOutput(Player player, boolean present, CallbackInfoReturnable<Boolean> cir) {
        if (this.isValidInfusion()) {
            cir.setReturnValue((Object)true);
        }
    }

    private boolean isUpgradeable(InfusableItemMaterial material, ItemStack stack) {
        return material.canSwapInfusionTo().contains(stack.m_41698_("eldritch_infusions").m_128461_("materialIdentifier"));
    }

    private boolean isValidInfusion() {
        return this.getMaterial().m_41720_() instanceof InfusableItemMaterial && this.getTemplate().m_41720_() instanceof InfusionTemplate && !this.getEquipment().m_41619_();
    }

    private ItemStack getTemplate() {
        return this.m_280632_().get(0);
    }

    private ItemStack getEquipment() {
        return this.m_280632_().get(1);
    }

    private ItemStack getMaterial() {
        return this.m_280632_().get(2);
    }
}

