/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.mixin.entity.attribute;

import elocindev.eldritch_end.api.CorruptionAPI;
import elocindev.eldritch_end.corruption.corruption_effect.CEDamageTaken;
import elocindev.eldritch_end.corruption.corruption_effect.CENonCorruptionReduction;
import elocindev.eldritch_end.effects.Corruption;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class CorruptionDamageMixin {
    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void eldritch_end$damageReceived(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        CEDamageTaken cfg = CorruptionAPI.CONFIG.corruption_effects.received_damage_increment;
        if (cfg.getStartingLevel() == -1) {
            return;
        }
        LivingEntity entity = (LivingEntity)this;
        if (CorruptionAPI.getTotalCorruptionLevel(entity) < (double)cfg.getStartingLevel() || source.m_276093_(Corruption.DAMAGE)) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * cfg.getDamagePercentage()));
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void eldritch_end$inflictedDamage(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Player player;
        CENonCorruptionReduction cfg = CorruptionAPI.CONFIG.corruption_effects.non_corruption_damage_reduction;
        if (cfg.getStartingLevel() == -1) {
            return;
        }
        Entity entity = source.m_7639_();
        if (!(entity instanceof Player) || CorruptionAPI.getTotalCorruptionLevel((LivingEntity)(player = (Player)entity)) < (double)cfg.getStartingLevel() || source.m_276093_(Corruption.DAMAGE)) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * cfg.getDamagePercentage()));
    }
}

