/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.entity.faceless;

import elocindev.eldritch_end.EldritchEnd;
import elocindev.eldritch_end.client.particle.EldritchParticles;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.ItemRegistry;
import elocindev.eldritch_end.registry.SoundEffectRegistry;
import java.util.HashMap;
import mod.azure.azurelib.ai.pathing.AzureNavigation;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class FacelessEntity
extends Monster
implements GeoEntity {
    @Nullable
    Entity entityToPull;
    @Nullable
    HashMap<Player, Integer> pullTargets = new HashMap();
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossBar = (ServerBossEvent)new ServerBossEvent(Component.m_130674_((String)"\uc892"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);
    private float animationProgressTicks = 0.0f;
    private float animationDuration = 42.0f;
    private int curseThreshold = 5;
    private boolean shouldSurge = false;
    private float shadowSurgeProgress = 0.0f;
    private float shadowSurgeDuration = 94.0f;
    private float firstImpactTicks = 43.0f;
    private float secondImpactTicks = 52.0f;
    private float thirdImpactTicks = 63.0f;
    private static final float SURGE_RADIUS = 24.0f;
    private float pullDuration = 40.0f;

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (Player playerEntity : this.m_9236_().m_6443_(Player.class, new AABB(this.m_20183_()).m_82400_(32.0), entity -> true)) {
            if (playerEntity.m_21224_()) continue;
            playerEntity.m_6756_(1400);
            playerEntity.m_36356_(new ItemStack((ItemLike)ItemRegistry.XAL));
        }
    }

    public FacelessEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_21344_ = new AzureNavigation((Mob)this, world);
        this.m_274367_(1.0f);
        this.animationProgressTicks = 0.0f;
    }

    private void curse(Player target) {
        if (target == null || Math.abs((double)(this.m_20182_().f_82480_ - target.m_20182_().f_82480_)) < (double)this.curseThreshold || target.m_9236_().f_46443_) {
            return;
        }
        Vec3 rotationVector = this.m_20154_().m_82541_();
        target.m_20324_(this.m_20185_() + rotationVector.m_82490_((double)2.0).f_82479_, this.m_20186_(), this.m_20189_() + rotationVector.m_82490_((double)2.0).f_82481_);
    }

    private void shadowSurge() {
        this.m_147215_(new MobEffectInstance(MobEffects.f_19597_, (int)this.shadowSurgeDuration, 255, false, false, false), null);
        this.shadowSurgeProgress = 0.0f;
        this.shouldSurge = true;
        EldritchParticles.playEffek("shadowsurge", this.m_9236_(), this.m_20182_(), true, 0.6f).bindOnEntity((Entity)this);
    }

    private void meleeLogic() {
        if (this.animationProgressTicks < this.animationDuration) {
            this.animationProgressTicks += 1.0f;
        }
        if (this.animationProgressTicks == 18.0f) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEffectRegistry.PUNCH_EVENT, this.m_5720_(), 1.0f, 1.0f);
            this.performKeyframeAttack((Entity)this.m_5448_());
        }
    }

    private void shadowSurgeLogic() {
        if (this.shadowSurgeProgress < this.shadowSurgeDuration) {
            this.shadowSurgeProgress += 1.0f;
        } else {
            this.shouldSurge = false;
            this.shadowSurgeProgress = 0.0f;
        }
        if (this.shadowSurgeProgress == 0.0f && this.shouldSurge) {
            this.shadowSurge();
        } else if (this.shadowSurgeProgress == this.firstImpactTicks && this.shouldSurge) {
            this.shadowSurgeAttack();
        } else if (this.shadowSurgeProgress == this.secondImpactTicks && this.shouldSurge) {
            this.shadowSurgeAttack();
        } else if (this.shadowSurgeProgress == this.thirdImpactTicks && this.shouldSurge) {
            this.shadowSurgeAttack();
        }
    }

    private void shadowSurgeAttack() {
        float missingHealth = (this.m_21233_() - this.m_21223_()) / 2.0f;
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEffectRegistry.ORB_EVENT, this.m_5720_(), 1.0f, 1.0f);
        for (Player playerEntity : this.m_9236_().m_6443_(Player.class, new AABB(this.m_20183_()).m_82377_(9.0, 0.0, 9.0), entity -> true)) {
            playerEntity.m_6469_(this.m_269291_().m_269264_(), playerEntity.m_21233_() / 3.0f);
        }
    }

    private void shadowSurgeTeleport(Entity target) {
        if (target == null || this.m_9236_().f_46443_ || target.m_20270_((Entity)this) < 24.0f) {
            return;
        }
        Vec3 rotationVector = this.m_20154_().m_82541_();
        target.m_20324_(this.m_20185_() + rotationVector.m_82490_((double)2.0).f_82479_, this.m_20186_(), this.m_20189_() + rotationVector.m_82490_((double)2.0).f_82481_);
        this.shadowSurge();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        livingEntity.m_147215_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, false, false), null);
    }

    public static Vec3 lerpedPosition(Vec3 current, Vec3 desired, float timeDelta) {
        return new Vec3(Math.lerp((double)current.f_82479_, (double)desired.f_82479_, (double)timeDelta), Math.lerp((double)current.f_82480_, (double)desired.f_82480_, (double)timeDelta), Math.lerp((double)current.f_82481_, (double)desired.f_82481_, (double)timeDelta));
    }

    private void pullMove(Player target, int elapsedTicks) {
        this.pullTargets.put(target, (float)elapsedTicks <= this.pullDuration ? elapsedTicks + 1 : 0);
        Vec3 lerpedPos = FacelessEntity.lerpedPosition(target.m_20182_(), this.m_20182_(), (float)this.pullTargets.get(target).intValue() / this.pullDuration);
        target.m_20324_(lerpedPos.f_82479_, lerpedPos.f_82480_, lerpedPos.f_82481_);
    }

    private void pullLogic(Player target, int elapsedTicks) {
        if ((float)elapsedTicks < this.pullDuration && !target.m_20183_().m_203195_((Position)this.m_20182_(), 2.0)) {
            this.pullMove(target, elapsedTicks);
            this.m_20334_(0.0, 0.0, 0.0);
            target.m_20334_(0.0, 0.0, 0.0);
        } else {
            target.m_147215_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, false, false), null);
            this.pullTargets.remove(target);
            if (!this.shouldSurge) {
                this.shadowSurge();
            }
        }
        this.f_19812_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.meleeLogic();
        this.shadowSurgeLogic();
        if (this.pullTargets != null) {
            for (Player key : this.pullTargets.keySet()) {
                this.pullLogic(key, this.pullTargets.get(key));
            }
        }
        if (this.f_19797_ % 10 != 0) {
            for (Player playerEntity : this.m_9236_().m_6443_(Player.class, new AABB(this.m_20183_()).m_82400_(64.0), entity -> true)) {
                if (playerEntity.m_7500_() || !(playerEntity.m_20270_((Entity)this) > 24.0f)) continue;
                this.pullTargets.put(playerEntity, 0);
            }
        }
        if (this.f_19797_ % 400 == 0 && !this.shouldSurge) {
            this.shadowSurge();
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "baseAnim", 5, event -> event.setAndContinue(event.isMoving() ? RawAnimation.begin().thenLoop("walk") : RawAnimation.begin().thenLoop("idle")))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackAnim", event -> PlayState.CONTINUE).triggerableAnim("slam", RawAnimation.begin().then("slam", Animation.LoopType.PLAY_ONCE))});
    }

    public boolean m_7327_(Entity target) {
        if (target.m_9236_().f_46443_) {
            return false;
        }
        if (this.animationProgressTicks == this.animationDuration && !this.shouldSurge) {
            this.animationProgressTicks = 0.0f;
            this.triggerAnim("attackAnim", "slam");
            this.f_20911_ = false;
        }
        EldritchEnd.LOGGER.info("Attack!");
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, Configs.Entity.FACELESS.attributes.MAX_HEALTH).m_22268_(Attributes.f_22279_, Configs.Entity.FACELESS.attributes.MOVEMENT_SPEED).m_22268_(Attributes.f_22281_, Configs.Entity.FACELESS.attributes.ATTACK_DAMAGE).m_22268_(Attributes.f_22283_, Configs.Entity.FACELESS.attributes.ATTACK_SPEED).m_22268_(Attributes.f_22278_, 1000.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEffectRegistry.GROWL_EVENT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    private void performKeyframeAttack(Entity target) {
        if (target != null && !target.m_9236_().f_46443_) {
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
        }
    }
}

