/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.entity.arcane_missile;

import elocindev.eldritch_end.api.particles.ParticleBatch;
import elocindev.eldritch_end.api.particles.ParticleHelper;
import elocindev.eldritch_end.api.targeting.VectorHelper;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ArcaneMissile
extends ThrowableItemProjectile
implements ItemSupplier {
    static ParticleBatch FLYPARTICLES = new ParticleBatch("minecraft:dragon_breath", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 45.0f, 45.0f, 5.0f, 0.02f, 0.05f, 0.0f, 0.0f, 0.0f, false);
    public Entity target;
    public double homing_angle;

    public ArcaneMissile(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (entityHitResult.m_82443_() != null) {
                entityHitResult.m_82443_().m_6469_(this.m_269291_().m_269333_(living), (float)(living.m_21133_(Attributes.f_22281_) * (double)0.8f));
            }
        }
        super.m_5790_(entityHitResult);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
    }

    private void followTarget() {
        Entity target = this.target;
        if (target != null && this.homing_angle > 0.0) {
            Vec3 distanceVector = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
            Vec3 newVelocity = VectorHelper.rotateTowards(this.m_20184_(), distanceVector, this.homing_angle);
            if (newVelocity.m_82556_() > 0.0) {
                this.m_20256_(newVelocity);
                this.f_19812_ = true;
            }
        }
    }

    public void m_8119_() {
        if (this.m_9236_() instanceof ServerLevel) {
            ParticleHelper.sendBatches((Entity)this, new ParticleBatch[]{FLYPARTICLES}, 1.0f, PlayerLookup.tracking((Entity)this), false);
        }
        this.followTarget();
        super.m_8119_();
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.m_146870_();
    }

    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }

    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }
}

