/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.entity.aberration;

import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.corruption.CorruptionUtils;
import elocindev.eldritch_end.effects.Corruption;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.registry.EffectRegistry;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AberrationEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AberrationEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, Configs.Entity.ABERRATION.CHASE_SPEED, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, Configs.Entity.ABERRATION.WANDER_SPEED));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 20 == 0 && this.m_9236_().m_8055_(new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_())).m_60734_() == BlockRegistry.ABYSMAL_FRONDS) {
            this.m_5634_(this.m_21233_() / 10.0f);
        }
    }

    public boolean m_7327_(Entity target) {
        this.f_20911_ = true;
        if (target instanceof Player) {
            Player victim = (Player)target;
            MobEffect effect = EffectRegistry.CORRUPTION;
            if (victim.m_21023_(effect)) {
                victim.m_7292_(new MobEffectInstance(effect, victim.m_21124_(effect).m_19557_(), victim.m_21124_(effect).m_19564_() + 1, false, false));
                victim.m_6469_(Corruption.of(this.m_9236_(), Corruption.DAMAGE), CorruptionUtils.getDamageAmount((LivingEntity)victim, (float)Configs.Entity.ABERRATION.ATTACK_DAMAGE_ATTRIBUTE * 0.25f, true));
            } else {
                victim.m_7292_(new MobEffectInstance(effect, Configs.Entity.ABERRATION.initital_corruption_duration_ticks, 0, false, false));
            }
        }
        return super.m_7327_(target);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, Configs.Entity.ABERRATION.HEALTH_ATTRIBUTE).m_22268_(Attributes.f_22279_, Configs.Entity.ABERRATION.MOVEMENT_SPEED_ATTRIBUTE).m_22268_(Attributes.f_22281_, Configs.Entity.ABERRATION.ATTACK_DAMAGE_ATTRIBUTE).m_22268_(Attributes.f_22283_, Configs.Entity.ABERRATION.ATTACK_SPEED_ATTRIBUTE);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "animationPredicate", 10, event -> {
            if (this.f_20911_) {
                event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
                this.f_20911_ = false;
                return PlayState.CONTINUE;
            }
            if (event.isMoving() && this.m_20096_()) {
                event.getController().setAnimationSpeed(3.0);
                event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

