/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.datagen;

import com.google.gson.JsonElement;
import elocindev.eldritch_end.registry.ArmorRegistry;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.registry.ItemRegistry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class ModelGenerator
extends FabricModelProvider {
    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(BlockModelGenerators generator) {
        generator.m_124851_(BlockRegistry.PRIMORDIAL_LEAVES);
        generator.m_124557_(BlockRegistry.ABYSMAL_ROOTS, BlockModelGenerators.TintState.NOT_TINTED);
        generator.m_124960_(BlockRegistry.HASTURIAN_CACTUS);
        generator.m_124557_(BlockRegistry.HASTURIAN_GRASS, BlockModelGenerators.TintState.NOT_TINTED);
        generator.m_124851_(BlockRegistry.HASTURIAN_DUNE_SAND);
        generator.m_124851_(BlockRegistry.HASTURIAN_SAND);
        generator.m_124851_(BlockRegistry.ETYR_ORE);
        generator.m_124851_(BlockRegistry.CHISELED_POLISHED_SPIRE_STONE);
        generator.m_124851_(BlockRegistry.POLISHED_SPIRE_STONE);
        generator.m_124851_(BlockRegistry.CRACKED_POLISHED_SPIRE_STONE_TILES);
        generator.m_124851_(BlockRegistry.CRACKED_POLISHED_SPIRE_STONE_BRICKS);
        generator.m_124851_(BlockRegistry.POLISHED_SPIRE_STONE_BRICKS);
        generator.m_124851_(BlockRegistry.POLISHED_SPIRE_STONE_TILES);
        this.registerSlabStairSet(generator, BlockRegistry.SPIRE_STONE_SLAB, (Block)BlockRegistry.SPIRE_STONE_STAIRS, BlockRegistry.SPIRE_STONE);
        this.registerSlabStairSet(generator, BlockRegistry.POLISHED_SPIRE_STONE_SLAB, (Block)BlockRegistry.POLISHED_SPIRE_STONE_STAIRS, BlockRegistry.POLISHED_SPIRE_STONE);
        this.registerSlabStairSet(generator, BlockRegistry.POLISHED_SPIRE_STONE_BRICK_SLAB, (Block)BlockRegistry.POLISHED_SPIRE_STONE_BRICK_STAIRS, BlockRegistry.POLISHED_SPIRE_STONE_BRICKS);
        this.registerSlabStairSet(generator, BlockRegistry.POLISHED_SPIRE_STONE_TILE_SLAB, (Block)BlockRegistry.POLISHED_SPIRE_STONE_TILE_STAIRS, BlockRegistry.POLISHED_SPIRE_STONE_TILES);
        this.registerWoodset(generator, BlockRegistry.PRIMORDIAL_PLANKS, BlockRegistry.PRIMORDIAL_DOOR, BlockRegistry.PRIMORDIAL_TRAPDOOR, BlockRegistry.PRIMORDIAL_SLAB, (Block)BlockRegistry.PRIMORDIAL_STAIRS, (Block)BlockRegistry.PRIMORDIAL_BUTTON, BlockRegistry.PRIMORDIAL_FENCE, BlockRegistry.PRIMORDIAL_FENCE_GATE);
        this.registerEtyrVariant(generator, BlockRegistry.ETYR_BLOCK, BlockRegistry.ETYR_TILES, BlockRegistry.ETYR_DOOR, BlockRegistry.ETYR_TRAPDOOR, BlockRegistry.ETYR_BARS, BlockRegistry.ETYR_PILLAR, BlockRegistry.ETYR_SLAB, (Block)BlockRegistry.ETYR_STAIRS);
        this.registerEtyrVariant(generator, BlockRegistry.DECADENT_ETYR_BLOCK, BlockRegistry.DECADENT_ETYR_TILES, BlockRegistry.DECADENT_ETYR_DOOR, BlockRegistry.DECADENT_ETYR_TRAPDOOR, BlockRegistry.DECADENT_ETYR_BARS, BlockRegistry.DECADENT_ETYR_PILLAR, BlockRegistry.DECADENT_ETYR_SLAB, (Block)BlockRegistry.DECADENT_ETYR_STAIRS);
        this.registerEtyrVariant(generator, BlockRegistry.PERTURBED_ETYR_BLOCK, BlockRegistry.PERTURBED_ETYR_TILES, BlockRegistry.PERTURBED_ETYR_DOOR, BlockRegistry.PERTURBED_ETYR_TRAPDOOR, BlockRegistry.PERTURBED_ETYR_BARS, BlockRegistry.PERTURBED_ETYR_PILLAR, BlockRegistry.PERTURBED_ETYR_SLAB, (Block)BlockRegistry.PERTURBED_ETYR_STAIRS);
        this.registerEtyrVariant(generator, BlockRegistry.CORRUPTED_ETYR_BLOCK, BlockRegistry.CORRUPTED_ETYR_TILES, BlockRegistry.CORRUPTED_ETYR_DOOR, BlockRegistry.CORRUPTED_ETYR_TRAPDOOR, BlockRegistry.CORRUPTED_ETYR_BARS, BlockRegistry.CORRUPTED_ETYR_PILLAR, BlockRegistry.CORRUPTED_ETYR_SLAB, (Block)BlockRegistry.CORRUPTED_ETYR_STAIRS);
    }

    private void registerSlabStairSet(BlockModelGenerators generator, Block slab, Block stairs, Block parentBlock) {
        this.registerSlab(slab, parentBlock, generator.f_124478_, generator.f_124477_);
        this.registerStairs(stairs, parentBlock, generator.f_124478_, generator.f_124477_);
    }

    private void registerWoodset(BlockModelGenerators generator, Block planks, Block door, Block trapdoor, Block slab, Block stairs, Block button, Block fence, Block fenceGate) {
        generator.m_124851_(planks);
        generator.m_124896_(door);
        generator.m_124936_(trapdoor);
        this.registerSlab(slab, planks, generator.f_124478_, generator.f_124477_);
        this.registerStairs(stairs, planks, generator.f_124478_, generator.f_124477_);
        this.registerButton(button, planks, generator.f_124478_, generator.f_124477_);
        this.registerFence(fence, planks, generator.f_124478_, generator.f_124477_);
        this.registerFenceGate(fenceGate, planks, generator.f_124478_, generator.f_124477_);
    }

    private void registerEtyrVariant(BlockModelGenerators generator, Block block, Block tiles, Block door, Block trapdoor, Block bars, Block pillar, Block slab, Block stairs) {
        generator.m_124851_(block);
        generator.m_124851_(tiles);
        generator.m_124896_(door);
        generator.m_124936_(trapdoor);
        this.registerBars(bars, generator.f_124478_, generator.f_124477_);
        this.registerSlab(slab, tiles, generator.f_124478_, generator.f_124477_);
        this.registerStairs(stairs, tiles, generator.f_124478_, generator.f_124477_);
    }

    public void generateItemModels(ItemModelGenerators generator) {
        generator.m_125088_(ItemRegistry.SILVER_KEY, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.NECRONOMICON, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.ABERRATION_LIMB, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.ABERRATION_HEART, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.XAL, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.RAW_ETYR, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.ETYR_INGOT, ModelTemplates.f_125658_);
        generator.m_125088_(ArmorRegistry.ETYRITE_HELMET, ModelTemplates.f_125658_);
        generator.m_125088_(ArmorRegistry.ETYRITE_CHESTPLATE, ModelTemplates.f_125658_);
        generator.m_125088_(ArmorRegistry.ETYRITE_LEGGINGS, ModelTemplates.f_125658_);
        generator.m_125088_(ArmorRegistry.ETYRITE_BOOTS, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.ETYR_INFUSION_TEMPLATE, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.CORRUPTION_INFUSION_TEMPLATE, ModelTemplates.f_125658_);
        generator.m_125088_(ItemRegistry.OMINOUS_EYE, ModelTemplates.f_125658_);
    }

    private void registerBars(Block barBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        ResourceLocation identifier = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_post_ends");
        ResourceLocation identifier2 = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_post");
        ResourceLocation identifier3 = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_cap");
        ResourceLocation identifier4 = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_cap_alt");
        ResourceLocation identifier5 = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_side");
        ResourceLocation identifier6 = ModelLocationUtils.m_125578_((Block)barBlock, (String)"_side_alt");
        blockStateCollector.accept((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)barBlock).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier2)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)).m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier3)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)).m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier3).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)).m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier4)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)).m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier4).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier5)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier5).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier6)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)identifier6).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)));
        this.registerItemModel(barBlock, modelCollector);
    }

    public final void registerItemModel(Block block, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector) {
        Item item = block.m_5456_();
        if (item != Items.f_41852_) {
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125738_((Block)block), modelCollector);
        }
    }

    private void registerFence(Block fenceBlock, Block plankBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = TextureMapping.m_125748_((Block)plankBlock);
        ResourceLocation identifier = ModelTemplates.f_125708_.m_125592_(fenceBlock, textureMap, modelCollector);
        ResourceLocation identifier2 = ModelTemplates.f_125709_.m_125592_(fenceBlock, textureMap, modelCollector);
        blockStateCollector.accept(BlockModelGenerators.m_124904_((Block)fenceBlock, (ResourceLocation)identifier, (ResourceLocation)identifier2));
        ResourceLocation identifier3 = ModelTemplates.f_125710_.m_125592_(fenceBlock, textureMap, modelCollector);
        this.registerParentedItemModel(fenceBlock, identifier3, modelCollector);
    }

    private void registerFenceGate(Block fenceGateBlock, Block plankBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = TextureMapping.m_125748_((Block)plankBlock);
        ResourceLocation identifier = ModelTemplates.f_125621_.m_125592_(fenceGateBlock, textureMap, modelCollector);
        ResourceLocation identifier2 = ModelTemplates.f_125715_.m_125592_(fenceGateBlock, textureMap, modelCollector);
        ResourceLocation identifier3 = ModelTemplates.f_125623_.m_125592_(fenceGateBlock, textureMap, modelCollector);
        ResourceLocation identifier4 = ModelTemplates.f_125622_.m_125592_(fenceGateBlock, textureMap, modelCollector);
        blockStateCollector.accept(BlockModelGenerators.m_124809_((Block)fenceGateBlock, (ResourceLocation)identifier, (ResourceLocation)identifier2, (ResourceLocation)identifier3, (ResourceLocation)identifier4, (boolean)false));
        ResourceLocation identifier5 = ModelTemplates.f_125710_.m_125592_(fenceGateBlock, textureMap, modelCollector);
        this.registerParentedItemModel(fenceGateBlock, identifier5, modelCollector);
    }

    private void registerSlab(Block slabBlock, Block plankBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = TextureMapping.m_125748_((Block)plankBlock);
        TextureMapping textureMap2 = TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)plankBlock, (String)""), (ResourceLocation)textureMap.m_125756_(TextureSlot.f_125872_));
        ResourceLocation identifier = ModelTemplates.f_125627_.m_125592_(slabBlock, textureMap2, modelCollector);
        ResourceLocation identifier2 = ModelTemplates.f_125628_.m_125592_(slabBlock, textureMap2, modelCollector);
        ResourceLocation identifier3 = ModelTemplates.f_125694_.m_125616_(slabBlock, "_double", textureMap2, modelCollector);
        blockStateCollector.accept(ModelGenerator.createSlabBlockState(slabBlock, identifier, identifier2, identifier3));
    }

    private void registerButton(Block buttonBlock, Block plankBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = TextureMapping.m_125748_((Block)plankBlock);
        ResourceLocation identifier = ModelTemplates.f_125701_.m_125592_(buttonBlock, textureMap, modelCollector);
        ResourceLocation identifier2 = ModelTemplates.f_125702_.m_125592_(buttonBlock, textureMap, modelCollector);
        ResourceLocation identifier3 = ModelTemplates.f_125703_.m_125592_(buttonBlock, textureMap, modelCollector);
        blockStateCollector.accept(ModelGenerator.createButtonBlockState(buttonBlock, identifier, identifier2));
        this.registerParentedItemModel(buttonBlock, identifier3, modelCollector);
    }

    private void registerStairs(Block stairBlock, Block plankBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = TextureMapping.m_125748_((Block)plankBlock);
        TextureMapping textureMap2 = TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)plankBlock, (String)""), (ResourceLocation)textureMap.m_125756_(TextureSlot.f_125872_));
        ResourceLocation innerModel = ModelTemplates.f_125631_.m_125592_(stairBlock, textureMap2, modelCollector);
        ResourceLocation regularModel = ModelTemplates.f_125630_.m_125592_(stairBlock, textureMap2, modelCollector);
        ResourceLocation outerModel = ModelTemplates.f_125632_.m_125592_(stairBlock, textureMap2, modelCollector);
        blockStateCollector.accept(ModelGenerator.createStairsBlockState(stairBlock, innerModel, regularModel, outerModel));
    }

    public final void registerFronds(Block block, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector, Consumer<BlockStateGenerator> blockStateCollector) {
        TextureMapping textureMap = new TextureMapping().m_125758_(TextureSlot.f_125871_, TextureMapping.m_125740_((Block)Blocks.f_50259_)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)block, (String)"_top")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)block, (String)""));
        blockStateCollector.accept((BlockStateGenerator)ModelGenerator.createSingletonBlockState(block, ModelTemplates.f_125695_.m_125592_(block, textureMap, modelCollector)));
    }

    public static MultiVariantGenerator createSingletonBlockState(Block block, ResourceLocation modelId) {
        return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelId));
    }

    public static BlockStateGenerator createSlabBlockState(Block slabBlock, ResourceLocation bottomModelId, ResourceLocation topModelId, ResourceLocation fullModelId) {
        return MultiVariantGenerator.m_125254_((Block)slabBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125329_((Comparable)SlabType.BOTTOM, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelId)).m_125329_((Comparable)SlabType.TOP, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelId)).m_125329_((Comparable)SlabType.DOUBLE, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fullModelId)));
    }

    public static BlockStateGenerator createStairsBlockState(Block stairsBlock, ResourceLocation innerModelId, ResourceLocation regularModelId, ResourceLocation outerModelId) {
        return MultiVariantGenerator.m_125254_((Block)stairsBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelId).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)));
    }

    public static BlockStateGenerator createButtonBlockState(Block buttonBlock, ResourceLocation regularModelId, ResourceLocation pressedModelId) {
        return MultiVariantGenerator.m_125254_((Block)buttonBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)regularModelId)).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pressedModelId))).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61376_, (Property)BlockStateProperties.f_61374_).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, Variant.m_125501_()).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)));
    }

    public void registerParentedItemModel(Block block, ResourceLocation parentModelId, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector) {
        modelCollector.accept(ModelLocationUtils.m_125571_((Item)block.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(parentModelId));
    }
}

