/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api.targeting;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VectorHelper {
    public static double angleBetween(Vec3 a, Vec3 b) {
        double cosineTheta = a.m_82526_(b) / (a.m_82553_() * b.m_82553_());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        return Double.isNaN(angle) ? 0.0 : angle;
    }

    public static double angleWithSignBetween(Vec3 a, Vec3 b, Vec3 planeNormal) {
        double cosineTheta = a.m_82526_(b) / (a.m_82553_() * b.m_82553_());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vec3 cross = a.m_82537_(b);
        return Double.isNaN(angle *= Math.signum(cross.m_82526_(planeNormal))) ? 0.0 : angle;
    }

    public static Vec3 distanceVector(Vec3 point, AABB box) {
        double dx = 0.0;
        if (box.f_82288_ > point.f_82479_) {
            dx = box.f_82288_ - point.f_82479_;
        } else if (box.f_82291_ < point.f_82479_) {
            dx = box.f_82291_ - point.f_82479_;
        }
        double dy = 0.0;
        if (box.f_82289_ > point.f_82480_) {
            dy = box.f_82289_ - point.f_82480_;
        } else if (box.f_82292_ < point.f_82480_) {
            dy = box.f_82292_ - point.f_82480_;
        }
        double dz = 0.0;
        if (box.f_82290_ > point.f_82481_) {
            dz = box.f_82290_ - point.f_82481_;
        } else if (box.f_82293_ < point.f_82481_) {
            dz = box.f_82293_ - point.f_82481_;
        }
        return new Vec3(dx, dy, dz);
    }

    public static Vec3 rotateTowards(Vec3 vector, Vec3 towards, double angleToRotate) {
        Vec3 rotated;
        if (angleToRotate == 0.0) {
            return vector;
        }
        Vec3 originalVector = new Vec3(vector.f_82479_, vector.f_82480_, vector.f_82481_);
        double angleBetween = VectorHelper.angleWithSignBetween(vector = vector.m_82541_(), towards = towards.m_82541_(), vector.m_82537_(towards));
        if (angleBetween == 0.0) {
            return originalVector;
        }
        if (angleBetween <= angleToRotate) {
            rotated = towards;
        } else {
            double towardsLength = Math.sin(Math.toRadians(angleToRotate)) / Math.cos(Math.toRadians(90.0 - angleBetween + angleToRotate));
            Vec3 v2 = towards.m_82490_(towardsLength);
            rotated = vector.m_82549_(v2).m_82541_();
        }
        rotated = rotated.m_82490_(originalVector.m_82553_());
        return rotated;
    }

    public static Vec3 axisFromRotation(float yaw, float pitch) {
        double yawRadians = Math.toRadians(-yaw);
        double pitchRadians = Math.toRadians(-pitch);
        double x = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double y = -Math.sin(pitchRadians);
        double z = Math.cos(yawRadians) * Math.cos(pitchRadians);
        return new Vec3(x, y, z).m_82541_();
    }

    public static Vec3 rotateAround(Vec3 vector, float angleDegrees, float yaw, float pitch) {
        Vec3 axisOfRotation = VectorHelper.axisFromRotation(yaw, pitch);
        return VectorHelper.rotateAround(vector, axisOfRotation, angleDegrees);
    }

    public static Vec3 rotateAround(Vec3 vector, Vec3 axisOfRotation, double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double sinHalfAngle = Math.sin(angleRadians / 2.0);
        double cosHalfAngle = Math.cos(angleRadians / 2.0);
        double rx = axisOfRotation.f_82479_ * sinHalfAngle;
        double ry = axisOfRotation.f_82480_ * sinHalfAngle;
        double rz = axisOfRotation.f_82481_ * sinHalfAngle;
        double invRx = -rx;
        double invRy = -ry;
        double invRz = -rz;
        double[] q = VectorHelper.multiplyQuaternions(new double[]{rx, ry, rz, cosHalfAngle}, new double[]{vector.f_82479_, vector.f_82480_, vector.f_82481_, 0.0});
        double[] p = VectorHelper.multiplyQuaternions(q, new double[]{invRx, invRy, invRz, cosHalfAngle});
        return new Vec3(p[0], p[1], p[2]);
    }

    private static double[] multiplyQuaternions(double[] q1, double[] q2) {
        double x = q1[3] * q2[0] + q1[0] * q2[3] + q1[1] * q2[2] - q1[2] * q2[1];
        double y = q1[3] * q2[1] + q1[1] * q2[3] + q1[2] * q2[0] - q1[0] * q2[2];
        double z = q1[3] * q2[2] + q1[2] * q2[3] + q1[0] * q2[1] - q1[1] * q2[0];
        double w = q1[3] * q2[3] - q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2];
        return new double[]{x, y, z, w};
    }

    public static double yawFromNormalized(Vec3 vector) {
        return Math.toDegrees(Math.atan2(-vector.f_82479_, vector.f_82481_));
    }

    public static double pitchFromNormalized(Vec3 vector) {
        return Math.toDegrees(-Math.asin(vector.f_82480_));
    }
}

