/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api.targeting;

import elocindev.eldritch_end.api.targeting.VectorHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    public static float launchPointOffsetDefault = 0.5f;
    private static final boolean[][] TABLE_OF_ULTIMATE_JUSTICE = new boolean[][]{{false, true, true, true, true}, {false, false, false, true, true}, {true, true, true, false, true}, {true, true, false, false, true}};

    public static Vec3 launchPoint(LivingEntity caster) {
        return TargetHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static Vec3 launchPoint(LivingEntity caster, float forward) {
        Vec3 look = caster.m_20154_().m_82490_((double)(forward * caster.m_6134_()));
        return caster.m_20182_().m_82520_(0.0, (double)TargetHelper.launchHeight(caster), 0.0).m_82549_(look);
    }

    public static float launchHeight(LivingEntity livingEntity) {
        float eyeHeight = livingEntity.m_20192_();
        double shoulderDistance = (double)livingEntity.m_20206_() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.m_6134_());
    }

    public static Relation getRelation(LivingEntity attacker, Entity target) {
        OwnableEntity tameable;
        LivingEntity owner;
        if (attacker == target) {
            return Relation.FRIENDLY;
        }
        Team casterTeam = attacker.m_5647_();
        Team targetTeam = target.m_5647_();
        if (target instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)target).m_269323_()) != null) {
            return TargetHelper.getRelation(attacker, (Entity)owner);
        }
        if (target instanceof HangingEntity) {
            return Relation.NEUTRAL;
        }
        if (casterTeam != null && targetTeam != null) {
            return attacker.m_7307_(target) ? Relation.FRIENDLY : Relation.HOSTILE;
        }
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)target.m_6095_());
        Relation mappedRelation = Relation.NEUTRAL;
        if (mappedRelation != null) {
            return mappedRelation;
        }
        if (target instanceof AgeableMob) {
            return Relation.coalesce(Relation.NEUTRAL, Relation.HOSTILE);
        }
        return target instanceof Monster ? Relation.coalesce(Relation.HOSTILE, Relation.HOSTILE) : Relation.coalesce(Relation.NEUTRAL, Relation.HOSTILE);
    }

    public static boolean actionAllowed(TargetingMode targetingMode, Intent intent, LivingEntity attacker, Entity target) {
        Relation relation = TargetHelper.getRelation(attacker, target);
        int row = 0;
        if (intent == Intent.HELPFUL) {
            row += 2;
        }
        if (targetingMode == TargetingMode.AREA) {
            ++row;
        }
        int column = 0;
        switch (relation.ordinal()) {
            case 0: {
                column = 0;
                break;
            }
            case 1: {
                column = 1;
                break;
            }
            case 2: {
                column = 2;
                break;
            }
            case 3: {
                column = 3;
                break;
            }
            case 4: {
                column = 4;
            }
        }
        return TABLE_OF_ULTIMATE_JUSTICE[row][column];
    }

    public static boolean allowedToHurt(Entity e1, Entity e2) {
        Team abstractTeam = e1.m_5647_();
        Team abstractTeam2 = e2.m_5647_();
        if (abstractTeam == null) {
            return true;
        }
        return !abstractTeam.m_83536_(abstractTeam2) || abstractTeam.m_6260_();
    }

    public static Entity targetFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        AABB searchAABB;
        Vec3 look;
        Vec3 end;
        Vec3 start = caster.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)caster, (Vec3)start, (Vec3)(end = start.m_82549_(look = caster.m_20252_(1.0f).m_82541_().m_82490_((double)range))), (AABB)(searchAABB = caster.m_20191_().m_82377_((double)range, (double)range, (double)range)), target -> !target.m_5833_() && target.m_6087_() && predicate.test((Entity)target), (double)(range * range));
        return hitResult == null || hitResult.m_82450_() != null && !TargetHelper.raycastObstacleFree(caster, start, hitResult.m_82450_()) ? null : hitResult.m_82443_();
    }

    public static List<Entity> targetsFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        Vec3 start = caster.m_146892_();
        Vec3 look = caster.m_20252_(1.0f).m_82541_().m_82490_((double)range);
        Vec3 end = start.m_82549_(look);
        AABB searchAABB = caster.m_20191_().m_82377_((double)range, (double)range, (double)range);
        List<EntityHit> entitiesHit = TargetHelper.raycastMultiple(caster, start, end, searchAABB, target -> !target.m_5833_() && target.m_6087_() && predicate.test((Entity)target), range * range);
        return entitiesHit.stream().filter(hit -> hit.position() == null || TargetHelper.raycastObstacleFree(caster, start, hit.position())).sorted(new Comparator<EntityHit>(){

            @Override
            public int compare(EntityHit hit1, EntityHit hit2) {
                if (hit1.squaredDistanceToSource == hit2.squaredDistanceToSource) {
                    return 0;
                }
                return hit1.squaredDistanceToSource < hit2.squaredDistanceToSource ? -1 : 1;
            }
        }).map(hit -> hit.entity).toList();
    }

    @Nullable
    private static List<EntityHit> raycastMultiple(Entity sourceEntity, Vec3 min, Vec3 max, AABB searchBox, Predicate<Entity> predicate, double squaredDistance) {
        Level world = sourceEntity.m_9236_();
        double e = squaredDistance;
        ArrayList<EntityHit> entities = new ArrayList<EntityHit>();
        Vec3 vec3d = null;
        for (Entity entity : world.m_6249_(sourceEntity, searchBox, predicate)) {
            Vec3 hitPosition;
            AABB box2 = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional raycastResult = box2.m_82371_(min, max);
            if (box2.m_82390_(min)) {
                if (!(e >= 0.0)) continue;
                vec3d = raycastResult.orElse(min);
                entities.add(new EntityHit(entity, vec3d, 0.0));
                e = 0.0;
                continue;
            }
            if (!raycastResult.isPresent() || !(min.m_82557_(hitPosition = (Vec3)raycastResult.get()) < e) && e != 0.0) continue;
            if (entity.m_20201_() == sourceEntity.m_20201_()) {
                if (e != 0.0) continue;
                entities.add(new EntityHit(entity, hitPosition, entity.m_20280_(sourceEntity)));
                continue;
            }
            entities.add(new EntityHit(entity, hitPosition, entity.m_20280_(sourceEntity)));
        }
        return entities;
    }

    public static List<Entity> targetsFromArea(Entity caster, float range, Area area, @Nullable Predicate<Entity> predicate) {
        Vec3 origin = caster.m_146892_();
        return TargetHelper.targetsFromArea(caster, origin, range, area, predicate);
    }

    public static List<Entity> targetsFromArea(Entity centerEntity, Vec3 origin, float range, Area area, @Nullable Predicate<Entity> predicate) {
        float horizontal = range * area.horizontal_range_multiplier;
        float vertical = range * area.vertical_range_multiplier;
        AABB box = centerEntity.m_20191_().m_82377_((double)(horizontal + 0.5f), (double)(vertical + 0.5f), (double)(horizontal + 0.5f));
        float squaredDistance = range * range;
        Vec3 look = centerEntity.m_20154_();
        float angle = area.angle_degrees / 2.0f;
        return centerEntity.m_9236_().m_6249_(centerEntity, box, target -> {
            Vec3 targetCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            Vec3 distanceVector = VectorHelper.distanceVector(origin, target.m_20191_());
            if (!target.m_5833_() && target.m_6087_() && (predicate == null || predicate.test((Entity)target)) && !(!(range > 1.0f) ? !(distanceVector.m_82553_() <= (double)range) : !(targetCenter.m_82557_(origin) <= (double)squaredDistance))) {
                if ((angle <= 0.0f || VectorHelper.angleBetween(look, targetCenter.m_82546_(origin)) <= (double)angle || VectorHelper.angleBetween(look, distanceVector) <= (double)angle) && (range < 1.0f || TargetHelper.raycastObstacleFree(centerEntity, origin, targetCenter) || TargetHelper.raycastObstacleFree(centerEntity, origin, origin.m_82549_(distanceVector)))) {
                    boolean var10000 = true;
                    return var10000;
                }
            }
            boolean var10000 = false;
            return var10000;
        });
    }

    public static boolean isInLineOfSight(Entity attacker, Entity target) {
        Vec3 origin = attacker.m_146892_();
        Vec3 targetCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec3 distanceVector = VectorHelper.distanceVector(origin, target.m_20191_());
        return TargetHelper.raycastObstacleFree(attacker, origin, targetCenter) || TargetHelper.raycastObstacleFree(attacker, origin, origin.m_82549_(distanceVector));
    }

    private static boolean raycastObstacleFree(Entity entity, Vec3 start, Vec3 end) {
        BlockHitResult hit = entity.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return hit.m_6662_() != HitResult.Type.BLOCK;
    }

    @Nullable
    public static Vec3 findSolidBlockBelow(LivingEntity entity, Vec3 position, Level world, float height) {
        BlockHitResult hit = world.m_45547_(new ClipContext(position, position.m_82520_(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        return hit.m_6662_() == HitResult.Type.BLOCK ? new Vec3(position.m_7096_(), (double)((float)hit.m_82425_().m_123342_() + 1.0f), position.m_7094_()) : null;
    }

    @Nullable
    public static Vec3 findTeleportDestination(LivingEntity entity, Vec3 look, float distance, int clearanceY) {
        Level world = entity.m_9236_();
        Vec3 start = entity.m_146892_();
        Vec3 end = start.m_82549_(look.m_82490_((double)distance));
        BlockHitResult hit = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 hitPosition = null;
        if (hit.m_6662_() == HitResult.Type.MISS) {
            hitPosition = end;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK && hit.m_82425_() != null) {
            hitPosition = hit.m_82450_();
        }
        if (hitPosition != null) {
            Vec3 inverseLook = look.m_82490_(-1.0);
            Vec3 paddedHitPosition = hitPosition.m_82549_(inverseLook.m_82490_(0.5));
            double hitDistance = start.m_82554_(paddedHitPosition);
            float reverted = 0.0f;
            while ((double)reverted < hitDistance) {
                BlockPos blockPos = new BlockPos((int)paddedHitPosition.m_7096_(), (int)paddedHitPosition.m_7098_(), (int)paddedHitPosition.m_7094_());
                if (TargetHelper.isSafeWithClearance(world, blockPos, clearanceY)) {
                    return paddedHitPosition;
                }
                reverted += 1.0f;
                paddedHitPosition = paddedHitPosition.m_82549_(inverseLook);
            }
        }
        return null;
    }

    private static boolean isSafeWithClearance(Level world, BlockPos blockPos, int clearanceY) {
        if (!TargetHelper.isSafeTeleportDestination(world, blockPos)) {
            return false;
        }
        boolean clearanceSafe = true;
        for (int i = 0; i < clearanceY; ++i) {
            BlockPos clearancePos = blockPos.m_6630_(i);
            if (TargetHelper.isSafeTeleportDestination(world, clearancePos)) continue;
            clearanceSafe = false;
            break;
        }
        return clearanceSafe;
    }

    private static boolean isSafeTeleportDestination(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return !state.m_280296_() && !state.m_60828_((BlockGetter)world, pos);
    }

    public static enum Relation {
        FRIENDLY,
        SEMI_FRIENDLY,
        NEUTRAL,
        HOSTILE,
        MIXED;


        public static Relation coalesce(Relation value, Relation fallback) {
            return value != null ? value : fallback;
        }
    }

    public static enum Intent {
        HELPFUL,
        HARMFUL;

    }

    public static enum TargetingMode {
        DIRECT,
        AREA;

    }

    private record EntityHit(Entity entity, Vec3 position, double squaredDistanceToSource) {
    }

    public static class Area {
        public float horizontal_range_multiplier = 1.0f;
        public float vertical_range_multiplier = 1.0f;
        public float angle_degrees = 0.0f;
        public boolean include_caster = false;
    }
}

