/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api.particles.packets;

import elocindev.eldritch_end.api.particles.ParticleBatch;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class ParticlePackets {

    public record ParticleBatches(SourceType sourceType, List<Spawn> spawns) {
        public static ResourceLocation ID = new ResourceLocation("eldritch_end", "particle_effects");

        public FriendlyByteBuf write(float countMultiplier) {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.sourceType.ordinal());
            buffer.writeInt(this.spawns.size());
            for (Spawn spawn : this.spawns) {
                buffer.writeInt(spawn.sourceEntityId);
                buffer.writeFloat(spawn.yaw);
                buffer.writeFloat(spawn.pitch);
                buffer.writeDouble(spawn.sourceLocation.f_82479_);
                buffer.writeDouble(spawn.sourceLocation.f_82480_);
                buffer.writeDouble(spawn.sourceLocation.f_82481_);
                ParticleBatches.write(spawn.batch, buffer, countMultiplier);
            }
            return buffer;
        }

        private static void write(ParticleBatch batch, FriendlyByteBuf buffer, float countMultiplier) {
            buffer.m_130070_(batch.particle_id);
            buffer.writeInt(batch.shape.ordinal());
            buffer.writeInt(batch.origin.ordinal());
            buffer.writeInt(batch.rotation != null ? batch.rotation.ordinal() : -1);
            buffer.writeFloat(batch.roll);
            buffer.writeFloat(batch.roll_offset);
            buffer.writeFloat(batch.count * countMultiplier);
            buffer.writeFloat(batch.min_speed);
            buffer.writeFloat(batch.max_speed);
            buffer.writeFloat(batch.angle);
            buffer.writeFloat(batch.extent);
            buffer.writeFloat(batch.pre_spawn_travel);
            buffer.writeBoolean(batch.invert);
        }

        private static ParticleBatch readBatch(FriendlyByteBuf buffer) {
            return new ParticleBatch(buffer.m_130277_(), ParticleBatch.Shape.values()[buffer.readInt()], ParticleBatch.Origin.values()[buffer.readInt()], ParticleBatch.Rotation.from(buffer.readInt()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
        }

        public static ParticleBatches read(FriendlyByteBuf buffer) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            int spawnCount = buffer.readInt();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            for (int i = 0; i < spawnCount; ++i) {
                spawns.add(new Spawn(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), ParticleBatches.readBatch(buffer)));
            }
            return new ParticleBatches(sourceType, spawns);
        }

        public static enum SourceType {
            ENTITY,
            COORDINATE;

        }

        public record Spawn(int sourceEntityId, float yaw, float pitch, Vec3 sourceLocation, ParticleBatch batch) {
        }
    }
}

