/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api.dark_magic;

import elocindev.eldritch_end.api.RitualAPI;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SummonPartItem
extends Item {
    private EntityType<?> summon;
    private RitualAPI.RitualStructure ritualStructure;
    private Block mainSummonBlock;
    private BlockState aftermathBlock;
    private boolean shouldSpawnLightning = true;
    @Nullable
    private List<ResourceLocation> allowed_biomes = null;

    public SummonPartItem(Item.Properties settings, RitualAPI.RitualStructure ritualStructure, Block mainSummonBlock, BlockState aftermathBlock, EntityType<?> summon) {
        super(settings);
        this.ritualStructure = ritualStructure;
        this.summon = summon;
        this.mainSummonBlock = mainSummonBlock;
        this.aftermathBlock = aftermathBlock;
    }

    public SummonPartItem(Item.Properties settings, RitualAPI.RitualStructure ritualStructure, Block mainSummonBlock, BlockState aftermathBlock, EntityType<?> summon, boolean shouldSpawnLightning) {
        this(settings, ritualStructure, mainSummonBlock, aftermathBlock, summon);
        this.shouldSpawnLightning = shouldSpawnLightning;
    }

    public SummonPartItem(Item.Properties settings, RitualAPI.RitualStructure ritualStructure, Block mainSummonBlock, BlockState aftermathBlock, EntityType<?> summon, boolean shouldSpawnLightning, List<ResourceLocation> allowed_biomes) {
        this(settings, ritualStructure, mainSummonBlock, aftermathBlock, summon, shouldSpawnLightning);
        this.allowed_biomes = allowed_biomes;
    }

    public Entity createBoss(Level world, double x, double y, double z) {
        Entity boss = this.summon.m_20615_(world);
        boss.m_20343_(x, y, z);
        return boss;
    }

    public boolean shouldSpawnLightning() {
        return this.shouldSpawnLightning;
    }

    public EntityType<?> getSummonableEntityType() {
        return this.summon;
    }

    public RitualAPI.RitualStructure getRitualStructure() {
        return this.ritualStructure;
    }

    public Block getMainSummonBlock() {
        return this.mainSummonBlock;
    }

    public BlockState getAftermathBlock() {
        return this.aftermathBlock;
    }

    public boolean getSummoningConditions(BlockPos pos, Level world) {
        return RitualAPI.isBasicRitual(pos, world);
    }

    public static void playInteractionEffect(BlockPos pos, Level world) {
        world.m_7106_((ParticleOptions)ParticleTypes.f_123765_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, (double)0.05f, 0.0);
        world.m_5594_(null, pos, SoundEvents.f_215710_, SoundSource.BLOCKS, 1.0f, 1.3f);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        SummonPartItem.playInteractionEffect(context.m_8083_(), world);
        context.m_43722_().m_41774_(1);
        if (this.getSummoningConditions(context.m_8083_(), world) && context.m_43725_().m_8055_(context.m_8083_()).m_60713_(this.getMainSummonBlock())) {
            if (this.allowed_biomes != null) {
                Holder biome = world.m_204166_(context.m_8083_());
                for (ResourceLocation allowed : this.allowed_biomes) {
                    if (biome.m_203373_(allowed)) continue;
                    return InteractionResult.FAIL;
                }
            }
            context.m_43723_().m_21120_(context.m_43724_()).m_41774_(1);
            Entity boss = this.createBoss(world, context.m_8083_().m_123341_(), context.m_8083_().m_123342_() + 2, context.m_8083_().m_123343_());
            world.m_7967_(boss);
            world.m_46597_(context.m_8083_(), this.getAftermathBlock());
            if (this.shouldSpawnLightning) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        LightningBolt ent = new LightningBolt(EntityType.f_20465_, world);
                        ent.m_20874_(true);
                        ent.m_20343_((double)(context.m_8083_().m_123341_() + x), (double)context.m_8083_().m_123342_(), (double)(context.m_8083_().m_123343_() + z));
                        world.m_7967_((Entity)ent);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

