/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end;

import elocindev.eldritch_end.api.particles.ParticleHelper;
import elocindev.eldritch_end.api.particles.packets.ParticlePackets;
import elocindev.eldritch_end.client.entity.aberration.AberrationRenderer;
import elocindev.eldritch_end.client.entity.dendler.DendlerRenderer;
import elocindev.eldritch_end.client.entity.faceless.FacelessRenderer;
import elocindev.eldritch_end.client.entity.ominous_eye.OminousEyeRenderer;
import elocindev.eldritch_end.client.entity.tentacle.TentacleRenderer;
import elocindev.eldritch_end.client.entity.undead_tentacle.UndeadTentacleRenderer;
import elocindev.eldritch_end.client.render.screen.CorruptionOverlay;
import elocindev.eldritch_end.client.render.screen.IconOverlay;
import elocindev.eldritch_end.compat.LegendaryTooltipsIntegration;
import elocindev.eldritch_end.compat.SpellEngineCompatClient;
import elocindev.eldritch_end.config.ConfigLoader;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.registry.EntityRegistry;
import elocindev.eldritch_end.registry.PacketRegistry;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class EldritchEndClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ConfigLoader.initClient();
        HudRenderCallback.EVENT.register((Object)new CorruptionOverlay());
        HudRenderCallback.EVENT.register((Object)new IconOverlay());
        PacketRegistry.registerS2CPackets();
        EntityRendererRegistry.register(EntityRegistry.OMINOUS_EYE, OminousEyeRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.ABERRATION, AberrationRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.TENTACLE, TentacleRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.UNDEAD_TENTACLE, UndeadTentacleRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.DENDLER, DendlerRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.THE_FACELESS, FacelessRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.PRIMORDIAL_TRAPDOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.ETYR_TRAPDOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.DECADENT_ETYR_TRAPDOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.PERTURBED_ETYR_TRAPDOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.CORRUPTED_ETYR_TRAPDOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.ABYSMAL_ROOTS, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.ELDRITCH_PEDESTAL, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.ETYR_DOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.DECADENT_ETYR_DOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.PERTURBED_ETYR_DOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.CORRUPTED_ETYR_DOOR, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.HASTURIAN_GRASS, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.ETYR_BARS, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.DECADENT_ETYR_BARS, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.PERTURBED_ETYR_BARS, RenderType.m_110463_());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockRegistry.CORRUPTED_ETYR_BARS, RenderType.m_110463_());
        if (FabricLoader.getInstance().isModLoaded("legendarytooltips")) {
            LegendaryTooltipsIntegration.init();
        }
        SpellEngineCompatClient.registerClient();
        ModelLoadingPlugin.register(context -> context.addModels(new ResourceLocation[]{new ResourceLocation("eldritch_end", "entity/ominous_eye")}));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)ParticlePackets.ParticleBatches.ID, (client, handler, buf, responseSender) -> {
            ParticlePackets.ParticleBatches packet = ParticlePackets.ParticleBatches.read(buf);
            List<ParticleHelper.SpawnInstruction> instructions = ParticleHelper.convertToInstructions((Level)client.f_91073_, packet);
            client.execute(() -> {
                for (ParticleHelper.SpawnInstruction instruction : instructions) {
                    instruction.perform((Level)client.f_91073_);
                }
            });
        });
    }
}

