/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.world.structures.NetherStructureNBT;
import org.betterx.betternether.world.structures.city.BoundingBox2D;

public class StructureCityBuilding
extends NetherStructureNBT {
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private BoundingBox2D bb;
    public BlockPos[] ends;
    private Direction[] dirs;
    private BlockPos rotationOffset;
    private int offsetY;

    public StructureCityBuilding(String structure) {
        super(BetterNether.makeID(structure));
        this.init();
    }

    public StructureCityBuilding(String structure, int offsetY) {
        super(BetterNether.makeID(structure));
        this.offsetY = offsetY;
        this.init();
    }

    protected StructureCityBuilding(ResourceLocation location, StructureTemplate structure) {
        super(location);
        this.structure = structure;
        this.init();
    }

    private void init() {
        Vec3i size = this.structure.m_163801_();
        this.bb = new BoundingBox2D(0, 0, size.m_123341_(), size.m_123343_());
        ObjectArrayList map = this.structure.m_230335_(BlockPos.f_121853_, new StructurePlaceSettings(), Blocks.f_50677_, false);
        this.ends = new BlockPos[map.size()];
        this.dirs = new Direction[map.size()];
        int i = 0;
        BlockPos center = new BlockPos(size.m_123341_() >> 1, size.m_123342_(), size.m_123343_() >> 1);
        for (StructureTemplate.StructureBlockInfo info : map) {
            this.ends[i] = info.f_74675_();
            this.dirs[i++] = this.getDir(info.f_74675_().m_7918_(-center.m_123341_(), 0, -center.m_123343_()));
        }
        this.rotationOffset = new BlockPos(0, 0, 0);
        this.rotation = Rotation.NONE;
    }

    private Direction getDir(BlockPos pos) {
        int az;
        int ax = Math.abs(pos.m_123341_());
        int mx = Math.max(ax, az = Math.abs(pos.m_123343_()));
        if (mx == ax) {
            if (pos.m_123341_() > 0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (pos.m_123343_() > 0) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    public BoundingBox2D getBoungingBox() {
        return this.bb;
    }

    protected Rotation mirrorRotation(Rotation r) {
        switch (r) {
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return r;
    }

    public void placeInChunk(ServerLevelAccessor world, BlockPos pos, BoundingBox boundingBox, StructureProcessor paletteProcessor) {
        BlockPos p = pos.m_121955_((Vec3i)this.rotationOffset);
        this.structure.m_230328_(world, p, p, new StructurePlaceSettings().m_74379_(this.rotation).m_74377_(this.mirror).m_74381_(boundingBox).m_74383_(paletteProcessor), world.m_213780_(), 2);
    }

    public BlockPos[] getEnds() {
        return this.ends;
    }

    public int getEndsCount() {
        return this.ends.length;
    }

    public BlockPos getOffsettedPos(int index) {
        return this.ends[index].m_121945_(this.dirs[index]);
    }

    public BlockPos getPos(int index) {
        return this.ends[index];
    }

    public StructureCityBuilding getRotated(Rotation rotation) {
        StructureCityBuilding building = this.clone();
        building.rotation = rotation;
        building.rotationOffset = new BlockPos(building.structure.m_163801_()).m_7954_(rotation);
        int x = building.rotationOffset.m_123341_();
        int z = building.rotationOffset.m_123343_();
        x = x < 0 ? -x - 1 : 0;
        z = z < 0 ? -z - 1 : 0;
        building.rotationOffset = new BlockPos(x, 0, z);
        for (int i = 0; i < building.dirs.length; ++i) {
            building.dirs[i] = this.rotated(building.dirs[i], rotation);
            building.ends[i] = building.ends[i].m_7954_(rotation).m_121955_((Vec3i)building.rotationOffset);
        }
        building.bb.rotate(rotation);
        building.offsetY = this.offsetY;
        return building;
    }

    public StructureCityBuilding getRandomRotated(RandomSource random) {
        return this.getRotated(Rotation.values()[random.m_188503_(4)]);
    }

    public StructureCityBuilding clone() {
        return new StructureCityBuilding(this.location, this.structure);
    }

    private Direction rotated(Direction dir, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> dir.m_122427_();
            case Rotation.CLOCKWISE_180 -> dir.m_122424_();
            case Rotation.COUNTERCLOCKWISE_90 -> dir.m_122428_();
            default -> dir;
        };
    }

    public int getYOffset() {
        return this.offsetY;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }

    public BoundingBox getBoundingBox(BlockPos pos) {
        return this.structure.m_74633_(new StructurePlaceSettings().m_74379_(this.rotation).m_74377_(this.mirror), pos.m_121955_((Vec3i)this.rotationOffset));
    }

    @Override
    public StructureCityBuilding setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.rotationOffset = new BlockPos(this.structure.m_163801_()).m_7954_(rotation);
        return this;
    }
}

