/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.betterx.betternether.registry.NetherStructures;

public class CityHelper {
    private static final Set<ChunkPos> POSITIONS = Collections.newSetFromMap(new ConcurrentHashMap(16));

    public static boolean stopStructGen(int chunkX, int chunkZ, ChunkGenerator chunkGenerator, long worldSeed, WorldgenRandom chunkRandom) {
        RandomSpreadStructurePlacement config;
        StructurePlacement structurePlacement = NetherStructures.CITY_STRUCTURE.spreadConfig;
        if (structurePlacement instanceof RandomSpreadStructurePlacement && (config = (RandomSpreadStructurePlacement)structurePlacement) != null && config.m_205003_() > 0) {
            CityHelper.collectNearby(chunkX, chunkZ, config, worldSeed, chunkRandom);
        }
        return CityHelper.stopGeneration(chunkX, chunkZ);
    }

    private static void collectNearby(int chunkX, int chunkZ, RandomSpreadStructurePlacement config, long worldSeed, WorldgenRandom chunkRandom) {
        int x1 = chunkX - 16;
        int x2 = chunkX + 16;
        int z1 = chunkZ - 16;
        int z2 = chunkZ + 16;
        POSITIONS.clear();
        for (int x = x1; x <= x2; x += 8) {
            for (int z = z1; z <= z2; z += 8) {
                ChunkPos chunk = config.m_227008_(worldSeed, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static void collectNearby(ServerLevel world, int chunkX, int chunkZ, RandomSpreadStructurePlacement config, long worldSeed, WorldgenRandom chunkRandom) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int x1 = chunkX - 16;
        int x2 = chunkX + 16;
        int z1 = chunkZ - 16;
        int z2 = chunkZ + 16;
        POSITIONS.clear();
        POS.m_142448_(64);
        for (int x = x1; x <= x2; x += 8) {
            POS.m_142451_(x << 4);
            for (int z = z1; z <= z2; z += 8) {
                POS.m_142443_(z << 4);
                ChunkPos chunk = config.m_227008_(worldSeed, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static boolean stopGeneration(int chunkX, int chunkZ) {
        for (ChunkPos p : POSITIONS) {
            int dx = p.f_45578_ - chunkX;
            int dz = p.f_45579_ - chunkZ;
            if (dx * dx + dz * dz >= 64) continue;
            return true;
        }
        return false;
    }

    private static long sqr(int x) {
        return (long)x * (long)x;
    }

    public static BlockPos getNearestCity(BlockPos pos, ServerLevel world) {
        Iterator<ChunkPos> iterator;
        int cx = pos.m_123341_() >> 4;
        int cz = pos.m_123343_() >> 4;
        StructurePlacement structurePlacement = NetherStructures.CITY_STRUCTURE.spreadConfig;
        if (structurePlacement instanceof RandomSpreadStructurePlacement) {
            RandomSpreadStructurePlacement config = (RandomSpreadStructurePlacement)structurePlacement;
            if (config == null || config.m_205003_() < 1) {
                return null;
            }
            CityHelper.collectNearby(world, cx, cz, config, world.m_7328_(), new WorldgenRandom((RandomSource)new LegacyRandomSource(Instant.now().getEpochSecond())));
        }
        if ((iterator = POSITIONS.iterator()).hasNext()) {
            ChunkPos nearest = POSITIONS.iterator().next();
            long d = CityHelper.sqr(nearest.f_45578_ - cx) + CityHelper.sqr(nearest.f_45579_ - cz);
            while (iterator.hasNext()) {
                ChunkPos n = iterator.next();
                long d2 = CityHelper.sqr(n.f_45578_ - cx) + CityHelper.sqr(n.f_45579_ - cz);
                if (d2 >= d) continue;
                d = d2;
                nearest = n;
            }
            return nearest.m_45615_();
        }
        return null;
    }
}

