/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Rotation;

public class BoundingBox2D {
    int x1;
    int x2;
    int z1;
    int z2;

    public BoundingBox2D(int x1, int z1, int x2, int z2) {
        this.x1 = x1;
        this.x2 = x2;
        this.z1 = z1;
        this.z2 = z2;
    }

    public BoundingBox2D(BlockPos size, int offsetX, int offsetZ) {
        this.x1 = offsetX;
        this.x2 = this.x1 + size.m_123341_();
        this.z1 = offsetZ;
        this.z2 = this.z1 + size.m_123343_();
    }

    public BoundingBox2D(BlockPos size) {
        this.x1 = 0;
        this.x2 = size.m_123341_();
        this.z1 = 0;
        this.z2 = size.m_123343_();
    }

    public boolean isColliding(BoundingBox2D bb) {
        boolean colX = bb.x1 < this.x2 && this.x1 < bb.x2;
        boolean colZ = bb.z1 < this.z2 && this.z1 < bb.z2;
        return colX && colZ;
    }

    public BoundingBox2D offset(BlockPos offset) {
        return new BoundingBox2D(this.x1 + offset.m_123341_(), this.z1 + offset.m_123343_(), this.x2 + offset.m_123341_(), this.z2 + offset.m_123343_());
    }

    public BoundingBox2D offsetNegative(BlockPos offset) {
        return new BoundingBox2D(this.x1 - offset.m_123341_(), this.z1 - offset.m_123343_(), this.x2 - offset.m_123341_(), this.z2 - offset.m_123343_());
    }

    public String toString() {
        return this.x1 + " " + this.z1 + " " + this.x2 + " " + this.z2;
    }

    public void rotate(Rotation rotation) {
        BlockPos start = new BlockPos(this.x1, 0, this.z1);
        BlockPos end = new BlockPos(this.x2, 0, this.z2);
        start = start.m_7954_(rotation);
        end = end.m_7954_(rotation);
        int nx1 = Math.min(start.m_123341_(), end.m_123341_());
        int nx2 = Math.max(start.m_123341_(), end.m_123341_());
        int nz1 = Math.min(start.m_123343_(), end.m_123343_());
        int nz2 = Math.max(start.m_123343_(), end.m_123343_());
        this.x1 = 0;
        this.z1 = 0;
        this.x2 = nx2 - nx1;
        this.z2 = nz2 - nz1;
    }

    public BlockPos getCenter() {
        return new BlockPos((int)((double)(this.x2 + this.x1) * 0.5), 0, (int)((double)(this.z2 + this.z1) * 0.5));
    }

    public int getSideX() {
        return this.x2 - this.x1;
    }

    public int getSideZ() {
        return this.z2 - this.z1;
    }

    public int getMinX() {
        return this.x1;
    }

    public int getMaxX() {
        return this.x2;
    }

    public int getMinZ() {
        return this.z1;
    }

    public int getMaxZ() {
        return this.z2;
    }
}

