/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class StructureCaves
implements IStructure {
    private int offset = 12;
    private final OpenSimplexNoise heightNoise;
    private final OpenSimplexNoise rigidNoise;
    private final OpenSimplexNoise distortX;
    private final OpenSimplexNoise distortY;

    public StructureCaves(long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        this.heightNoise = new OpenSimplexNoise(random.m_188505_());
        this.rigidNoise = new OpenSimplexNoise(random.m_188505_());
        this.distortX = new OpenSimplexNoise(random.m_188505_());
        this.distortY = new OpenSimplexNoise(random.m_188505_());
    }

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int wz;
        int z;
        int wx;
        int x;
        boolean isVoid = true;
        this.offset = (int)(this.getHeight(pos.m_123341_() + 8, pos.m_123343_() + 8) - 12.0);
        for (x = 0; x < 16; ++x) {
            wx = pos.m_123341_() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.m_123343_() + z;
                double height = this.getHeight(wx, wz);
                double rigid = this.getRigid(wx, wz);
                for (int y = 0; y < 24; ++y) {
                    int wy = this.offset + y;
                    double hRigid = Math.abs((double)wy - height);
                    double sdf = -this.opSmoothUnion(-hRigid / 30.0, -rigid, 0.15);
                    if (sdf < 0.15) {
                        context.MASK[x][y][z] = true;
                        isVoid = false;
                        continue;
                    }
                    context.MASK[x][y][z] = false;
                }
            }
        }
        if (isVoid) {
            return;
        }
        for (x = 0; x < 16; ++x) {
            wx = pos.m_123341_() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.m_123343_() + z;
                for (int y = 23; y >= 0; --y) {
                    int wy = this.offset + y;
                    context.POS.m_122178_(wx, wy, wz);
                    if (!context.MASK[x][y][z] || !BlocksHelper.isTerrain((BlockState)world.m_8055_((BlockPos)context.POS))) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)context.POS, (BlockState)Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private double getHeight(int x, int z) {
        return this.heightNoise.eval((double)x * 0.01, (double)z * 0.01) * 32.0 + 64.0;
    }

    private double getRigid(int x, int z) {
        return Math.abs(this.rigidNoise.eval((double)x * 0.02 + this.distortX.eval((double)x * 0.05, (double)z * 0.05) * 0.2, (double)z * 0.02 + this.distortY.eval((double)x * 0.05, (double)z * 0.05) * 0.2)) * 0.6;
    }

    private double mix(double dist1, double dist2, double blend) {
        return dist1 * (1.0 - blend) + dist2 * blend;
    }

    private double opSmoothUnion(double dist1, double dist2, double blend) {
        double h = 0.5 + 0.5 * (dist2 - dist1) / blend;
        h = h > 1.0 ? 1.0 : (h < 0.0 ? 0.0 : h);
        return this.mix(dist2, dist1, h) - blend * h * (1.0 - h);
    }

    public boolean isInCave(int x, int y, int z, StructureGeneratorThreadContext context) {
        int y2 = y - this.offset;
        if (y2 >= 0 && y < 24) {
            return context.MASK[x][y2][z];
        }
        return false;
    }
}

