/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public abstract class NonOverlappingFeature<FC extends NaturalTreeConfiguration>
extends ContextFeature<FC> {
    public NonOverlappingFeature(Codec<FC> codec) {
        super(codec);
    }

    protected abstract boolean isStructure(BlockState var1);

    protected abstract boolean isGround(BlockState var1);

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, FC config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (this.isGround(world.m_8055_(pos.m_7495_())) && this.noObjNear((LevelAccessor)world, pos, config)) {
            return this.grow(world, pos, random, config, context);
        }
        return false;
    }

    protected abstract boolean grow(ServerLevelAccessor var1, BlockPos var2, RandomSource var3, FC var4, StructureGeneratorThreadContext var5);

    private boolean noObjNear(LevelAccessor world, BlockPos pos, FC config) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int x1 = pos.m_123341_() - ((NaturalTreeConfiguration)config).distance;
        int z1 = pos.m_123343_() - ((NaturalTreeConfiguration)config).distance;
        int x2 = pos.m_123341_() + ((NaturalTreeConfiguration)config).distance;
        int z2 = pos.m_123343_() + ((NaturalTreeConfiguration)config).distance;
        POS.m_142448_(pos.m_123342_());
        for (int x = x1; x <= x2; ++x) {
            POS.m_142451_(x);
            for (int z = z1; z <= z2; ++z) {
                POS.m_142443_(z);
                if (!this.isInside(x - pos.m_123341_(), z - pos.m_123343_(), config) || !this.isStructure(world.m_8055_((BlockPos)POS))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isInside(int x, int z, FC config) {
        return Math.abs(x) + Math.abs(z) <= ((NaturalTreeConfiguration)config).manDist;
    }
}

