/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class AnchorTreeBranchFeature
extends ContextFeature<NoneFeatureConfiguration>
implements UserGrowableFeature<NoneFeatureConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{-20.0f, -17.0f, -12.0f, -4.0f, 0.0f, 2.0f};
    private static final int MIDDLE_Y = 10;

    public AnchorTreeBranchFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (pos.m_123342_() < 56 + random.m_188503_((int)(20.0f * scale_factor))) {
            return false;
        }
        return this.grow(world, pos, random, scale_factor, context);
    }

    private boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, float scale_factor, StructureGeneratorThreadContext context) {
        int i;
        context.clear();
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        BlockState leaves = (BlockState)NetherBlocks.ANCHOR_TREE_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP};
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize * scale_factor;
            int x1 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.m_123342_() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 9.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, new BlockPos(x1, y1 + 1, z1), crownR, random, scale_factor, context);
            int middle = Math.round((float)pos.m_123342_() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.m_123342_() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] >= 0.0f && this.canReplace(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (this.canReplace(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.m_123341_();
                        y2 = pos.m_123342_();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.m_7494_()) || context.TOP.contains(bpos.m_7494_())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.m_7494_();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : context.POINTS) {
            BlockState state = context.POINTS.contains(bpos.m_7494_()) && context.POINTS.contains(bpos.m_7495_()) ? NetherBlocks.MAT_ANCHOR_TREE.getLog().m_49966_() : NetherBlocks.MAT_ANCHOR_TREE.getBark().m_49966_();
            BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, state);
            boolean hasLeavesOnLevel = false;
            for (Direction d : directions) {
                BlockState currentState;
                if (!hasLeavesOnLevel && d == Direction.DOWN) continue;
                int max = 0;
                for (i = 1; i <= 7; ++i) {
                    context.POS.m_122154_((Vec3i)bpos, d.m_122429_() * i, d.m_122430_() * i, d.m_122431_() * i);
                    currentState = world.m_8055_((BlockPos)context.POS);
                    if (!currentState.m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                    max = i;
                }
                if (d != Direction.DOWN && d != Direction.UP) {
                    hasLeavesOnLevel |= max > 0;
                }
                for (i = 1; i < max; ++i) {
                    context.POS.m_122154_((Vec3i)bpos, d.m_122429_() * i, d.m_122430_() * i, d.m_122431_() * i);
                    currentState = world.m_8055_((BlockPos)context.POS);
                    if (!currentState.m_60713_(NetherBlocks.ANCHOR_TREE_VINE) && !currentState.m_60713_(Blocks.f_50016_)) continue;
                    BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, leaves);
                    BlockPos vpos = context.POS.m_7494_();
                    currentState = world.m_8055_(vpos);
                    while (currentState.m_60713_(NetherBlocks.ANCHOR_TREE_VINE)) {
                        AnchorTreeBranchFeature.safeSet((LevelAccessor)world, vpos, leaves);
                        vpos = vpos.m_7494_();
                        currentState = world.m_8055_(vpos);
                    }
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        context.clear();
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    public static void safeSet(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!state.m_60713_(Blocks.f_50752_)) {
            BlocksHelper.setWithoutUpdate(level, pos, state);
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.m_8055_(logPos);
            if (!currentState.m_61138_((Property)BlockStateProperties.f_61414_)) continue;
            int cDist = (Integer)currentState.m_61143_((Property)BlockStateProperties.f_61414_);
            if (dist < cDist) {
                AnchorTreeBranchFeature.safeSet((LevelAccessor)world, logPos, (BlockState)currentState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            AnchorTreeBranchFeature.safeSet((LevelAccessor)world, logPos, Blocks.f_50016_.m_49966_());
            BlockPos pos = logPos.m_7495_();
            currentState = world.m_8055_(pos);
            while (currentState.m_60713_(NetherBlocks.ANCHOR_TREE_VINE)) {
                AnchorTreeBranchFeature.safeSet((LevelAccessor)world, pos, Blocks.f_50016_.m_49966_());
                pos = pos.m_7495_();
                currentState = world.m_8055_(pos);
            }
        }
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    BlockPos blPos = bpos.m_7918_(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void line(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = context.POS.m_122178_(x1, y1, z1).m_7949_();
        context.POINTS.add(pos);
        if (pos.m_123342_() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.m_123342_() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.m_122178_(x2, y2, z2).m_7949_();
        context.POINTS.add(pos);
        if (pos.m_123342_() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.m_123342_() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.m_122178_(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.m_7949_();
            context.POINTS.add(pos);
            if (context.POS.m_123342_() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.m_123342_() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, float radius, RandomSource random, float scale_factor, StructureGeneratorThreadContext context) {
        int HEIGHT_17;
        int HEIGHT_15;
        int HEIGHT_10;
        scale_factor = (scale_factor - 1.0f) * 0.25f + 1.0f;
        if (NetherBiomeBuilder.useLegacyGeneration) {
            HEIGHT_10 = (int)(10.0f * scale_factor);
            HEIGHT_15 = (int)(15.0f * scale_factor);
            HEIGHT_17 = (int)(17.0f * scale_factor);
        } else {
            float rnd = MHelper.nextFloat(random, 5.0f * scale_factor);
            HEIGHT_10 = (int)(10.0f * scale_factor + rnd);
            HEIGHT_15 = (int)(15.0f * scale_factor + rnd);
            HEIGHT_17 = (int)(17.0f * scale_factor + rnd);
        }
        BlockState leaves = NetherBlocks.ANCHOR_TREE_LEAVES.m_49966_();
        BlockState vine = NetherBlocks.ANCHOR_TREE_VINE.m_49966_();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        for (int cy = (int)Math.floor(radius); cy >= start; --cy) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            context.POS.m_142448_((int)((float)(pos.m_123342_() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                context.POS.m_142451_(pos.m_123341_() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        context.POS.m_142443_(pos.m_123343_() + cz);
                        if (world.m_8055_((BlockPos)context.POS).m_247087_()) {
                            int length = BlocksHelper.downRay(world, (BlockPos)context.POS, HEIGHT_17);
                            if (length < 5) {
                                AnchorTreeBranchFeature.safeSet(world, (BlockPos)context.POS, leaves);
                            } else {
                                if (length > HEIGHT_15) {
                                    length = MHelper.randRange(HEIGHT_10, HEIGHT_15, random);
                                } else if (length > HEIGHT_10) {
                                    length = MHelper.randRange(HEIGHT_10, length, random);
                                }
                                if (cz % 2 == cx % 2) {
                                    length /= 3;
                                }
                                if (length > 4) {
                                    for (int i = 1; i < length - 2; ++i) {
                                        AnchorTreeBranchFeature.safeSet(world, context.POS.m_6625_(i), vine);
                                    }
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.m_6625_(length - 2), (BlockState)vine.m_61124_(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.m_6625_(length - 1), (BlockState)vine.m_61124_(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
                                }
                                AnchorTreeBranchFeature.safeSet(world, (BlockPos)context.POS, leaves);
                            }
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.m_247087_();
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration cfg) {
        return this.grow(level, pos, random, 1.0f, NetherThreadDataStorage.generatorForThread().context);
    }
}

