/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.RoughNoiseCondition;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherTreesPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.registry.features.placed.NetherVinesPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.NetherGrasslands;

public class NetherSwampland
extends NetherBiome {
    public NetherSwampland(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(137, 19, 78).loop(SoundsRegistry.AMBIENT_SWAMPLAND).additions((Holder)SoundEvents.f_11901_).mood((Holder)SoundEvents.f_12007_).music((Holder)SoundEvents.f_12157_).structure(BiomeTags.f_207599_).structure(BiomeTags.f_207597_).feature(NetherVegetationPlaced.NETHER_REED).feature(NetherTreesPlaced.WILLOW_TREE).feature(NetherVegetationPlaced.WILLOW_BUSH).feature(NetherVegetationPlaced.BLACK_BUSH_SPARSE).feature(NetherObjectsPlaced.STALAGMITE).feature(NetherVegetationPlaced.VEGETATION_SWAMPLAND).feature(NetherVegetationPlaced.JELLYFISH_MUSHROOM).feature(NetherObjectsPlaced.SMOKER).feature(NetherVinesPlaced.BLACK_VINE).feature(NetherVinesPlaced.BLOOMING_VINE).feature(NetherObjectsPlaced.STALACTITE).feature(NetherVegetationPlaced.WALL_MUSHROOMS_WITH_MOSS);
            this.addCustomSwamplandBuildData(builder);
        }

        protected void addCustomSwamplandBuildData(BCLBiomeBuilder builder) {
            builder.feature(NetherTerrainPlaced.LAVA_SWAMP).addNetherClimateParamater(0.1f, 0.8f, 0.1f);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherSwampland::new;
        }

        @Override
        public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case ENDERMAN: 
                case GHAST: 
                case ZOMBIFIED_PIGLIN: 
                case PIGLIN: 
                case HOGLIN: 
                case PIGLIN_BRUTE: {
                    res = 0;
                    break;
                }
                case MAGMA_CUBE: 
                case STRIDER: {
                    res = 40;
                }
            }
            return res;
        }

        @Override
        public boolean hasDefaultOres() {
            return false;
        }

        @Override
        public SurfaceRuleBuilder surface() {
            return super.surface().rule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)new RoughNoiseCondition(Noises.f_189275_, 0.14), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)NetherBlocks.SWAMPLAND_GRASS.m_49966_()))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)new RoughNoiseCondition(Noises.f_189276_, 0.19), (SurfaceRules.RuleSource)NetherGrasslands.SOUL_SAND), NetherGrasslands.SOUL_SOIL}));
        }
    }
}

