/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.spawning.SpawnRuleBuilder;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.interfaces.SpawnRule;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.entity.EntityFirefly;
import org.betterx.betternether.entity.EntityFlyingPig;
import org.betterx.betternether.entity.EntityHydrogenJellyfish;
import org.betterx.betternether.entity.EntityJungleSkeleton;
import org.betterx.betternether.entity.EntityNaga;
import org.betterx.betternether.entity.EntityNagaProjectile;
import org.betterx.betternether.entity.EntitySkull;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.ui.ColorUtil;

public class NetherEntities {
    public static final Map<EntityType<? extends Entity>, AttributeSupplier> ATTRIBUTES = Maps.newHashMap();
    private static final List<BCLEntityWrapper<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static final EntityType<EntityNagaProjectile> NAGA_PROJECTILE = FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, EntityNagaProjectile::new).dimensions(EntityDimensions.m_20398_((float)1.0f, (float)1.0f)).disableSummon().build();
    public static final BCLEntityWrapper<EntityFirefly> FIREFLY = NetherEntities.register("firefly", MobCategory.AMBIENT, 0.5f, 0.5f, EntityFirefly::new, EntityFirefly.createMobAttributes(), true, ColorUtil.color((int)255, (int)223, (int)168), ColorUtil.color((int)233, (int)182, (int)95));
    public static final BCLEntityWrapper<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH = NetherEntities.register("hydrogen_jellyfish", MobCategory.AMBIENT, 2.0f, 5.0f, EntityHydrogenJellyfish::new, EntityHydrogenJellyfish.createMobAttributes(), false, ColorUtil.color((int)253, (int)164, (int)24), ColorUtil.color((int)88, (int)21, (int)4));
    public static final BCLEntityWrapper<EntityNaga> NAGA = NetherEntities.register("naga", MobCategory.MONSTER, 0.625f, 2.75f, EntityNaga::new, EntityNaga.createMobAttributes(), true, ColorUtil.color((int)12, (int)12, (int)12), ColorUtil.color((int)210, (int)90, (int)26));
    public static final BCLEntityWrapper<EntityFlyingPig> FLYING_PIG = NetherEntities.register("flying_pig", MobCategory.AMBIENT, 1.0f, 1.25f, EntityFlyingPig::new, EntityFlyingPig.createMobAttributes(), true, ColorUtil.color((int)241, (int)140, (int)93), ColorUtil.color((int)176, (int)58, (int)47));
    public static final BCLEntityWrapper<EntityJungleSkeleton> JUNGLE_SKELETON = NetherEntities.register("jungle_skeleton", MobCategory.MONSTER, 0.6f, 1.99f, EntityJungleSkeleton::new, EntityJungleSkeleton.m_33035_(), true, ColorUtil.color((int)134, (int)162, (int)149), ColorUtil.color((int)6, (int)111, (int)79));
    public static final BCLEntityWrapper<EntitySkull> SKULL = NetherEntities.register("skull", MobCategory.MONSTER, 0.625f, 0.625f, EntitySkull::new, EntitySkull.createMobAttributes(), true, ColorUtil.color((int)24, (int)19, (int)19), ColorUtil.color((int)255, (int)28, (int)18));
    public static final int MAX_FLOAT_HEIGHT = 7;
    public static final SpawnRule RULE_FLOAT_NOT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, false);
    public static final SpawnRule RULE_FLOAT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, true);

    private static <T extends Mob> BCLEntityWrapper<T> register(String name, MobCategory group, float width, float height, EntityType.EntityFactory<T> entity, AttributeSupplier.Builder attributes, boolean fixedSize, int eggColor, int dotsColor) {
        ResourceLocation id = BetterNether.makeID(name);
        EntityType type = FabricEntityTypeBuilder.create((MobCategory)group, entity).dimensions(fixedSize ? EntityDimensions.m_20398_((float)width, (float)height) : EntityDimensions.m_20395_((float)width, (float)height)).fireImmune().build();
        type = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)id, (Object)type);
        FabricDefaultAttributeRegistry.register((EntityType)type, (AttributeSupplier.Builder)attributes);
        NetherItems.makeEgg("spawn_egg_" + name, (EntityType<? extends Mob>)type, eggColor, dotsColor);
        if (Configs.MOBS.getBooleanRoot(id.m_135815_(), true)) {
            return new BCLEntityWrapper(type, true);
        }
        BCLEntityWrapper wrapper = new BCLEntityWrapper(type, false);
        NETHER_ENTITIES.add(wrapper);
        return wrapper;
    }

    private static boolean testSpawnAboveLava(LevelAccessor world, BlockPos pos, boolean allow) {
        int h = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)pos, (int)9);
        if (h > 7) {
            return false;
        }
        for (int i = 1; i <= h + 1; ++i) {
            if (!BlocksHelper.isLava((BlockState)world.m_8055_(pos.m_6625_(i)))) continue;
            return allow;
        }
        return !allow;
    }

    public static void register() {
        NetherEntities.registerEntity("naga_projectile", NAGA_PROJECTILE);
        SpawnRuleBuilder.start(FIREFLY).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(32, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(HYDROGEN_JELLYFISH).belowMaxHeight().maxNearby(24, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(NAGA).hostile(8).maxNearby(32, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(FLYING_PIG).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(16, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(JUNGLE_SKELETON).notPeaceful().maxNearby(16, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(SKULL).belowMaxHeight().vanillaHostile().maxNearby(16, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
    }

    public static void registerEntity(String name, EntityType<? extends LivingEntity> entity) {
        NetherEntities.registerEntity(name, entity, Mob.m_21552_().m_22265_());
    }

    public static void registerEntity(String name, EntityType<? extends Entity> entity, AttributeSupplier container) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation("betternether", name), entity);
        ATTRIBUTES.put(entity, container);
    }

    public static boolean isNetherEntity(Entity entity) {
        return NETHER_ENTITIES.contains(entity.m_6095_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void modifyNonBNBiome(ResourceLocation biomeID, Holder<Biome> biome) {
        boolean isCrimson = biomeID.equals((Object)Biomes.f_48200_.m_135782_());
        KnownSpawnTypes.FIREFLY.addSpawn(biomeID, biome, isCrimson ? 3.0f : 1.0f);
        KnownSpawnTypes.HYDROGEN_JELLYFISH.addSpawn(biomeID, biome);
        KnownSpawnTypes.NAGA.addSpawn(biomeID, biome, isCrimson ? 0.0f : 1.0f);
        PathConfig pathConfig = Configs.BIOMES;
        synchronized (pathConfig) {
            Configs.BIOMES.saveChanges();
        }
    }

    public static enum KnownSpawnTypes {
        GHAST(50, 4, 4, EntityType.f_20453_),
        ZOMBIFIED_PIGLIN(100, 4, 4, EntityType.f_20531_),
        MAGMA_CUBE(2, 4, 4, EntityType.f_20468_),
        SKULL(2, 2, 4, SKULL),
        ENDERMAN(1, 4, 4, EntityType.f_20566_),
        PIGLIN(15, 4, 4, EntityType.f_20511_),
        STRIDER(60, 1, 2, EntityType.f_20482_),
        HOGLIN(9, 1, 2, EntityType.f_20456_),
        FIREFLY(5, 1, 3, FIREFLY),
        HYDROGEN_JELLYFISH(5, 2, 6, HYDROGEN_JELLYFISH),
        NAGA(8, 3, 5, NAGA),
        FLYING_PIG(20, 2, 4, FLYING_PIG),
        JUNGLE_SKELETON(40, 2, 4, JUNGLE_SKELETON),
        PIGLIN_BRUTE(0, 1, 1, EntityType.f_20512_);

        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final EntityType type;
        public final BCLEntityWrapper wrapper;

        public boolean isVanilla() {
            return this.wrapper == null;
        }

        public void addSpawn(BCLBiomeBuilder builder, NetherBiomeConfig data) {
            String category = data.configGroup() + ".spawn." + this.type.m_20674_().m_21607_() + "." + this.type.m_20675_().replace("entity.", "");
            int weight = Configs.BIOMES.getInt(category, "weight", data.spawnWeight(this));
            int min = Configs.BIOMES.getInt(category, "minGroupSize", this.minGroupSize);
            int max = Configs.BIOMES.getInt(category, "maxGroupSize", this.maxGroupSize);
            if (this.wrapper == null) {
                builder.spawn(this.type, weight, min, max);
            } else {
                builder.spawn(this.wrapper, weight, min, max);
            }
        }

        public void addSpawn(ResourceLocation ID, Holder<Biome> biome, float multiplier) {
            String category = ID.m_135827_() + "." + ID.m_135815_() + ".spawn." + this.type.m_20674_().m_21607_() + "." + this.type.m_20675_().replace("entity.", "");
            int dweight = Configs.BIOMES.getInt(category, "weight", (int)((float)this.weight * multiplier));
            int min = Configs.BIOMES.getInt(category, "minGroupSize", this.minGroupSize);
            int max = Configs.BIOMES.getInt(category, "maxGroupSize", this.maxGroupSize);
            BiomeAPI.addBiomeMobSpawn(biome, (EntityType)this.type, (int)dweight, (int)min, (int)max);
        }

        public void addSpawn(ResourceLocation ID, Holder<Biome> biome) {
            this.addSpawn(ID, biome, 1.0f);
        }

        private KnownSpawnTypes(int w, int min, int max, EntityType type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type;
            this.wrapper = null;
        }

        private <M extends Mob> KnownSpawnTypes(int w, int min, int max, BCLEntityWrapper type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type.type();
            this.wrapper = type;
        }
    }
}

