/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

class DebugShader
extends ShaderInstance {
    private static Program vertexShader;
    private static Program fragmentShader;

    private static String doInit(ResourceProvider factory, String baseName) {
        try {
            System.out.println("Reloading Shader");
            vertexShader = DebugShader.getOrCreate(factory, Program.Type.VERTEX, "bn_debug");
            fragmentShader = DebugShader.getOrCreate(factory, Program.Type.FRAGMENT, "bn_debug");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baseName;
    }

    public DebugShader(ResourceProvider factory) throws IOException {
        super(factory, DebugShader.doInit(factory, "rendertype_eyes"), DefaultVertexFormat.f_85812_);
    }

    public Program m_108964_() {
        return fragmentShader;
    }

    public Program m_108962_() {
        return vertexShader;
    }

    public void m_142662_() {
        this.m_108964_().m_166610_((Shader)this);
        this.m_108962_().m_166610_((Shader)this);
    }

    private static Program getOrCreate(final ResourceProvider factory, Program.Type type, String name) throws IOException {
        System.out.println("Loading " + name + type.m_85569_());
        String workingDirAbs = Paths.get("", new String[0]).toAbsolutePath().toString();
        String shaderFile = workingDirAbs + "/" + name + type.m_85569_();
        String dummyName = "shaders/core/" + name + type.m_85569_();
        final String basePath = FileUtil.m_179922_((String)dummyName);
        FileInputStream file = new FileInputStream(new File(shaderFile));
        Program program = Program.m_166604_((Program.Type)type, (String)name, (InputStream)file, (String)"betternether", (GlslPreprocessor)new GlslPreprocessor(){
            private final Set<String> visitedImports = Sets.newHashSet();

            public String m_142138_(boolean inline, String name) {
                String inludePath = inline ? basePath : "shaders/include/";
                name = FileUtil.m_179924_((String)(inludePath + name));
                if (!this.visitedImports.add(name)) {
                    return null;
                }
                ResourceLocation identifier = new ResourceLocation(name);
                try {
                    String content;
                    Resource resource = factory.m_213713_(identifier).orElse(null);
                    try (InputStream is = resource.m_215507_();){
                        content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                    return content;
                }
                catch (IOException var9) {
                    System.err.println("Could not open GLSL import " + name + ": " + var9.getMessage());
                    return "#error " + var9.getMessage();
                }
            }
        });
        return program;
    }
}

