/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.entity.EntityNaga;

public class EntityNagaProjectile
extends FlyingMob {
    private static final int MAX_LIFE_TIME = 60;
    private int lifeTime = 0;

    public EntityNagaProjectile(EntityType<? extends EntityNagaProjectile> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
    }

    public void setParams(LivingEntity owner, Entity target) {
        this.m_6034_(this.m_20185_(), this.m_20188_() - (double)this.m_20206_(), this.m_20189_());
        Vec3 dir = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.25, 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_(2.0);
        this.m_20256_(dir);
        this.f_19854_ = this.m_20185_() - dir.f_82479_;
        this.f_19855_ = this.m_20186_() - dir.f_82480_;
        this.f_19856_ = this.m_20189_() - dir.f_82481_;
    }

    public boolean m_20068_() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 128.0;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + this.f_19796_.m_188583_() * 0.2, this.m_20186_() + this.f_19796_.m_188583_() * 0.2, this.m_20189_() + this.f_19796_.m_188583_() * 0.2, 0.0, 0.0, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.m_188583_() * 0.2, this.m_20186_() + this.f_19796_.m_188583_() * 0.2, this.m_20189_() + this.f_19796_.m_188583_() * 0.2, 0.0, 0.0, 0.0);
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, entity -> entity.m_6084_() && entity instanceof LivingEntity);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            this.onCollision(hitResult);
        }
        ++this.lifeTime;
        if (this.lifeTime > 60) {
            this.effectKill();
        }
        if (this.isSame(this.f_19854_, this.m_20185_()) && this.isSame(this.f_19855_, this.m_20186_()) && this.isSame(this.f_19856_, this.m_20189_())) {
            this.effectKill();
        }
    }

    private boolean isSame(double a, double b) {
        return Math.abs(a - b) < 0.1;
    }

    protected void onCollision(HitResult hitResult) {
        Entity entity;
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + this.f_19796_.m_188583_() * 0.5, this.m_20186_() + this.f_19796_.m_188583_() * 0.5, this.m_20189_() + this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2);
            }
            this.effectKill();
        } else if (type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).m_82443_()) != this && entity instanceof LivingEntity && !(entity instanceof EntityNaga)) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.m_21023_(MobEffects.f_19615_)) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                living.m_6469_(living.m_269291_().m_269264_(), 1.0f);
            }
            this.effectKill();
        }
    }

    private void effectKill() {
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_() * 0.5, this.m_20186_() + this.f_19796_.m_188583_() * 0.5, this.m_20189_() + this.f_19796_.m_188583_() * 0.5, 0.1, 0.1, 0.1);
        }
        this.m_6074_();
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    public boolean m_20067_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("life", this.lifeTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("life")) {
            this.lifeTime = tag.m_128451_("life");
        }
    }
}

