/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntityHydrogenJellyfish
extends DespawnableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(EntityHydrogenJellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Vec3 preVelocity;
    private Vec3 newVelocity = new Vec3(0.0, 0.0, 0.0);
    private int timer;
    private int timeOut;
    private float prewYaw;
    private float nextYaw;

    public EntityHydrogenJellyfish(EntityType<? extends EntityHydrogenJellyfish> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(0.5f + this.f_19796_.m_188501_()));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 0.5).m_22268_(Attributes.f_22280_, 0.05).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 20.0);
    }

    protected boolean m_142039_() {
        return true;
    }

    protected void m_203347_(TagKey<Fluid> fluid) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Scale", this.m_6134_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Scale")) {
            this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(tag.m_128457_("Scale")));
        }
        this.m_6210_();
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.m_6134_());
    }

    public void m_6123_(Player player) {
        player.m_6469_(player.m_269291_().m_269264_(), 3.0f);
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_20343_(x, y, z);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (SCALE.equals(data)) {
            this.m_6210_();
        }
    }

    protected void m_8024_() {
        ++this.timer;
        if (this.timer > this.timeOut) {
            this.prewYaw = this.m_146908_();
            this.nextYaw = this.f_19796_.m_188501_() * 360.0f;
            double rads = Math.toRadians(this.nextYaw + 90.0f);
            double vx = Math.cos(rads) * (double)this.m_274460_();
            double vz = Math.sin(rads) * (double)this.m_274460_();
            BlockPos bp = this.m_20183_();
            double vy = this.f_19796_.m_188500_() * (double)this.m_274460_() * 0.75;
            if (this.m_9236_().m_8055_(bp).m_60795_() && this.m_9236_().m_8055_(bp.m_6625_(2)).m_60795_() && this.m_9236_().m_8055_(bp.m_6625_(3)).m_60795_() && this.m_9236_().m_8055_(bp.m_6625_(4)).m_60795_()) {
                vy = -vy;
            }
            this.preVelocity = this.newVelocity;
            this.newVelocity = new Vec3(vx, vy, vz);
            this.timer = 0;
            this.timeOut = this.f_19796_.m_188503_(300) + 120;
        }
        if (this.timer <= 120) {
            if (this.m_146908_() != this.nextYaw) {
                float delta = (float)this.timer / 120.0f;
                this.m_146922_(EntityHydrogenJellyfish.lerpAngleDegrees(delta, this.prewYaw, this.nextYaw));
                this.m_20334_(Mth.m_14139_((double)delta, (double)this.preVelocity.f_82479_, (double)this.newVelocity.f_82479_), Mth.m_14139_((double)delta, (double)this.preVelocity.f_82480_, (double)this.newVelocity.f_82480_), Mth.m_14139_((double)delta, (double)this.preVelocity.f_82481_, (double)this.newVelocity.f_82481_));
            }
        } else {
            this.m_20256_(this.newVelocity);
        }
    }

    public static float lerpAngleDegrees(float delta, float first, float second) {
        return first + delta * Mth.m_14177_((float)(second - first));
    }

    public int m_5792_() {
        return 1;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_9236_().f_46443_) {
            float scale = this.m_6134_() * 3.0f;
            for (int i = 0; i < 20; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + this.f_19796_.m_188583_() * (double)scale, this.m_20188_() + this.f_19796_.m_188583_() * (double)scale, this.m_20189_() + this.f_19796_.m_188583_() * (double)scale, 0.0, 0.0, 0.0);
            }
        } else if (source != this.m_9236_().m_269111_().m_269341_()) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 7.0f * this.m_6134_(), Level.ExplosionInteraction.MOB);
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SoundsRegistry.MOB_JELLYFISH.m_203334_();
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268493_) || source.m_7640_() != null || source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntityHydrogenJellyfish> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        try {
            AABB box = new AABB(pos).m_82377_(64.0, 256.0, 64.0);
            List list = world.m_6443_(EntityHydrogenJellyfish.class, box, entity -> true);
            return list.size() < 4;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }
}

