/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherEntities;

public class EntityFlyingPig
extends DespawnableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.m_135353_(EntityFlyingPig.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int BIT_ROOSTING = 0;
    private static final int BIT_WARTED = 1;
    private Goal preGoal;

    public EntityFlyingPig(EntityType<? extends EntityFlyingPig> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21364_ = 2;
    }

    protected float m_274460_() {
        return this.m_6688_() instanceof Player ? this.m_6113_() * 0.1f : 0.3f;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new FindFoodGoal());
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SittingGoal());
        this.f_21345_.m_25352_(5, (Goal)new RoostingGoal());
        this.f_21345_.m_25352_(6, (Goal)new WanderAroundGoal());
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_46859_(pos);
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(true);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit((byte)0, 1, this.f_19796_.m_188503_(4) == 0));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("byteData", ((Byte)this.f_19804_.m_135370_(DATA_SHARED_FLAGS_ID)).byteValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("byteData")) {
            this.f_19804_.m_135381_(DATA_SHARED_FLAGS_ID, (Object)tag.m_128445_("byteData"));
        }
    }

    public boolean isRoosting() {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_SHARED_FLAGS_ID);
        return MHelper.getBit(b, 0);
    }

    public void setRoosting(boolean roosting) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_SHARED_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit(b, 0, roosting));
    }

    public boolean isWarted() {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_SHARED_FLAGS_ID);
        return MHelper.getBit(b, 1);
    }

    public void setWarted(boolean warted) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_SHARED_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit(b, 1, warted));
    }

    protected float m_6121_() {
        return MHelper.randRange(0.85f, 1.15f, this.f_19796_);
    }

    public float m_6100_() {
        return MHelper.randRange(0.3f, 0.4f, this.f_19796_);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12235_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12234_;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12233_;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    protected boolean m_142039_() {
        return true;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    protected void m_6153_() {
        if (!this.m_9236_().f_46443_ && this.isWarted() && this.m_9236_().m_7654_().m_129900_().m_46207_(GameRules.f_46137_)) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42588_, MHelper.randRange(1, 3, this.f_19796_)));
        }
        super.m_6153_();
    }

    public int m_5792_() {
        return 5;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        EntityFlyingPig pig = (EntityFlyingPig)NetherEntities.FLYING_PIG.type().m_20615_(this.m_9236_());
        pig.setWarted(pig.isWarted());
        return pig;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42588_;
    }

    class FindFoodGoal
    extends Goal {
        private List<ItemEntity> foods;
        private ItemEntity target;

        FindFoodGoal() {
        }

        public boolean m_8036_() {
            return this.hasNearFood();
        }

        public void m_8056_() {
            BlockPos pos = this.getFood();
            Path path = EntityFlyingPig.this.f_21344_.m_7864_(pos, 1);
            if (path != null) {
                EntityFlyingPig.this.f_21344_.m_26536_(path, (double)EntityFlyingPig.this.m_274460_());
                EntityFlyingPig.this.setRoosting(false);
            }
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.target.m_6084_() && EntityFlyingPig.this.f_21344_.m_26572_();
        }

        public void m_8041_() {
            if (this.target.m_6084_() && (double)this.target.m_20270_((Entity)EntityFlyingPig.this) < 1.3) {
                ItemStack stack = this.target.m_32055_();
                ItemParticleOption effect = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)stack.m_41720_()));
                for (ServerPlayer serverPlayerEntity : EntityFlyingPig.this.m_9236_().m_6907_()) {
                    if (!(serverPlayerEntity.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()) < 4096.0)) continue;
                    serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)effect, false, this.target.m_20185_(), this.target.m_20186_() + 0.2, this.target.m_20189_(), 0.2f, 0.2f, 0.2f, 0.0f, 16));
                }
                EntityFlyingPig.this.m_5584_(EntityFlyingPig.this.m_9236_(), stack);
                this.target.m_6074_();
                EntityFlyingPig.this.m_5634_(stack.m_41613_());
                EntityFlyingPig.this.m_20334_(0.0, 0.2f, 0.0);
            }
            EntityFlyingPig.this.preGoal = this;
            super.m_8041_();
        }

        private BlockPos getFood() {
            this.target = this.foods.get(EntityFlyingPig.this.f_19796_.m_188503_(this.foods.size()));
            return this.target.m_20183_();
        }

        private boolean hasNearFood() {
            AABB box = new AABB(EntityFlyingPig.this.m_20183_()).m_82400_(16.0);
            this.foods = EntityFlyingPig.this.m_9236_().m_6443_(ItemEntity.class, box, entity -> entity.m_32055_().m_41614_());
            return !this.foods.isEmpty();
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean m_8036_() {
            return EntityFlyingPig.this.isRoosting();
        }

        public boolean m_8045_() {
            return this.timer < this.ammount;
        }

        public void m_8056_() {
            this.timer = 0;
            this.ammount = MHelper.randRange(80, 160, EntityFlyingPig.this.f_19796_);
            EntityFlyingPig.this.m_20334_(0.0, 0.0, 0.0);
            EntityFlyingPig.this.m_5618_(EntityFlyingPig.this.f_19796_.m_188501_() * ((float)Math.PI * 2));
            super.m_8056_();
        }

        public void m_8041_() {
            EntityFlyingPig.this.setRoosting(false);
            EntityFlyingPig.this.m_20334_(0.0, -0.1f, 0.0);
            EntityFlyingPig.this.preGoal = this;
            super.m_8041_();
        }

        public void m_8037_() {
            ++this.timer;
            super.m_8037_();
        }
    }

    class RoostingGoal
    extends Goal {
        BlockPos roosting;

        RoostingGoal() {
        }

        public boolean m_8036_() {
            return !(EntityFlyingPig.this.preGoal instanceof SittingGoal) && EntityFlyingPig.this.f_21344_.m_26571_() && !EntityFlyingPig.this.isRoosting() && EntityFlyingPig.this.f_19796_.m_188503_(4) == 0;
        }

        public boolean m_8045_() {
            return EntityFlyingPig.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Path path;
            BlockPos pos = this.getRoostingLocation();
            if (pos != null && (path = EntityFlyingPig.this.f_21344_.m_7864_(pos, 1)) != null) {
                EntityFlyingPig.this.f_21344_.m_26536_(path, (double)EntityFlyingPig.this.m_274460_());
                this.roosting = pos;
            }
            super.m_8056_();
        }

        public void m_8041_() {
            if (this.roosting != null) {
                EntityFlyingPig.this.m_20343_((double)this.roosting.m_123341_() + 0.5, (double)this.roosting.m_123342_() - 0.25, (double)this.roosting.m_123343_() + 0.5);
                EntityFlyingPig.this.setRoosting(true);
                EntityFlyingPig.this.preGoal = this;
            }
            super.m_8041_();
        }

        private BlockPos getRoostingLocation() {
            int up;
            BlockPos pos = EntityFlyingPig.this.m_20183_();
            Level world = EntityFlyingPig.this.m_9236_();
            if (world.m_8055_((pos = pos.m_5484_(Direction.UP, up = BlocksHelper.upRay((LevelAccessor)world, pos, 16))).m_7494_()).m_60734_() == Blocks.f_50451_) {
                return pos;
            }
            return null;
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return EntityFlyingPig.this.f_21344_.m_26571_() && !EntityFlyingPig.this.isRoosting();
        }

        public boolean m_8045_() {
            return EntityFlyingPig.this.f_21344_.m_26572_() && EntityFlyingPig.this.f_19796_.m_188503_(32) > 0;
        }

        public void m_8056_() {
            if (EntityFlyingPig.this.m_9236_().m_6425_(EntityFlyingPig.this.m_20183_()).m_76178_()) {
                BlockPos pos = this.getRandomLocation();
                Path path = EntityFlyingPig.this.f_21344_.m_7864_(pos, 1);
                if (path != null) {
                    EntityFlyingPig.this.f_21344_.m_26536_(path, (double)EntityFlyingPig.this.m_274460_());
                } else {
                    EntityFlyingPig.this.m_20334_(0.0, -0.2, 0.0);
                }
                EntityFlyingPig.this.setRoosting(false);
            } else {
                EntityFlyingPig.this.m_20334_(0.0, 1.0, 0.0);
            }
            super.m_8056_();
        }

        private BlockPos getRandomLocation() {
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            bpos.m_122169_(EntityFlyingPig.this.m_20185_(), EntityFlyingPig.this.m_20186_(), EntityFlyingPig.this.m_20189_());
            Vec3 angle = EntityFlyingPig.this.m_20252_(0.0f);
            Vec3 airTarget = HoverRandomPos.m_148465_((PathfinderMob)EntityFlyingPig.this, (int)8, (int)7, (double)angle.f_82479_, (double)angle.f_82481_, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = HoverRandomPos.m_148465_((PathfinderMob)EntityFlyingPig.this, (int)32, (int)10, (double)angle.f_82479_, (double)angle.f_82481_, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.m_142451_(bpos.m_123341_() + this.randomRange(32));
                bpos.m_142443_(bpos.m_123343_() + this.randomRange(32));
                bpos.m_142448_(bpos.m_123342_() + this.randomRange(32));
                return bpos;
            }
            bpos.m_122169_(airTarget.m_7096_(), airTarget.m_7098_(), airTarget.m_7094_());
            BlockPos down = bpos.m_7495_();
            if (EntityFlyingPig.this.m_9236_().m_8055_(down).m_60838_((BlockGetter)EntityFlyingPig.this.m_9236_(), down)) {
                bpos.m_122173_(Direction.UP);
            }
            while (!EntityFlyingPig.this.m_9236_().m_6425_((BlockPos)bpos).m_76178_()) {
                bpos.m_122173_(Direction.UP);
            }
            return bpos;
        }

        private int randomRange(int side) {
            RandomSource random = EntityFlyingPig.this.f_19796_;
            return random.m_188503_(side + 1) - (side >> 1);
        }

        public void m_8041_() {
            EntityFlyingPig.this.preGoal = this;
            super.m_8041_();
        }
    }
}

