/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks.complex;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.SlotMap;
import org.betterx.bclib.complexmaterials.set.wood.Bookshelf;
import org.betterx.bclib.complexmaterials.set.wood.Planks;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CraftingRecipeBuilder;
import org.betterx.betternether.blocks.BlockReedsBlock;
import org.betterx.betternether.blocks.complex.ReedBookshelfBlock;
import org.betterx.betternether.blocks.complex.RoofMaterial;
import org.betterx.betternether.registry.NetherBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherReedMaterial
extends RoofMaterial<NetherReedMaterial> {
    public NetherReedMaterial() {
        super("nether_reed", MapColor.f_283772_, MapColor.f_283772_);
    }

    @Override
    protected SlotMap<WoodenComplexMaterial> createMaterialSlots() {
        return super.createMaterialSlots().remove(WoodSlots.LOG).remove(WoodSlots.BARK).remove(WoodSlots.STRIPPED_LOG).remove(WoodSlots.STRIPPED_BARK).replace((MaterialSlot)new Planks(){

            @NotNull
            protected Block createBlock(WoodenComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return new BlockReedsBlock();
            }

            @Nullable
            protected void makeRecipe(ComplexMaterial parentMaterial, ResourceLocation id) {
                ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)id, (ItemLike)parentMaterial.getBlock(WoodSlots.PLANKS)).setOutputCount(1).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{NetherReedMaterial.this.getStem()}).setGroup("planks").setCategory(RecipeCategory.BUILDING_BLOCKS)).build();
            }
        }).replace((MaterialSlot)new Bookshelf(){

            @NotNull
            protected Block createBlock(WoodenComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return new ReedBookshelfBlock(parentMaterial.getBlock(WoodSlots.PLANKS));
            }
        });
    }

    @Nullable
    public <M extends ComplexMaterial> Block getBlock(MaterialSlot<M> key) {
        if (key.suffix.equals(WoodSlots.STRIPPED_LOG.suffix)) {
            return this.getStem();
        }
        return super.getBlock(key);
    }

    public Block getStem() {
        return NetherBlocks.NETHER_REED_STEM;
    }

    public BoatTypeOverride supplyBoatType() {
        return BoatTypeOverride.create((String)this.getModID(), (String)this.getBaseName(), (Block)this.getBlock(WoodSlots.PLANKS), (boolean)true);
    }
}

