/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourSapling;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnSouldSand;
import org.betterx.betternether.registry.features.configured.NetherTrees;

public class BlockWartSeed
extends BlockBaseNotFull
implements BonemealableBlock,
SurvivesOnSouldSand,
BehaviourSapling {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public BlockWartSeed() {
        super(Materials.NETHER_SAPLING.m_284180_(MapColor.f_283798_).m_60918_(SoundType.f_56719_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction[] directions = ctx.m_6232_();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            Direction direction2 = direction.m_122424_();
            if (!(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction2)).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return BlockWartSeed.m_49863_((LevelReader)world, (BlockPos)blockPos, (Direction)direction) || this.canSurviveOnTop(world, pos);
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction == Direction.UP && BlocksHelper.isSoulSand(world.m_8055_(pos.m_7495_()));
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(8) == 0;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        NetherTrees.WART_TREE.placeInWorld(world, pos, random);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.m_83048_((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.m_83048_((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.m_83048_((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75));
    }
}

