/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether;

import net.fabricmc.api.ModInitializer;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.betternether.Patcher;
import org.betterx.betternether.advancements.BNCriterion;
import org.betterx.betternether.commands.CommandRegistry;
import org.betterx.betternether.config.Config;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.enchantments.ObsidianBreaker;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.recipes.IntegrationRecipes;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;
import org.betterx.betternether.registry.NetherBiomes;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherPoiTypes;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.NetherTemplates;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.betternether.tab.CreativeTabs;
import org.betterx.betternether.world.BNWorldGenerator;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;

public class BetterNether
implements ModInitializer {
    public static final String MOD_ID = "betternether";
    public static final Logger LOGGER = new Logger("betternether");
    private static boolean thinArmor = true;
    private static boolean lavafallParticles = true;
    private static float fogStart = 0.05f;
    private static float fogEnd = 0.5f;

    private void onDatagen() {
    }

    public void onInitialize() {
        LOGGER.info("=^..^=    BetterNether for 1.20    =^..^=");
        this.initOptions();
        SoundsRegistry.ensureStaticallyLoaded();
        NetherBlocks.register();
        BlockEntitiesRegistry.register();
        NetherItems.register();
        NetherTemplates.ensureStaticallyLoaded();
        NetherEntities.register();
        BNWorldGenerator.onModInit();
        NetherPoiTypes.register();
        NetherFeatures.register();
        NetherStructures.register();
        NetherBiomes.register();
        BrewingRegistry.register();
        CommandRegistry.register();
        ObsidianBreaker.register();
        Config.save();
        IntegrationRecipes.register();
        NetherTags.register();
        BNLoot.register();
        BNCriterion.register();
        NetherVegetation.setupBonemealFeatures();
        Configs.saveConfigs();
        WorldConfig.registerModCache((String)MOD_ID);
        DataExchangeAPI.registerMod((String)MOD_ID);
        Patcher.register();
        CreativeTabs.register();
        if (BCLib.isDatagen()) {
            this.onDatagen();
        }
    }

    private void initOptions() {
        thinArmor = Configs.MAIN.getBoolean("improvement", "smaller_armor_offset", true);
        lavafallParticles = Configs.MAIN.getBoolean("improvement", "lavafall_particles", true);
        float density = Configs.MAIN.getFloat("improvement", "fog_density[vanilla: 1.0]", 0.75f);
        BetterNether.changeFogDensity(density);
    }

    public static boolean hasThinArmor() {
        return thinArmor;
    }

    public static void setThinArmor(boolean value) {
        thinArmor = value;
    }

    public static boolean hasLavafallParticles() {
        return lavafallParticles;
    }

    public static void changeFogDensity(float density) {
        fogStart = -0.45f * density + 0.5f;
        fogEnd = -0.5f * density + 1.0f;
    }

    public static float getFogStart() {
        return fogStart;
    }

    public static float getFogEnd() {
        return fogEnd;
    }

    public static ResourceLocation makeID(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

