/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.advancement;

import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;
import org.betterx.bclib.api.v3.datagen.AdvancementDataProvider;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.complexmaterials.MetalMaterial;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.betterend.world.biome.EndBiome;

public class EndAdvancementDataProvider
extends AdvancementDataProvider {
    public EndAdvancementDataProvider(FabricDataOutput output) {
        super(List.of("betterend"), output);
    }

    protected void bootstrap() {
        ResourceLocation root = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("root")).startDisplay((ItemLike)EndBlocks.END_MYCELIUM).frame(FrameType.TASK).hideFromChat().background(new ResourceLocation("textures/gui/advancements/backgrounds/end.png")).endDisplay().addCriterion("welcome", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.f_52592_)).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation enterEnd = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("enter_end")).startDisplay((ItemLike)EndBlocks.CAVE_MOSS).endDisplay().parent(root).addCriterion("entered_end", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_((ResourceKey)Level.f_46430_)).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation portal = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("portal")).parent(enterEnd).startDisplay((ItemLike)EndBlocks.ETERNAL_PEDESTAL).frame(FrameType.GOAL).endDisplay().addAtStructureCriterion("eternal_portal", EndStructures.ETERNAL_PORTAL).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation portalOn = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("portal_on")).parent(portal).startDisplay((ItemLike)EndItems.ETERNAL_CRYSTAL).endDisplay().addCriterion("turn_on", (CriterionTriggerInstance)BECriteria.PORTAL_ON_TRIGGER).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation portalTravel = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("portal_travel")).parent(portalOn).startDisplay((ItemLike)Items.f_42276_).frame(FrameType.CHALLENGE).endDisplay().addCriterion("travel", (CriterionTriggerInstance)BECriteria.PORTAL_TRAVEL_TRIGGER).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation allTheBiomes = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("all_the_biomes")).parent(enterEnd).startDisplay((ItemLike)EndItems.AETERNIUM_BOOTS).frame(FrameType.CHALLENGE).endDisplay().addVisitBiomesCriterion(EndBiome.getAllBeBiomes().stream().map(b -> b.getBiomeKey()).toList()).requirements(RequirementsStrategy.f_15978_).rewardXP(1500).build();
        ResourceLocation village = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("village")).parent(allTheBiomes).startDisplay((ItemLike)EndBlocks.TENANEA.getBlock(WoodSlots.DOOR)).frame(FrameType.GOAL).endDisplay().addAtStructureCriterion("end_village", EndStructures.END_VILLAGE).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation allElytras = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("all_elytras")).parent(enterEnd).startDisplay((ItemLike)EndItems.CRYSTALITE_ELYTRA).frame(FrameType.GOAL).endDisplay().addInventoryChangedCriterion("vanilla", new ItemLike[]{Items.f_42741_}).addInventoryChangedCriterion("crystalite", new ItemLike[]{EndItems.CRYSTALITE_ELYTRA}).addInventoryChangedCriterion("armored", new ItemLike[]{EndItems.ARMORED_ELYTRA}).requirements(RequirementsStrategy.f_15978_).build();
        ResourceLocation infusion = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("infusion")).parent(enterEnd).startDisplay((ItemLike)EndBlocks.INFUSION_PEDESTAL).endDisplay().addInventoryChangedCriterion("infusion_pedestal", new ItemLike[]{EndBlocks.INFUSION_PEDESTAL}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation infusionFinished = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("infusion_finished")).parent(infusion).startDisplay((ItemLike)Items.f_42545_).frame(FrameType.GOAL).endDisplay().addCriterion("finished", (CriterionTriggerInstance)BECriteria.INFUSION_FINISHED_TRIGGER).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation allTheTemplates = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("all_the_templates")).parent(enterEnd).startDisplay((ItemLike)EndTemplates.TOOL_ASSEMBLY).frame(FrameType.CHALLENGE).endDisplay().addInventoryChangedAnyCriterion("got_handle", new ItemLike[]{EndTemplates.HANDLE_ATTACHMENT}).addInventoryChangedAnyCriterion("got_tool", new ItemLike[]{EndTemplates.TOOL_ASSEMBLY}).addInventoryChangedAnyCriterion("got_leather", new ItemLike[]{EndTemplates.LEATHER_HANDLE_ATTACHMENT}).addInventoryChangedAnyCriterion("got_plate", new ItemLike[]{EndTemplates.PLATE_UPGRADE}).addInventoryChangedAnyCriterion("got_terminite", new ItemLike[]{EndTemplates.TERMINITE_UPGRADE}).addInventoryChangedAnyCriterion("got_aeternium", new ItemLike[]{EndTemplates.AETERNIUM_UPGRADE}).addInventoryChangedAnyCriterion("got_thallasium", new ItemLike[]{EndTemplates.THALLASIUM_UPGRADE}).addInventoryChangedAnyCriterion("got_netherite", new ItemLike[]{EndTemplates.NETHERITE_UPGRADE}).requirements(RequirementsStrategy.f_15978_).rewardXP(1500).build();
        ResourceLocation hammer = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("hammer")).parent(enterEnd).startDisplay((ItemLike)EndItems.DIAMOND_HAMMER).endDisplay().addInventoryChangedCriterion("got_diamond_hammer", new ItemLike[]{EndItems.DIAMOND_HAMMER}).addInventoryChangedCriterion("got_thallasium_hammer", new ItemLike[]{EndBlocks.THALLASIUM.hammer}).addInventoryChangedCriterion("got_terminite_hammer", new ItemLike[]{EndBlocks.TERMINITE.hammer}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation thallasiumAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("thallasium_anvil")).parent(hammer).startDisplay((ItemLike)EndBlocks.THALLASIUM.anvilBlock).endDisplay().addInventoryChangedCriterion("got_thallasium_anvil", new ItemLike[]{EndBlocks.THALLASIUM.anvilBlock}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation thallasiumPlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("thallasium_plate")).parent(thallasiumAnvil).startDisplay((ItemLike)EndBlocks.THALLASIUM.forgedPlate).endDisplay().addInventoryChangedCriterion("got_thallasium_plate", new ItemLike[]{EndBlocks.THALLASIUM.forgedPlate}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation terminiteAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("terminite_anvil")).parent(thallasiumAnvil).startDisplay((ItemLike)EndBlocks.TERMINITE.anvilBlock).endDisplay().addInventoryChangedCriterion("got_terminite_anvil", new ItemLike[]{EndBlocks.TERMINITE.anvilBlock}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation terminitePlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("terminite_plate")).parent(terminiteAnvil).startDisplay((ItemLike)EndBlocks.TERMINITE.forgedPlate).endDisplay().addInventoryChangedCriterion("got_erminite_plate", new ItemLike[]{EndBlocks.TERMINITE.forgedPlate}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation aeterniumAnvil = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_anvil")).parent(terminiteAnvil).startDisplay((ItemLike)EndBlocks.AETERNIUM_ANVIL).frame(FrameType.CHALLENGE).endDisplay().addInventoryChangedCriterion("got_aeternium_anvil", new ItemLike[]{EndBlocks.AETERNIUM_ANVIL}).requirements(RequirementsStrategy.f_15979_).rewardXP(500).build();
        ResourceLocation aeterniumHammerHead = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_hammer_head")).parent(aeterniumAnvil).startDisplay((ItemLike)EndItems.AETERNIUM_HAMMER_HEAD).endDisplay().addInventoryChangedCriterion("got_aeternium_hammer_head", new ItemLike[]{EndItems.AETERNIUM_HAMMER_HEAD}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation aeterniumHammer = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_hammer")).parent(aeterniumHammerHead).startDisplay((ItemLike)EndItems.AETERNIUM_HAMMER).endDisplay().addInventoryChangedCriterion("got_aeternium_hammer", new ItemLike[]{EndItems.AETERNIUM_HAMMER}).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation aeterniumPlate = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_plate")).parent(aeterniumHammer).startDisplay((ItemLike)EndItems.AETERNIUM_FORGED_PLATE).frame(FrameType.GOAL).endDisplay().addInventoryChangedCriterion("got_aeternium_plate", new ItemLike[]{EndItems.AETERNIUM_FORGED_PLATE}).requirements(RequirementsStrategy.f_15979_).rewardXP(200).build();
        ResourceLocation thallasiumArmor = this.addArmor(EndBlocks.THALLASIUM).parent(thallasiumPlate).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation thallasiumHead = this.addToolHeads(EndBlocks.THALLASIUM).parent(thallasiumAnvil).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation thallasium = this.addTools(EndBlocks.THALLASIUM).parent(thallasiumHead).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation terminiteHead = this.addToolHeads(EndBlocks.TERMINITE).parent(terminiteAnvil).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation terminite = this.addTools(EndBlocks.TERMINITE).parent(terminiteHead).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation terminiteArmor = this.addArmor(EndBlocks.TERMINITE).parent(terminitePlate).requirements(RequirementsStrategy.f_15979_).build();
        ResourceLocation aeterniumHead = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_tool_head")).startDisplay((ItemLike)EndItems.AETERNIUM_PICKAXE_HEAD).frame(FrameType.GOAL).endDisplay().parent(aeterniumHammer).addInventoryChangedCriterion("got_aeternium_pickaxe_head", new ItemLike[]{EndItems.AETERNIUM_PICKAXE_HEAD}).addInventoryChangedCriterion("got_aeternium_hoe_head", new ItemLike[]{EndItems.AETERNIUM_HOE_HEAD}).addInventoryChangedCriterion("got_aeternium_axe_head", new ItemLike[]{EndItems.AETERNIUM_AXE_HEAD}).addInventoryChangedCriterion("got_aeternium_shovel_head", new ItemLike[]{EndItems.AETERNIUM_SHOVEL_HEAD}).addInventoryChangedCriterion("got_aeternium_sword_head", new ItemLike[]{EndItems.AETERNIUM_SWORD_BLADE, EndItems.AETERNIUM_SWORD_HANDLE}).requirements(RequirementsStrategy.f_15978_).rewardXP(200).build();
        ResourceLocation aeternium = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_tool")).startDisplay((ItemLike)EndItems.AETERNIUM_PICKAXE).frame(FrameType.CHALLENGE).endDisplay().parent(aeterniumHead).addInventoryChangedCriterion("got_aeternium_pickaxe", new ItemLike[]{EndItems.AETERNIUM_PICKAXE}).addInventoryChangedCriterion("got_aeternium_hoe", new ItemLike[]{EndItems.AETERNIUM_HOE}).addInventoryChangedCriterion("got_aeternium_axe", new ItemLike[]{EndItems.AETERNIUM_AXE}).addInventoryChangedCriterion("got_aeternium_shovel", new ItemLike[]{EndItems.AETERNIUM_SHOVEL}).addInventoryChangedCriterion("got_aeternium_sword", new ItemLike[]{EndItems.AETERNIUM_SWORD}).requirements(RequirementsStrategy.f_15978_).rewardXP(2000).build();
        ResourceLocation aeterniumArmor = AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID("aeternium_armor")).startDisplay((ItemLike)EndItems.AETERNIUM_CHESTPLATE).frame(FrameType.CHALLENGE).endDisplay().parent(aeterniumPlate).addInventoryChangedCriterion("got_aeternium_helmet", new ItemLike[]{EndItems.AETERNIUM_HELMET}).addInventoryChangedCriterion("got_aeternium_chestplate", new ItemLike[]{EndItems.AETERNIUM_CHESTPLATE}).addInventoryChangedCriterion("got_aeternium_leggings", new ItemLike[]{EndItems.AETERNIUM_LEGGINGS}).addInventoryChangedCriterion("got_aeternium_boots", new ItemLike[]{EndItems.AETERNIUM_BOOTS}).requirements(RequirementsStrategy.f_15978_).rewardXP(2000).build();
    }

    AdvancementManager.Builder addTools(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID(mat.name + "_tool")).startDisplay((ItemLike)mat.pickaxe).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_pickaxe", new ItemLike[]{mat.pickaxe}).addInventoryChangedCriterion("got_" + mat.name + "_hoe", new ItemLike[]{mat.hoe}).addInventoryChangedCriterion("got_" + mat.name + "_axe", new ItemLike[]{mat.axe}).addInventoryChangedCriterion("got_" + mat.name + "_shovel", new ItemLike[]{mat.shovel}).addInventoryChangedCriterion("got_" + mat.name + "_sword", new ItemLike[]{mat.sword});
    }

    AdvancementManager.Builder addToolHeads(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID(mat.name + "_tool_head")).startDisplay((ItemLike)mat.pickaxeHead).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_pickaxe_head", new ItemLike[]{mat.pickaxeHead}).addInventoryChangedCriterion("got_" + mat.name + "_hoe_head", new ItemLike[]{mat.hoeHead}).addInventoryChangedCriterion("got_" + mat.name + "_axe_head", new ItemLike[]{mat.axeHead}).addInventoryChangedCriterion("got_" + mat.name + "_shovel_head", new ItemLike[]{mat.shovelHead}).addInventoryChangedCriterion("got_" + mat.name + "_sword_head", new ItemLike[]{mat.swordBlade, mat.swordHandle});
    }

    AdvancementManager.Builder addArmor(MetalMaterial mat) {
        return AdvancementManager.Builder.create((ResourceLocation)BetterEnd.makeID(mat.name + "_armor")).startDisplay((ItemLike)mat.chestplate).endDisplay().addInventoryChangedCriterion("got_" + mat.name + "_helmet", new ItemLike[]{mat.helmet}).addInventoryChangedCriterion("got_" + mat.name + "_chestplate", new ItemLike[]{mat.chestplate}).addInventoryChangedCriterion("got_" + mat.name + "_leggings", new ItemLike[]{mat.leggings}).addInventoryChangedCriterion("got_" + mat.name + "_boots", new ItemLike[]{mat.boots});
    }
}

