/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.structures.piece.BasePiece;

public class NBTPiece
extends BasePiece {
    private ResourceLocation structureID;
    private Rotation rotation;
    private Mirror mirror;
    private StructureTemplate structure;
    private BlockPos pos;
    private int erosion;
    private boolean cover;

    public NBTPiece(ResourceLocation structureID, StructureTemplate structure, BlockPos pos, int erosion, boolean cover, RandomSource random) {
        super(EndStructures.NBT_PIECE, random.m_188502_(), null);
        this.structureID = structureID;
        this.structure = structure;
        this.rotation = Rotation.m_221990_((RandomSource)random);
        this.mirror = Mirror.values()[random.m_188503_(3)];
        this.pos = StructureHelper.offsetPos((BlockPos)pos, (StructureTemplate)structure, (Rotation)this.rotation, (Mirror)this.mirror);
        this.erosion = erosion;
        this.cover = cover;
        this.makeBoundingBox();
    }

    public NBTPiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.NBT_PIECE, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.m_128359_("structureID", this.structureID.toString());
        tag.m_128405_("rotation", this.rotation.ordinal());
        tag.m_128405_("mirror", this.mirror.ordinal());
        tag.m_128405_("erosion", this.erosion);
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        tag.m_128379_("cover", this.cover);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.structureID = new ResourceLocation(tag.m_128461_("structureID"));
        this.rotation = Rotation.values()[tag.m_128451_("rotation")];
        this.mirror = Mirror.values()[tag.m_128451_("mirror")];
        this.erosion = tag.m_128451_("erosion");
        this.pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
        this.cover = tag.m_128471_("cover");
        this.structure = StructureHelper.readStructure((ResourceLocation)this.structureID);
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(blockBox.m_162395_(), this.f_73383_.m_162396_(), blockBox.m_162398_()), (Vec3i)new Vec3i(blockBox.m_162399_(), this.f_73383_.m_162399_(), blockBox.m_162401_()));
        StructurePlaceSettings placementData = new StructurePlaceSettings().m_74379_(this.rotation).m_74377_(this.mirror).m_74381_(bounds);
        this.structure.m_230328_((ServerLevelAccessor)world, this.pos, this.pos, placementData, random, 2);
        if (this.erosion > 0) {
            int x1 = MHelper.min((int)bounds.m_162399_(), (int)this.f_73383_.m_162399_());
            int x0 = MHelper.max((int)bounds.m_162395_(), (int)this.f_73383_.m_162395_());
            int z1 = MHelper.min((int)bounds.m_162401_(), (int)this.f_73383_.m_162401_());
            int z0 = MHelper.max((int)bounds.m_162398_(), (int)this.f_73383_.m_162398_());
            bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(x0, bounds.m_162396_(), z0), (Vec3i)new Vec3i(x1, bounds.m_162400_(), z1));
            StructureErode.erode((WorldGenLevel)world, (BoundingBox)bounds, (int)this.erosion, (RandomSource)random);
        }
        if (this.cover) {
            StructureErode.cover((WorldGenLevel)world, (BoundingBox)bounds, (RandomSource)random, (BlockState)EndBiome.Config.DEFAULT_MATERIAL.getTopMaterial());
        }
    }

    private void makeBoundingBox() {
        this.f_73383_ = StructureHelper.getStructureBounds((BlockPos)this.pos, (StructureTemplate)this.structure, (Rotation)this.rotation, (Mirror)this.mirror);
    }
}

