/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.FluidState;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.structures.piece.BasePiece;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class LakePiece
extends BasePiece {
    private static final BlockState ENDSTONE = Blocks.f_50259_.m_49966_();
    private static final BlockState WATER = Blocks.f_49990_.m_49966_();
    private final Map<Integer, Byte> heightmap = Maps.newHashMap();
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;
    private float aspect;
    private float depth;
    private int seed;
    private ResourceLocation biomeID;

    public LakePiece(BlockPos center, float radius, float depth, RandomSource random, Holder<Biome> biome) {
        super(EndStructures.LAKE_PIECE, random.m_188502_(), null);
        this.center = center;
        this.radius = radius;
        this.depth = depth;
        this.seed = random.m_188502_();
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = radius / depth;
        this.biomeID = BiomeAPI.getBiomeID((Biome)((Biome)biome.m_203334_()));
        this.makeBoundingBox();
    }

    public LakePiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.LAKE_PIECE, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128350_("radius", this.radius);
        tag.m_128350_("depth", this.depth);
        tag.m_128405_("seed", this.seed);
        tag.m_128359_("biome", this.biomeID.toString());
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.radius = tag.m_128457_("radius");
        this.depth = tag.m_128457_("depth");
        this.seed = tag.m_128451_("seed");
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = this.radius / this.depth;
        this.biomeID = new ResourceLocation(tag.m_128461_("biome"));
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int minY = this.f_73383_.m_162396_();
        int maxY = this.f_73383_.m_162400_();
        int sx = SectionPos.m_123223_((int)chunkPos.f_45578_);
        int sz = SectionPos.m_123223_((int)chunkPos.f_45579_);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        for (int x = 0; x < 16; ++x) {
            mut.m_142451_(x);
            int wx = x | sx;
            double nx = (double)wx * 0.1;
            int x2 = wx - this.center.m_123341_();
            for (int z = 0; z < 16; ++z) {
                mut.m_142443_(z);
                int wz = z | sz;
                double nz = (double)wz * 0.1;
                int z2 = wz - this.center.m_123343_();
                float clamp = this.getHeightClamp(world, 8, wx, wz);
                if ((double)clamp < 0.01) continue;
                double n = this.noise.eval(nx, nz) * 1.5 + 1.5;
                double x3 = MHelper.sqr((double)((double)x2 + this.noise.eval(nx, nz, 100.0) * 10.0));
                double z3 = MHelper.sqr((double)((double)z2 + this.noise.eval(nx, nz, -100.0) * 10.0));
                for (int y = maxY; y >= minY; --y) {
                    BlockPos worldPos;
                    BlockState state;
                    mut.m_142448_((int)((double)y + n));
                    double y2 = MHelper.sqr((float)((float)(y - this.center.m_123342_()) * this.aspect));
                    double r2 = this.radius * clamp;
                    double r3 = r2 + 8.0;
                    r2 *= r2;
                    r3 = r3 * r3 + 100.0;
                    double dist = x3 + y2 + z3;
                    if (dist < r2) {
                        state = chunk.m_8055_((BlockPos)mut);
                        if (!state.m_204336_(CommonBlockTags.GEN_END_STONES) && !state.m_60795_()) continue;
                        state = mut.m_123342_() < this.center.m_123342_() ? WATER : f_73382_;
                        chunk.m_6978_((BlockPos)mut, state, false);
                        continue;
                    }
                    if (!(dist <= r3) || mut.m_123342_() >= this.center.m_123342_() || (state = chunk.m_8055_((BlockPos)mut)).m_60838_((BlockGetter)world, worldPos = mut.m_7918_(sx, 0, sz)) || state.m_60796_((BlockGetter)world, worldPos)) continue;
                    state = chunk.m_8055_(mut.m_6630_(3));
                    BlockState stateAbove = chunk.m_8055_(mut.m_7494_());
                    state = stateAbove.m_60795_() && state.m_60795_() ? (random.m_188503_(10) == 0 ? ENDSTONE : EndBiome.findTopMaterial(world, worldPos)) : (stateAbove.m_60795_() ? (random.m_188499_() ? ENDSTONE : EndBiome.findTopMaterial(world, worldPos)) : (state.m_60819_().m_76178_() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.m_49966_()));
                    chunk.m_6978_((BlockPos)mut, state, false);
                }
            }
        }
        this.fixWater(world, chunk, mut, random, sx, sz);
    }

    private void fixWater(WorldGenLevel world, ChunkAccess chunk, BlockPos.MutableBlockPos mut, RandomSource random, int sx, int sz) {
        int minY = this.f_73383_.m_162396_();
        int maxY = this.f_73383_.m_162400_();
        for (int x = 0; x < 16; ++x) {
            mut.m_142451_(x);
            for (int z = 0; z < 16; ++z) {
                mut.m_142443_(z);
                block2: for (int y = minY; y <= maxY; ++y) {
                    mut.m_142448_(y);
                    FluidState state = chunk.m_6425_((BlockPos)mut);
                    if (!state.m_76178_()) {
                        mut.m_142448_(y - 1);
                        if (chunk.m_8055_((BlockPos)mut).m_60795_()) {
                            mut.m_142448_(y + 1);
                            BlockState bState = chunk.m_8055_((BlockPos)mut);
                            bState = bState.m_60795_() ? (random.m_188499_() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.m_7918_(sx, 0, sz))) : (bState.m_60819_().m_76178_() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.m_49966_());
                            mut.m_142448_(y);
                            this.makeEndstonePillar(chunk, mut, bState);
                            continue;
                        }
                        if (x > 1 && x < 15 && z > 1 && z < 15) {
                            mut.m_142448_(y);
                            for (Direction dir : BlocksHelper.HORIZONTAL) {
                                BlockPos wPos = mut.m_7918_(dir.m_122429_(), 0, dir.m_122431_());
                                if (!chunk.m_8055_(wPos).m_60795_()) continue;
                                mut.m_142448_(y + 1);
                                BlockState bState = chunk.m_8055_((BlockPos)mut);
                                bState = bState.m_60795_() ? (random.m_188499_() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.m_7918_(sx, 0, sz))) : (bState.m_60819_().m_76178_() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.m_49966_());
                                mut.m_142448_(y);
                                this.makeEndstonePillar(chunk, mut, bState);
                                continue block2;
                            }
                            continue;
                        }
                        if (!chunk.m_8055_((BlockPos)mut.m_122173_(Direction.UP)).m_60795_()) continue;
                        chunk.m_8113_(mut.m_122173_(Direction.DOWN).m_7949_());
                        continue;
                    }
                    if (!chunk.m_8055_((BlockPos)mut).m_60823_()) continue;
                    chunk.m_8113_(mut.m_7949_());
                }
            }
        }
    }

    private void makeEndstonePillar(ChunkAccess chunk, BlockPos.MutableBlockPos mut, BlockState terrain) {
        chunk.m_6978_((BlockPos)mut, terrain, false);
        mut.m_142448_(mut.m_123342_() - 1);
        while (!chunk.m_6425_((BlockPos)mut).m_76178_()) {
            chunk.m_6978_((BlockPos)mut, ENDSTONE, false);
            mut.m_142448_(mut.m_123342_() - 1);
        }
    }

    private int getHeight(WorldGenLevel world, BlockPos pos) {
        int p = (pos.m_123341_() & 0x7FF) << 11 | pos.m_123343_() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, (byte)-128).byteValue();
        if (h > -128) {
            return h;
        }
        if (!BiomeAPI.getBiomeID((Holder)world.m_204166_(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, (byte)0);
            return 0;
        }
        h = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        h = (h = Mth.m_14040_((int)(h - this.center.m_123342_()))) < 8 ? 1 : 0;
        this.heightmap.put(p, (byte)h);
        return h;
    }

    private float getHeightClamp(WorldGenLevel world, int radius, int posX, int posZ) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int r2 = radius * radius;
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.m_142451_(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.m_142443_(posZ + z);
                int z2 = z * z;
                if (x2 + z2 >= r2) continue;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return Mth.m_14036_((float)(height /= max), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.m_123341_() - this.radius - 8.0f));
        int minY = MHelper.floor((double)((float)this.center.m_123342_() - this.depth - 8.0f));
        int minZ = MHelper.floor((double)((float)this.center.m_123343_() - this.radius - 8.0f));
        int maxX = MHelper.floor((double)((float)this.center.m_123341_() + this.radius + 8.0f));
        int maxY = MHelper.floor((double)((float)this.center.m_123342_() + this.depth));
        int maxZ = MHelper.floor((double)((float)this.center.m_123343_() + this.radius + 8.0f));
        this.f_73383_ = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

