/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplateStructure;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.piece.NBTPiece;

public class EternalPortalStructure
extends TemplateStructure {
    private static final ResourceLocation STRUCTURE_ID = BetterEnd.makeID("portal/eternal_portal");
    private static final StructureTemplate STRUCTURE = StructureHelper.readStructure((ResourceLocation)STRUCTURE_ID);

    public EternalPortalStructure(Structure.StructureSettings s) {
        super(s, List.of(EternalPortalStructure.cfg("portal/eternal_portal", -2, StructurePlacementType.FLOOR, 1.0f)));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!BCLStructure.isValidBiome((Structure.GenerationContext)context)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        long x = (long)chunkPos.f_45578_ * (long)chunkPos.f_45578_;
        long z = (long)chunkPos.f_45579_ * (long)chunkPos.f_45579_;
        if (x + z < 1024L) {
            return Optional.empty();
        }
        if (chunkGenerator.m_214096_(chunkPos.m_151382_(8), chunkPos.m_151391_(8), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, context.f_226624_()) < 5) {
            return Optional.empty();
        }
        return super.m_214086_(context);
    }

    public StructureType<EternalPortalStructure> m_213658_() {
        return EndStructures.ETERNAL_PORTAL.structureType;
    }

    protected int erosion(RandomSource rnd) {
        return rnd.m_188503_(5);
    }

    protected boolean cover(RandomSource rnd) {
        return true;
    }

    protected void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom random = context.f_226626_();
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        int x = chunkPos.m_151382_(8);
        int z = chunkPos.m_151391_(8);
        int y = chunkGenerator.m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, context.f_226624_());
        structurePiecesBuilder.m_142679_((StructurePiece)new NBTPiece(STRUCTURE_ID, STRUCTURE, new BlockPos(x, y - 4, z), random.m_188503_(5), true, (RandomSource)random));
    }

    public static TemplateStructure.Config cfg(String name, int offsetY, StructurePlacementType type, float chance) {
        return new TemplateStructure.Config(BetterEnd.makeID(name), offsetY, type, chance);
    }
}

