/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFBinary;
import org.betterx.bclib.sdf.operator.SDFRadialNoiseMap;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.betterend.world.generator.LayerOptions;

public class IslandLayer {
    private static final RandomSource RANDOM = new LegacyRandomSource(MHelper.RANDOM.nextLong());
    private final SDFRadialNoiseMap noise;
    private final SDF island;
    private final List<BlockPos> positions = new ArrayList<BlockPos>(9);
    private final Map<BlockPos, SDF> islands = Maps.newHashMap();
    private final OpenSimplexNoise density;
    private final int seed;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private final LayerOptions options;

    public IslandLayer(int seed, LayerOptions options) {
        this.density = new OpenSimplexNoise(seed);
        this.options = options;
        this.seed = seed;
        SDF cone1 = IslandLayer.makeCone(0.0f, 0.4f, 0.2f, -0.3f);
        SDF cone2 = IslandLayer.makeCone(0.4f, 0.5f, 0.1f, -0.1f);
        SDF cone3 = IslandLayer.makeCone(0.5f, 0.45f, 0.03f, 0.0f);
        SDF cone4 = IslandLayer.makeCone(0.45f, 0.0f, 0.02f, 0.03f);
        SDFBinary coneBottom = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone1).setSourceB(cone2);
        SDFBinary coneTop = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone3).setSourceB(cone4);
        this.noise = (SDFRadialNoiseMap)new SDFRadialNoiseMap().setSeed((long)seed).setRadius(0.5f).setIntensity(0.2f).setSource((SDF)coneTop);
        this.island = new SDFSmoothUnion().setRadius(0.01f).setSourceA((SDF)this.noise).setSourceB((SDF)coneBottom);
    }

    private int getSeed(int x, int z) {
        int h = this.seed + x * 374761393 + z * 668265263;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    public void updatePositions(double x, double z, int maxHeight) {
        int ix = MHelper.floor((double)(x / (double)this.options.distance));
        int iz = MHelper.floor((double)(z / (double)this.options.distance));
        if (this.lastX != ix || this.lastZ != iz) {
            this.lastX = ix;
            this.lastZ = iz;
            this.positions.clear();
            for (int pox = -1; pox < 2; ++pox) {
                int px = pox + ix;
                for (int poz = -1; poz < 2; ++poz) {
                    int pz = poz + iz;
                    if ((long)px * (long)px + (long)pz * (long)pz <= this.options.centerDist) continue;
                    RANDOM.m_188584_((long)this.getSeed(px, pz));
                    double posX = ((float)px + RANDOM.m_188501_()) * this.options.distance;
                    double posY = MHelper.randRange((float)this.options.minY, (float)this.options.maxY, (RandomSource)RANDOM) * (float)maxHeight;
                    double posZ = ((float)pz + RANDOM.m_188501_()) * this.options.distance;
                    if (!(this.density.eval(posX * 0.01, posZ * 0.01) > (double)this.options.coverage)) continue;
                    this.positions.add(new BlockPos((int)posX, (int)posY, (int)posZ));
                }
            }
        }
        if (GeneratorOptions.hasCentralIsland() && Math.abs(ix) < GeneratorOptions.getIslandDistChunk() && Math.abs(iz) < GeneratorOptions.getIslandDistChunk()) {
            int count = this.positions.size();
            for (int n = 0; n < count; ++n) {
                BlockPos pos = this.positions.get(n);
                long d = (long)pos.m_123341_() * (long)pos.m_123341_() + (long)pos.m_123343_() * (long)pos.m_123343_();
                if (d >= (long)GeneratorOptions.getIslandDistBlockSqr()) continue;
                this.positions.remove(n);
                --count;
                --n;
            }
            if (this.options.hasCentralIsland) {
                this.positions.add(new BlockPos(0, 64, 0));
            }
        }
    }

    private SDF getIsland(BlockPos pos) {
        SDF island = this.islands.get(pos);
        if (island == null) {
            if (pos.m_123341_() == 0 && pos.m_123343_() == 0) {
                island = new SDFScale().setScale(1.3f).setSource(this.island);
            } else {
                RANDOM.m_188584_((long)this.getSeed(pos.m_123341_(), pos.m_123343_()));
                island = new SDFScale().setScale(RANDOM.m_188501_() + 0.5f).setSource(this.island);
            }
            this.islands.put(pos, island);
        }
        this.noise.setOffset(pos.m_123341_(), pos.m_123343_());
        return island;
    }

    private float getRelativeDistance(SDF sdf, BlockPos center, double px, double py, double pz) {
        float x = (float)(px - (double)center.m_123341_()) / this.options.scale;
        float y = (float)(py - (double)center.m_123342_()) / this.options.scale;
        float z = (float)(pz - (double)center.m_123343_()) / this.options.scale;
        return sdf.getDistance(x, y, z);
    }

    private float calculateSDF(double x, double y, double z) {
        float distance = 10.0f;
        for (BlockPos pos : this.positions) {
            SDF island = this.getIsland(pos);
            float dist = this.getRelativeDistance(island, pos, x, y, z);
            distance = MHelper.min((float)distance, (float)dist);
        }
        return distance;
    }

    public float getDensity(double x, double y, double z) {
        return -this.calculateSDF(x, y, z);
    }

    public float getDensity(double x, double y, double z, float height) {
        this.noise.setIntensity(height);
        this.noise.setRadius(0.5f / (1.0f + height));
        return -this.calculateSDF(x, y, z);
    }

    public void clearCache() {
        if (this.islands.size() > 128) {
            this.islands.clear();
        }
    }

    private static SDF makeCone(float radiusBottom, float radiusTop, float height, float minY) {
        float hh = height * 0.5f;
        SDFCappedCone sdf = new SDFCappedCone().setHeight(hh).setRadius1(radiusBottom).setRadius2(radiusTop);
        return new SDFTranslate().setTranslate(0.0f, minY + hh, 0.0f).setSource((SDF)sdf);
    }
}

