/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class PythadendronTreeFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.m_60734_() == EndBlocks.PYTHADENDRON_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };
    private static final Function<BlockState, Boolean> IGNORE = EndBlocks.PYTHADENDRON::isTreeLog;
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (EndBlocks.PYTHADENDRON.isTreeLog(info.getStateUp()) && EndBlocks.PYTHADENDRON.isTreeLog(info.getStateDown())) {
            return EndBlocks.PYTHADENDRON.getLog().m_49966_();
        }
        return info.getState();
    };

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (world.m_8055_(pos.m_7495_()).m_60734_() != EndBlocks.CHORUS_NYLIUM) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        float size = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)4);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.7f, (float)0.0f, (float)0.7f);
        Vector3f last = (Vector3f)spline.get(spline.size() - 1);
        int depth = MHelper.floor((double)((size - 10.0f) * 3.0f / 10.0f + 1.0f));
        float bsize = (10.0f - (size - 10.0f)) / 10.0f + 1.5f;
        this.branch(last.x(), last.y(), last.z(), size * bsize, MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random), random, depth, world, pos);
        SDF function = SplineHelper.buildSDF((List)spline, (float)1.7f, (float)1.1f, bpos -> EndBlocks.PYTHADENDRON.getBark().m_49966_());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursive((ServerLevelAccessor)world, pos);
        return true;
    }

    private void branch(float x, float y, float z, float size, float angle, RandomSource random, int depth, WorldGenLevel world, BlockPos pos) {
        if (depth == 0) {
            return;
        }
        float dx = (float)Math.cos(angle) * size * 0.15f;
        float dz = (float)Math.sin(angle) * size * 0.15f;
        float x1 = x + dx;
        float z1 = z + dz;
        float x2 = x - dx;
        float z2 = z - dz;
        List spline = SplineHelper.makeSpline((float)x, (float)y, (float)z, (float)x1, (float)y, (float)z1, (int)5);
        SplineHelper.powerOffset((List)spline, (float)(size * MHelper.randRange((float)1.0f, (float)2.0f, (RandomSource)random)), (float)4.0f);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.3f, (float)0.0f, (float)0.3f);
        Vector3f pos1 = (Vector3f)spline.get(spline.size() - 1);
        boolean s1 = SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.PYTHADENDRON.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        spline = SplineHelper.makeSpline((float)x, (float)y, (float)z, (float)x2, (float)y, (float)z2, (int)5);
        SplineHelper.powerOffset((List)spline, (float)(size * MHelper.randRange((float)1.0f, (float)2.0f, (RandomSource)random)), (float)4.0f);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.3f, (float)0.0f, (float)0.3f);
        Vector3f pos2 = (Vector3f)spline.get(spline.size() - 1);
        boolean s2 = SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.PYTHADENDRON.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188502_());
        if (depth < 3) {
            if (s1) {
                this.leavesBall(world, pos.m_7918_((int)pos1.x(), (int)pos1.y(), (int)pos1.z()), random, noise);
            }
            if (s2) {
                this.leavesBall(world, pos.m_7918_((int)pos2.x(), (int)pos2.y(), (int)pos2.z()), random, noise);
            }
        }
        float size1 = size * MHelper.randRange((float)0.75f, (float)0.95f, (RandomSource)random);
        float size2 = size * MHelper.randRange((float)0.75f, (float)0.95f, (RandomSource)random);
        float angle1 = angle + 1.5707964f + MHelper.randRange((float)-0.1f, (float)0.1f, (RandomSource)random);
        float angle2 = angle + 1.5707964f + MHelper.randRange((float)-0.1f, (float)0.1f, (RandomSource)random);
        if (s1) {
            this.branch(pos1.x(), pos1.y(), pos1.z(), size1, angle1, random, depth - 1, world, pos);
        }
        if (s2) {
            this.branch(pos2.x(), pos2.y(), pos2.z(), size2, angle2, random, depth - 1, world, pos);
        }
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, RandomSource random, OpenSimplexNoise noise) {
        float radius = MHelper.randRange((float)4.5f, (float)6.5f, (RandomSource)random);
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.PYTHADENDRON_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(6)));
        sphere = new SDFScale3D().setScale(1.0f, 0.6f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.m_188501_() * 3.0f - 1.5f)).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        sphere.addPostProcess(info -> {
            if (random.m_188503_(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.m_60795_()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.PYTHADENDRON.getBark().m_49966_());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.m_142451_(x + info.getPos().m_123341_());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.m_142443_(z + info.getPos().m_123343_());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.m_142448_(y + info.getPos().m_123342_());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.m_60734_() instanceof LeavesBlock) || d >= (distance = ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
    }
}

