/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.features.terrain.caves.EndCaveFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class TunelCaveFeature
extends EndCaveFeature {
    private static int tunnelFloorErrCounter = 0;
    private static int tunnelCeilErrCounter = 0;
    private static int tunnelWallErrCounter = 0;

    private Set<BlockPos> generate(WorldGenLevel world, BlockPos center, RandomSource random) {
        int cz;
        int cx = center.m_123341_() >> 4;
        if ((long)cx * (long)cx + (long)(cz = center.m_123343_() >> 4) + (long)cz < 256L) {
            return Sets.newHashSet();
        }
        int x1 = cx << 4;
        int z1 = cz << 4;
        int x2 = x1 + 16;
        int z2 = z1 + 16;
        LegacyRandomSource rand = new LegacyRandomSource(world.m_7328_());
        OpenSimplexNoise noiseH = new OpenSimplexNoise(rand.m_188502_());
        OpenSimplexNoise noiseV = new OpenSimplexNoise(rand.m_188502_());
        OpenSimplexNoise noiseD = new OpenSimplexNoise(rand.m_188502_());
        Set positions = Sets.newConcurrentHashSet();
        float a = this.hasCaves(world, new BlockPos(x1, 0, z1)) ? 1.0f : 0.0f;
        float b = this.hasCaves(world, new BlockPos(x2, 0, z1)) ? 1.0f : 0.0f;
        float c = this.hasCaves(world, new BlockPos(x1, 0, z2)) ? 1.0f : 0.0f;
        float d = this.hasCaves(world, new BlockPos(x2, 0, z2)) ? 1.0f : 0.0f;
        ChunkAccess chunk = world.m_6325_(cx, cz);
        IntStream.range(0, 256).parallel().forEach(index -> {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int x = index & 0xF;
            int z = index >> 4;
            int wheight = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
            float dx = (float)x / 16.0f;
            float dz = (float)z / 16.0f;
            pos.m_142451_(x + x1);
            pos.m_142443_(z + z1);
            float da = Mth.m_14179_((float)dx, (float)a, (float)b);
            float db = Mth.m_14179_((float)dx, (float)c, (float)d);
            float density = 1.0f - Mth.m_14179_((float)dz, (float)da, (float)db);
            if ((double)density < 0.5) {
                for (int y = 0; y < wheight; ++y) {
                    float dist;
                    pos.m_142448_(y);
                    float gradient = 1.0f - Mth.m_14036_((float)((float)(wheight - y) * 0.1f), (float)0.0f, (float)1.0f);
                    if ((double)gradient > 0.5) break;
                    float val = Mth.m_14154_((float)((float)noiseH.eval((double)pos.m_123341_() * 0.02, (double)y * 0.01, (double)pos.m_123343_() * 0.02)));
                    float vert = Mth.m_14031_((float)(((float)y + (float)noiseV.eval((double)pos.m_123341_() * 0.01, (double)pos.m_123343_() * 0.01) * 20.0f) * 0.1f)) * 0.9f;
                    if (!((double)(val = val + vert * vert + (dist = (float)noiseD.eval((double)pos.m_123341_() * 0.1, (double)y * 0.1, (double)pos.m_123343_() * 0.1) * 0.12f) + density + gradient) < 0.15) || !world.m_8055_((BlockPos)pos).m_204336_(CommonBlockTags.GEN_END_STONES) || !this.noWaterNear(world, (BlockPos)pos)) continue;
                    positions.add(pos.m_7949_());
                }
            }
        });
        positions.forEach(bpos -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)CAVE_AIR));
        return positions;
    }

    private boolean noWaterNear(WorldGenLevel world, BlockPos pos) {
        BlockPos above1 = pos.m_7494_();
        BlockPos above2 = pos.m_6630_(2);
        if (!world.m_6425_(above1).m_76178_() || !world.m_6425_(above2).m_76178_()) {
            return false;
        }
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            if (!world.m_6425_(above1.m_121945_(dir)).m_76178_()) {
                return false;
            }
            if (world.m_6425_(above2.m_121945_(dir)).m_76178_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (pos.m_123341_() * pos.m_123341_() + pos.m_123343_() * pos.m_123343_() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        Set<BlockPos> caveBlocks = this.generate(world, pos, random);
        if (caveBlocks.isEmpty()) {
            return false;
        }
        ChunkGenerator generator = featureConfig.m_159775_();
        HashMap floorSets = Maps.newHashMap();
        HashMap ceilSets = Maps.newHashMap();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        HashSet remove = Sets.newHashSet();
        caveBlocks.forEach(bpos -> {
            mut.m_122190_((Vec3i)bpos);
            BiomePicker.ActualBiome bio = EndBiomes.getCaveBiome(bpos.m_123341_(), bpos.m_123343_());
            int height = world.m_6924_(Heightmap.Types.WORLD_SURFACE, bpos.m_123341_(), bpos.m_123343_());
            if (mut.m_123342_() >= height) {
                remove.add(bpos);
            } else if (world.m_8055_((BlockPos)mut).m_247087_()) {
                mut.m_142448_(bpos.m_123342_() - 1);
                if (world.m_8055_((BlockPos)mut).m_204336_(CommonBlockTags.GEN_END_STONES)) {
                    Set floorPositions = (Set)floorSets.get(bio);
                    if (floorPositions == null) {
                        floorPositions = Sets.newHashSet();
                        floorSets.put(bio, floorPositions);
                    }
                    floorPositions.add(mut.m_7949_());
                }
                mut.m_142448_(bpos.m_123342_() + 1);
                if (world.m_8055_((BlockPos)mut).m_204336_(CommonBlockTags.GEN_END_STONES)) {
                    Set ceilPositions = (Set)ceilSets.get(bio);
                    if (ceilPositions == null) {
                        ceilPositions = Sets.newHashSet();
                        ceilSets.put(bio, ceilPositions);
                    }
                    ceilPositions.add(mut.m_7949_());
                }
                this.setBiome(world, (BlockPos)bpos, bio);
            }
        });
        caveBlocks.removeAll(remove);
        if (caveBlocks.isEmpty()) {
            return true;
        }
        floorSets.forEach((biome, floorPositions) -> {
            BCLBiome patt7844$temp = biome.bclBiome;
            if (patt7844$temp instanceof EndCaveBiome) {
                EndCaveBiome caveBiome = (EndCaveBiome)patt7844$temp;
                BlockState surfaceBlock = EndBiome.findTopMaterial(biome.bclBiome);
                this.placeFloor(world, generator, caveBiome, (Set<BlockPos>)floorPositions, random, surfaceBlock);
            } else if (Configs.MAIN_CONFIG.verboseLogging() && tunnelFloorErrCounter < 25) {
                ++tunnelFloorErrCounter;
                BetterEnd.LOGGER.error(biome.bclBiome.getID() + " is not an EndCaveBiome. Unable to place Tunnel Floor");
            }
        });
        ceilSets.forEach((biome, ceilPositions) -> {
            BCLBiome patt8426$temp = biome.bclBiome;
            if (patt8426$temp instanceof EndCaveBiome) {
                EndCaveBiome caveBiome = (EndCaveBiome)patt8426$temp;
                this.placeCeil(world, generator, caveBiome, (Set<BlockPos>)ceilPositions, random);
            } else if (Configs.MAIN_CONFIG.verboseLogging() && tunnelCeilErrCounter < 25) {
                ++tunnelCeilErrCounter;
                BetterEnd.LOGGER.error(biome.bclBiome.getID() + " is not an EndCaveBiome. Unable to place Tunnel Ceiling");
            }
        });
        BiomePicker.ActualBiome biome2 = EndBiomes.getCaveBiome(pos.m_123341_(), pos.m_123343_());
        BCLBiome bCLBiome = biome2.bclBiome;
        if (bCLBiome instanceof EndCaveBiome) {
            EndCaveBiome caveBiome = (EndCaveBiome)bCLBiome;
            this.placeWalls(world, generator, caveBiome, caveBlocks, random);
        } else if (Configs.MAIN_CONFIG.verboseLogging() && tunnelWallErrCounter < 25) {
            ++tunnelWallErrCounter;
            BetterEnd.LOGGER.error(biome2.bclBiome.getID() + " is not an EndCaveBiome. Unable to place Tunnel Walls");
        }
        this.fixBlocks(world, caveBlocks);
        return true;
    }

    @Override
    protected Set<BlockPos> generate(WorldGenLevel world, BlockPos center, int radius, RandomSource random) {
        return null;
    }

    @Override
    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity() * 0.2f;
        floorPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            if (!surfaceBlock.m_60713_(Blocks.f_50259_)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            }
            if (density > 0.0f && random.m_188501_() <= density && (feature = biome.getFloorFeature(random)) != null && feature.m_203633_()) {
                ((ConfiguredFeature)feature.m_203334_()).m_224953_(world, generator, random, pos.m_7494_());
            }
        });
    }

    @Override
    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity() * 0.2f;
        ceilPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.m_188501_() <= density && (feature = biome.getCeilFeature(random)) != null && feature.m_203633_()) {
                ((ConfiguredFeature)feature.m_203334_()).m_224953_(world, generator, random, pos.m_7495_());
            }
        });
    }

    protected boolean hasCaves(WorldGenLevel world, BlockPos pos) {
        return this.hasCavesInBiome(world, pos.m_7918_(-8, 0, -8)) && this.hasCavesInBiome(world, pos.m_7918_(8, 0, -8)) && this.hasCavesInBiome(world, pos.m_7918_(-8, 0, 8)) && this.hasCavesInBiome(world, pos.m_7918_(8, 0, 8));
    }

    protected boolean hasCavesInBiome(WorldGenLevel world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        BCLBiome bclBiome = BiomeAPI.getBiome((Holder)biome);
        if (bclBiome instanceof EndBiome) {
            EndBiome endBiome = (EndBiome)bclBiome;
            return endBiome.hasCaves();
        }
        return true;
    }
}

