/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;

public class SulphurHillFeature
extends DefaultFeature {
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        pos = SulphurHillFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos);
        if (pos.m_123342_() < 57 || pos.m_123342_() > 70) {
            return false;
        }
        int count = MHelper.randRange((int)5, (int)13, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        for (int i = 0; i < count; ++i) {
            int pz;
            int dist = count - i;
            int px = pos.m_123341_() + MHelper.floor((double)(random.m_188583_() * (double)dist * 0.6 + 0.5));
            int py = SulphurHillFeature.getYOnSurface((WorldGenLevel)world, (int)px, (int)(pz = pos.m_123343_() + MHelper.floor((double)(random.m_188583_() * (double)dist * 0.6 + 0.5))));
            if (py <= 56 || py - pos.m_123342_() > count) continue;
            this.makeCircle(world, new BlockPos(px, py, pz), noise, random);
        }
        return true;
    }

    private void makeCircle(WorldGenLevel world, BlockPos pos, OpenSimplexNoise noise, RandomSource random) {
        int radius = MHelper.randRange((int)5, (int)9, (RandomSource)random);
        int min = -radius - 3;
        int max = radius + 4;
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockState rock = EndBlocks.SULPHURIC_ROCK.stone.m_49966_();
        BlockState brimstone = (BlockState)EndBlocks.BRIMSTONE.m_49966_().m_61124_((Property)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        for (int x = min; x < max; ++x) {
            int x2 = x * x;
            int px = pos.m_123341_() + x;
            mut.m_142451_(px);
            for (int z = min; z < max; ++z) {
                int i;
                int maxIt;
                int z2 = z * z;
                int pz = pos.m_123343_() + z;
                mut.m_142443_(pz);
                double r1 = (double)radius * (noise.eval((double)px * 0.1, (double)pz * 0.1) * 0.2 + 0.8);
                double r2 = r1 - 1.5;
                double r3 = r1 - 3.0;
                int d = x2 + z2;
                mut.m_142448_(pos.m_123342_());
                BlockState state = world.m_8055_((BlockPos)mut);
                if (!state.m_247087_() && !state.m_60713_(EndBlocks.HYDROTHERMAL_VENT)) continue;
                if ((double)d < r2 * r2) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_49990_);
                    mut.m_122173_(Direction.DOWN);
                    if ((double)d < r3 * r3) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_49990_);
                        mut.m_122173_(Direction.DOWN);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)brimstone);
                    mut.m_122173_(Direction.DOWN);
                    state = world.m_8055_((BlockPos)mut);
                    maxIt = MHelper.floor((double)(10.0 - Math.sqrt(d))) + random.m_188503_(1);
                    for (i = 0; i < maxIt && state.m_247087_(); ++i) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                        mut.m_122173_(Direction.DOWN);
                    }
                    continue;
                }
                if (!((double)d < r1 * r1)) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)brimstone);
                mut.m_122173_(Direction.DOWN);
                state = world.m_8055_((BlockPos)mut);
                maxIt = MHelper.floor((double)(10.0 - Math.sqrt(d))) + random.m_188503_(1);
                for (i = 0; i < maxIt && state.m_247087_(); ++i) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                    mut.m_122173_(Direction.DOWN);
                }
            }
        }
    }
}

