/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.mojang.math.Axis;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFCoordModify;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFInvert;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFFlatland;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.HydrothermalVentBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.features.terrain.SulphuricLakeFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class GeyserFeature
extends DefaultFeature {
    protected static final Function<BlockState, Boolean> REPLACE1;
    protected static final Function<BlockState, Boolean> REPLACE2;
    private static final Function<BlockState, Boolean> IGNORE;
    private static final Direction[] HORIZONTAL;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        int i;
        RandomSource random = featureConfig.m_225041_();
        WorldGenLevel world = featureConfig.m_159774_();
        BlockPos pos = GeyserFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)featureConfig.m_159777_());
        ChunkGenerator chunkGenerator = featureConfig.m_159775_();
        if (pos.m_123342_() < 10) {
            return false;
        }
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        bpos.m_142448_(bpos.m_123342_() - 1);
        BlockState state = world.m_8055_((BlockPos)bpos);
        while (state.m_204336_(CommonBlockTags.GEN_END_STONES) || !state.m_60819_().m_76178_() && bpos.m_123342_() > 5) {
            bpos.m_142448_(bpos.m_123342_() - 1);
            state = world.m_8055_((BlockPos)bpos);
        }
        if (pos.m_123342_() - bpos.m_123342_() < 25) {
            return false;
        }
        int halfHeight = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        float radius1 = (float)halfHeight * 0.5f;
        float radius2 = (float)halfHeight * 0.1f + 0.5f;
        SDFPrimitive sdf = new SDFCappedCone().setHeight((float)halfHeight).setRadius1(radius1).setRadius2(radius2).setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        sdf = new SDFTranslate().setTranslate(0.0f, (float)(halfHeight - 3), 0.0f).setSource((SDF)sdf);
        int count = halfHeight;
        for (int i2 = 0; i2 < count; ++i2) {
            int py = i2 << 1;
            float delta = (float)i2 / (float)(count - 1);
            float radius = Mth.m_14179_((float)delta, (float)radius1, (float)radius2) * 1.3f;
            SDFPrimitive bowl = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(EndBlocks.SULPHURIC_ROCK.stone);
            SDFPrimitive brimstone = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(EndBlocks.BRIMSTONE);
            brimstone = new SDFTranslate().setTranslate(0.0f, 2.0f, 0.0f).setSource((SDF)brimstone);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)brimstone);
            bowl = new SDFUnion().setSourceA((SDF)brimstone).setSourceB((SDF)bowl);
            Direction[] water = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(Blocks.f_49990_);
            water = new SDFTranslate().setTranslate(0.0f, 4.0f, 0.0f).setSource((SDF)water);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)water);
            bowl = new SDFUnion().setSourceA((SDF)water).setSourceB((SDF)bowl);
            OpenSimplexNoise noise1 = new OpenSimplexNoise(random.m_188505_());
            OpenSimplexNoise noise2 = new OpenSimplexNoise(random.m_188505_());
            bowl = new SDFCoordModify().setFunction(vec -> {
                float dx = (float)noise1.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1);
                float dz = (float)noise2.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1);
                vec.set(vec.x() + dx, vec.y(), vec.z() + dz);
            }).setSource((SDF)bowl);
            SDFPrimitive cut = new SDFFlatland().setBlock(Blocks.f_50016_);
            cut = new SDFInvert().setSource((SDF)cut);
            cut = new SDFTranslate().setTranslate(0.0f, radius - 2.0f, 0.0f).setSource((SDF)cut);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)cut);
            bowl = new SDFTranslate().setTranslate(radius, (float)py - radius, 0.0f).setSource((SDF)bowl);
            bowl = new SDFRotation().setRotation(Axis.f_252436_, (float)i2 * 4.0f).setSource((SDF)bowl);
            sdf = new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)bowl);
        }
        sdf.setReplaceFunction(REPLACE2).fillRecursive((ServerLevelAccessor)world, pos);
        radius2 *= 0.5f;
        if (radius2 < 0.7f) {
            radius2 = 0.7f;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        SDFCappedCone obj1 = new SDFCappedCone().setHeight((float)(halfHeight + 5)).setRadius1(radius1 * 0.5f).setRadius2(radius2);
        sdf = new SDFTranslate().setTranslate(0.0f, (float)(halfHeight - 13), 0.0f).setSource((SDF)obj1);
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.x() * 0.3f, vec.y() * 0.3f, vec.z() * 0.3f) * 0.5f)).setSource((SDF)sdf);
        SDFSphere obj2 = new SDFSphere().setRadius(radius1);
        SDFUnary cave = new SDFScale3D().setScale(1.5f, 1.0f, 1.5f).setSource((SDF)obj2);
        cave = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.x() * 0.1f, vec.y() * 0.1f, vec.z() * 0.1f) * 2.0f)).setSource((SDF)cave);
        cave = new SDFTranslate().setTranslate(0.0f, (float)(-halfHeight - 10), 0.0f).setSource((SDF)cave);
        sdf = new SDFSmoothUnion().setRadius(5.0f).setSourceA((SDF)cave).setSourceB((SDF)sdf);
        obj1.setBlock(WATER);
        obj2.setBlock(WATER);
        sdf.setReplaceFunction(REPLACE2);
        sdf.fillRecursive((ServerLevelAccessor)world, pos);
        obj1.setBlock(EndBlocks.BRIMSTONE);
        obj2.setBlock(EndBlocks.BRIMSTONE);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-2.0f)).setSource((SDF)sdf).setReplaceFunction(REPLACE1).fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        obj1.setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        obj2.setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-4.0f)).setSource((SDF)cave).setReplaceFunction(REPLACE1).fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        obj1.setBlock(Blocks.f_50259_);
        obj2.setBlock(Blocks.f_50259_);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-6.0f)).setSource((SDF)cave).setReplaceFunction(REPLACE1).fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)WATER);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        count = GeyserFeature.getYOnSurface((WorldGenLevel)world, (int)pos.m_123341_(), (int)pos.m_123343_()) - pos.m_123342_();
        for (i = 0; i < count; ++i) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)WATER);
            for (Direction dir : BlocksHelper.HORIZONTAL) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut.m_121945_(dir), (BlockState)WATER);
            }
            mut.m_142448_(mut.m_123342_() + 1);
        }
        for (i = 0; i < 150; ++i) {
            mut.m_122190_((Vec3i)pos).m_122184_(MHelper.floor((double)(random.m_188583_() * 4.0 + 0.5)), -halfHeight - 10, MHelper.floor((double)(random.m_188583_() * 4.0 + 0.5)));
            float distRaw = MHelper.length((float)(mut.m_123341_() - pos.m_123341_()), (float)(mut.m_123343_() - pos.m_123343_()));
            int dist = MHelper.floor((double)(6.0f - distRaw)) + random.m_188503_(2);
            if (dist < 0) continue;
            state = world.m_8055_((BlockPos)mut);
            while (!state.m_60819_().m_76178_() || state.m_204336_(CommonBlockTags.WATER_PLANT)) {
                mut.m_142448_(mut.m_123342_() - 1);
                state = world.m_8055_((BlockPos)mut);
            }
            if (!state.m_204336_(CommonBlockTags.GEN_END_STONES) || world.m_8055_(mut.m_7494_()).m_60713_(EndBlocks.HYDROTHERMAL_VENT)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                MHelper.shuffle((Object[])HORIZONTAL, (RandomSource)random);
                for (Direction dir : HORIZONTAL) {
                    BlockPos p = mut.m_121945_(dir);
                    if (!random.m_188499_() || !world.m_8055_(p).m_60713_(Blocks.f_49990_)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)EndBlocks.TUBE_WORM.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir)));
                }
                mut.m_142448_(mut.m_123342_() + 1);
            }
            state = (BlockState)EndBlocks.HYDROTHERMAL_VENT.m_49966_().m_61124_((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
            mut.m_142448_(mut.m_123342_() + 1);
            state = world.m_8055_((BlockPos)mut);
            while (state.m_60713_(Blocks.f_49990_)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.m_49966_());
                mut.m_142448_(mut.m_123342_() + 1);
                state = world.m_8055_((BlockPos)mut);
            }
        }
        for (i = 0; i < 10; ++i) {
            mut.m_122190_((Vec3i)pos).m_122184_(MHelper.floor((double)(random.m_188583_() * 0.7 + 0.5)), -halfHeight - 10, MHelper.floor((double)(random.m_188583_() * 0.7 + 0.5)));
            float distRaw = MHelper.length((float)(mut.m_123341_() - pos.m_123341_()), (float)(mut.m_123343_() - pos.m_123343_()));
            int dist = MHelper.floor((double)(6.0f - distRaw)) + random.m_188503_(2);
            if (dist < 0) continue;
            state = world.m_8055_((BlockPos)mut);
            while (state.m_60713_(Blocks.f_49990_)) {
                mut.m_142448_(mut.m_123342_() - 1);
                state = world.m_8055_((BlockPos)mut);
            }
            if (!state.m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                mut.m_142448_(mut.m_123342_() + 1);
            }
            state = (BlockState)EndBlocks.HYDROTHERMAL_VENT.m_49966_().m_61124_((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
            mut.m_142448_(mut.m_123342_() + 1);
            state = world.m_8055_((BlockPos)mut);
            while (state.m_60713_(Blocks.f_49990_)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.m_49966_());
                mut.m_142448_(mut.m_123342_() + 1);
                state = world.m_8055_((BlockPos)mut);
            }
        }
        ((SulphuricLakeFeature)EndFeatures.SULPHURIC_LAKE.getFeature()).m_142674_((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(Optional.empty(), world, chunkGenerator, random, pos, null));
        double distance = (double)radius1 * 1.7;
        BlockPos start = pos.m_7918_((int)(-distance), (int)((double)(-halfHeight - 15) - distance), (int)(-distance));
        BlockPos end = pos.m_7918_((int)distance, (int)((double)(-halfHeight - 5) + distance), (int)distance);
        BlockFixer.fixBlocks((LevelAccessor)world, start, end);
        return true;
    }

    static {
        HORIZONTAL = BlocksHelper.makeHorizontal();
        REPLACE1 = state -> state.m_60795_() || state.m_204336_(CommonBlockTags.GEN_END_STONES);
        REPLACE2 = state -> {
            if (state.m_204336_(CommonBlockTags.GEN_END_STONES) || state.m_60713_(EndBlocks.HYDROTHERMAL_VENT) || state.m_60713_(EndBlocks.SULPHUR_CRYSTAL)) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
        IGNORE = state -> state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50627_) || state.m_60713_(EndBlocks.SULPHURIC_ROCK.stone) || state.m_60713_(EndBlocks.BRIMSTONE);
    }
}

