/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.InvertedScatterFeature;
import org.betterx.betterend.world.features.VineFeatureConfig;

public class VineFeature
extends InvertedScatterFeature<VineFeatureConfig> {
    private BlockState plant;
    boolean vine;

    public VineFeature() {
        super(VineFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(VineFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        this.plant = cfg.getPlantState(random, blockPos);
        BlockState state = world.m_8055_(blockPos);
        return state.m_247087_() && this.canPlaceBlock(state, world, blockPos);
    }

    @Override
    public void generate(VineFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        int h = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)blockPos, (int)random.m_188503_(cfg.maxLength)) - 1;
        if (h > 2) {
            BlockState top = this.getTopState();
            BlockState middle = this.getMiddleState();
            BlockState bottom = this.getBottomState();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)top);
            for (int i = 1; i < h; ++i) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.m_6625_(i), (BlockState)middle);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.m_6625_(h), (BlockState)bottom);
        }
    }

    private boolean canPlaceBlock(BlockState state, WorldGenLevel world, BlockPos blockPos) {
        if (this.plant == null) {
            return false;
        }
        Block block = this.plant.m_60734_();
        if (block instanceof BaseVineBlock) {
            BaseVineBlock vineBlock = (BaseVineBlock)block;
            this.vine = true;
            return vineBlock.canGenerate(state, (LevelReader)world, blockPos);
        }
        this.vine = false;
        return this.plant.m_60734_().m_7898_(state, (LevelReader)world, blockPos);
    }

    private BlockState getTopState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP) : state;
    }

    private BlockState getMiddleState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE) : state;
    }

    private BlockState getBottomState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM) : state;
    }
}

