/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.levelgen.structures.templatesystem.DestructionStructureProcessor;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.NBTFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public abstract class NBTFeature<FC extends NBTFeatureConfig>
extends Feature<FC> {
    protected static final DestructionStructureProcessor DESTRUCTION = new DestructionStructureProcessor();

    public NBTFeature(Codec<FC> codec) {
        super(codec);
    }

    protected abstract StructureTemplate getStructure(FC var1, WorldGenLevel var2, BlockPos var3, RandomSource var4);

    protected abstract boolean canSpawn(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract Rotation getRotation(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract Mirror getMirror(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract int getYOffset(StructureTemplate var1, WorldGenLevel var2, BlockPos var3, RandomSource var4);

    protected abstract TerrainMerge getTerrainMerge(WorldGenLevel var1, BlockPos var2, RandomSource var3);

    protected abstract void addStructureData(StructurePlaceSettings var1);

    protected BlockPos getGround(WorldGenLevel world, BlockPos center) {
        Holder biome = world.m_204166_(center);
        ResourceLocation id = BiomeAPI.getBiomeID((Holder)biome);
        if (id.m_135827_().contains("moutain") || id.m_135827_().contains("lake")) {
            int y = this.getAverageY(world, center);
            return new BlockPos(center.m_123341_(), y, center.m_123343_());
        }
        int y = this.getAverageYWG(world, center);
        return new BlockPos(center.m_123341_(), y, center.m_123343_());
    }

    protected int getAverageY(WorldGenLevel world, BlockPos center) {
        int y = DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)center.m_123341_(), (int)center.m_123343_());
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.m_123341_() - 2), (int)(center.m_123343_() - 2));
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.m_123341_() + 2), (int)(center.m_123343_() - 2));
        y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.m_123341_() - 2), (int)(center.m_123343_() + 2));
        return (y += DefaultFeature.getYOnSurface((WorldGenLevel)world, (int)(center.m_123341_() + 2), (int)(center.m_123343_() + 2))) / 5;
    }

    protected int getAverageYWG(WorldGenLevel world, BlockPos center) {
        int y = DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)center.m_123341_(), (int)center.m_123343_());
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.m_123341_() - 2), (int)(center.m_123343_() - 2));
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.m_123341_() + 2), (int)(center.m_123343_() - 2));
        y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.m_123341_() - 2), (int)(center.m_123343_() + 2));
        return (y += DefaultFeature.getYOnSurfaceWG((WorldGenLevel)world, (int)(center.m_123341_() + 2), (int)(center.m_123343_() + 2))) / 5;
    }

    public boolean m_142674_(FeaturePlaceContext<FC> context) {
        NBTFeatureConfig cfg = (NBTFeatureConfig)context.m_159778_();
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos center = context.m_159777_();
        center = new BlockPos(center.m_123341_() >> 4 << 4 | 8, 128, center.m_123343_() >> 4 << 4 | 8);
        if (!this.canSpawn(world, center = this.getGround(world, center), random)) {
            return false;
        }
        int posY = center.m_123342_() + 1;
        StructureTemplate structure = this.getStructure(cfg, world, center, random);
        Rotation rotation = this.getRotation(world, center, random);
        Mirror mirror = this.getMirror(world, center, random);
        BlockPos offset = StructureTemplate.m_74593_((BlockPos)new BlockPos(structure.m_163801_()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.f_121853_);
        center = center.m_7918_(0, (int)((double)this.getYOffset(structure, world, center, random) + 0.5), 0);
        BoundingBox bounds = this.makeBox(center);
        StructurePlaceSettings placementData = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74381_(bounds);
        this.addStructureData(placementData);
        center = center.m_7918_((int)((double)(-offset.m_123341_()) * 0.5), 0, (int)((double)(-offset.m_123343_()) * 0.5));
        structure.m_230328_((ServerLevelAccessor)world, center, center, placementData, random, 4);
        TerrainMerge merge = this.getTerrainMerge(world, center, random);
        int x1 = center.m_123341_();
        int z1 = center.m_123343_();
        int x2 = x1 + offset.m_123341_();
        int z2 = z1 + offset.m_123343_();
        if (merge != TerrainMerge.NONE) {
            int a;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            if (x2 < x1) {
                a = x1;
                x1 = x2;
                x2 = a;
            }
            if (z2 < z1) {
                a = z1;
                z1 = z2;
                z2 = a;
            }
            int surfMax = posY - 1;
            for (int x = x1; x <= x2; ++x) {
                mut.m_142451_(x);
                block1: for (int z = z1; z <= z2; ++z) {
                    mut.m_142443_(z);
                    mut.m_142448_(surfMax);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (this.isTerrain(state) || !state.m_60783_((BlockGetter)world, (BlockPos)mut, Direction.DOWN)) continue;
                    for (int i = 0; i < 10; ++i) {
                        mut.m_142448_(mut.m_123342_() - 1);
                        BlockState stateSt = world.m_8055_((BlockPos)mut);
                        if (!this.isTerrain(stateSt)) {
                            if (merge == TerrainMerge.SURFACE) {
                                boolean isTop = mut.m_123342_() == surfMax && state.m_280296_();
                                Holder b = world.m_204166_((BlockPos)mut);
                                BlockState top = (isTop ? BiomeAPI.findTopMaterial((Holder)b) : BiomeAPI.findUnderMaterial((Holder)b)).orElse(cfg.defaultBlock);
                                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                                continue;
                            }
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
                            continue;
                        }
                        if (!this.isTerrain(state) || !state.m_280296_()) continue block1;
                        if (merge == TerrainMerge.SURFACE) {
                            Holder b = world.m_204166_((BlockPos)mut);
                            BlockState bottom = BiomeAPI.findUnderMaterial((Holder)b).orElse(cfg.defaultBlock);
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                            continue block1;
                        }
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
                        continue block1;
                    }
                }
            }
        }
        return true;
    }

    private boolean isTerrain(BlockState state) {
        return state.m_204336_(CommonBlockTags.END_STONES) || state.m_204336_(CommonBlockTags.NETHER_STONES);
    }

    protected BoundingBox makeBox(BlockPos pos) {
        int sx = (pos.m_123341_() >> 4 << 4) - 16;
        int sz = (pos.m_123343_() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return BoundingBox.m_162375_((Vec3i)new Vec3i(sx, 0, sz), (Vec3i)new Vec3i(ex, 255, ez));
    }

    public static enum TerrainMerge implements StringRepresentable
    {
        NONE,
        SURFACE,
        OBJECT;

        public static final Codec<TerrainMerge> CODEC;

        public static TerrainMerge getFromString(String type) {
            if (type.equals("surface")) {
                return SURFACE;
            }
            if (type.equals("object")) {
                return OBJECT;
            }
            return NONE;
        }

        public String m_7912_() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.m_216439_(TerrainMerge::values);
        }
    }
}

