/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.DoublePlantFeatureConfig;
import org.betterx.betterend.world.features.ScatterFeature;

public class DoublePlantFeature
extends ScatterFeature<DoublePlantFeatureConfig> {
    private BlockState plant;

    public DoublePlantFeature() {
        super(DoublePlantFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(DoublePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        float d = MHelper.length((float)(center.m_123341_() - blockPos.m_123341_()), (float)(center.m_123343_() - blockPos.m_123343_())) / radius * 0.6f + random.m_188501_() * 0.4f;
        this.plant = d < 0.5f ? cfg.getLargePlantState(random, blockPos) : cfg.getSmallPlantState(random, blockPos);
        return this.plant.m_60734_().m_7898_(this.plant, (LevelReader)world, blockPos);
    }

    @Override
    public void generate(DoublePlantFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        if (this.plant.m_60734_() instanceof BaseDoublePlantBlock) {
            int rot = random.m_188503_(4);
            BlockState state = (BlockState)this.plant.m_61124_((Property)BaseDoublePlantBlock.ROTATION, (Comparable)Integer.valueOf(rot));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)state);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)BaseDoublePlantBlock.TOP, (Comparable)Boolean.valueOf(true))));
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)this.plant);
        }
    }
}

